/* Program Name: v_putstr.c  
* Author: Chuck Forsyth  
*------------------------------------------------------------------------* 
* Created: 8/24/1988 at 17:39 
*                 
*                 
* Syntax :  V_PUTSTR(<EXPN1>,<EXPN2>,<EXPC3>,[<EXPC4>]      
*                 	  
*  The first two numeric expressions are the row and column that you
*  wish the character expression <EXPC3> to be displayed on the crt.               						
*	The last optional expression is a character expression which
*	is a standard Clipper attribute string, e.g., 'W+/R'.
*	The string will be written directly to video memory.
*  This function calls another function, deccolor(), which was
*  written by Paul McDonald, the author of the BREEZE windowing
*  library for Clipper. The source for that function has been slightly
*  modified by me, and has been included here with Paul's permission.
*
*  Returns:
*  The column position of the character which would immediately follow
*  the string. This is a virtual cursor position, if you will. If you
*  have an 80 column screen and you say 'c = v_putstr(row,0,space(80))'
*  c will be equal to 80. This is obviously because of the 0 based
*  row-column coordinate system.
*
*........................................................................* 
* Revision: 1.0 Last Revised: 8/24/1988 at 17:39
* Description: Original Creation.
*.........................................................................
*---------------------------- ALL RIGHTS RESERVED -----------------------*/
#include    "nandef.h"
#include    "extend.h"

/*-----------------------------------------------------------------------

   row - cursor column position.
   col - cursor row position.
   str - string variable
   attr - optional attribute byte
   format - v_putstr(col,row,str,[attr])

-------------------------------------------------------------------------*/
extern   int   _colord;		/*Clipper driver dependent symbols */
extern   int   _maxcol;
CLIPPER v_putstr()

{
int   offset,
      row;
register int col;
register char  *ptr_scrn,
               *string;
byte  attr;
int   not_valid_argument,col_max;
long  vid_segment;

      not_valid_argument = FALSE;
      /* this will be used to determine what attribute to use */

      vid_segment = ( _colord == 1 ? 0x0b800 : 0xb000 );
      ptr_scrn = ( (char *) (vid_segment << 16) );

if(PCOUNT > 4  ||  PCOUNT < 3  ||  !ISCHAR(3) )
	{
   _retni(0);
	}else
	{
   row = _parni(1);
   col = _parni(2);
   col_max = _maxcol+1;

   offset=(row*160)+(col<<1);            /* compute the byte offset */
   ptr_scrn = (ptr_scrn + offset);       /* add screen offset to get start position */
   string = _parc(3);
   /* get the string to be displayed */
   switch(PCOUNT)
   {
   case 4:
     if( !ISCHAR(4))
        not_valid_argument = TRUE;
     else
     {
     attr = ((byte)(deccolor(_parc(4))) ); 
     }
     break;
   default:
   ;
   }

   while( *string++ && (col++ < (col_max) ) )
   /* check to make sure that the string still fits on the screen */
   /* while at the same time incrementing the string pointer and  */
   /* column counter                                              */
   {
       *ptr_scrn = *(string-1);
       /* write the character to video memory */
       switch(PCOUNT)
       {
       case 4:
         ptr_scrn++;
         /* increment the pointer so it points to the attribute */
         if(not_valid_argument)
            /* if the attribute parameter was not a valid string */
            {
            attr = (byte)(*(ptr_scrn )); 
            /* get the current attribute byte */
            /* it would be easy to add code here to check for a numeric */
            /* parameter and use it instead   */
            }
            *ptr_scrn = attr;
            /* write the actual attribute byte to the screen */

         ptr_scrn++;
         break;

   	   default:
         ptr_scrn +=2;
         /* skip over the attribute byte if there was no 4th parameter */
       }
   }

_retni( (col > (col_max) ? col_max : col ) );

}

}

