#include <nandef.h>
#include <extend.h>
#include <stdio.h>
#include <ctype.h>
#include <graph.h>


/*	Sheldon Robinson, Ph.D.
	Video Adapter Identification for Clipper S87
	Written by Sheldon Robinson in Microsoft C 5.0
	Example of how to use lower level functions in C
	in conjuction with clipper.
	For more information contact RWP (415)472-1129
	nandef.h and extend.h are provided with clipper
	stdio.h ctype.h and graph.h are provide with MS C 5.0
	This routine is most useful going beyond with iscolor() 
	function and most helpful with identifying driver id's with
	programs such as DGE graphics.
*/

struct videoconfig vc;
CLIPPER v_adapter(x)
{
	int y;
	y = vc.adapter;
	_getvideoconfig (&vc);
	_retni(y);
}

/* _retni(y) is the integer returned to clipper with defines
your video configuration*/
/* Returned values that define current video adapter*/
/*_MDPA       0x0001       Monochrome Display Adapter (MDPA) */
/*_CGA        0x0002       Color Graphics Adapter     (CGA)  */	
/*_EGA        0x0004       Enhanced Graphics Adapter  (EGA)  */	
/*_MCGA       0x0008       MultiColor Graphics Array  (MCGA) */	
/*_VGA        0x0010       Video Graphics Array       (VGA)  */	

/* in clipper you would enter the followint to test the return value*/
/* of y*/

/* clipper routine is as follows*/
/* x is the parmeter that you pass - return value from C defines Adapter*/
/*  
x = 0
v_adapter(x)
x = v_adapter()
if x = 1
@ 21,1 say " Monochrome Display Adapter"
elseif x = 2 
@ 21,1 say " CGA Color Graphics Adapter"
elseif x = 4
@ 21,1 say " Standard EGA Enhanced Graphics Adapter"
elseif x = 10
@ 21,1 say " Hi Resolution EGA Adapter"
elseif x = 18
@ 21,1 say " VGA Graphics Adapter"
endif
*/

/* the C routine is compiled into an object module using
   the compile line defined in the clipper manual
	CL /c /AL /Zl /Oalt /FPa /Gs video.c
	The routine then can be linked into your program using the
	large C library LLIBCA.LIB  
*/

