******************************************************************
***   _VAL_MSG.PRG   Programmed by M.J. Magan 8 October 1987   ***
******************************************************************

function val_msg

* Syntax VAL_MSG( <var>, <condition>, <error message>)
* This function assumes that CONFIRM is OFF and ESCAPE is OFF !
* Use this function to display an error-message if the GET does not
* comply with a logical expression.
* E.g:
* @ 10,10 say 'Enter negative number' get num ;
* valid val_msg(num, num<0,'The number entered was not negative!')

parameters var, condition, message
private rownr,colnr                && upper-left corner of window
* The public variable val_msg_st indicates the state of the screen.
* 'I' : Initial screen
* 'S' : Saved
* 
if type('val_msg_st')#'C'
   public val_msg_st
   public val_msg_sc
   val_msg_st='I'
endif

do case
   case condition .and. val_msg_st='I'
      return (.t.)
   case condition .and. val_msg_st='S'
      restore screen from val_msg_sc
      val_msg_st='I'
      do case
         case type('var')='C'
            keyboard var
         case type('var')='N'
            keyboard chr(13)
         case type('var')='D'
            keyboard dtoc(var)
         case type('var')='L'
            keyboard iif(var,'T','F')
      endcase
      return (.f.)  && return the value False so that the current get
                    && will accept the characters stuffed in the keyboard
   case (.not. condition) .and. val_msg_st='S'
   return (.f.)
   case (.not. condition) .and. val_msg_st='I'
      save screen to val_msg_sc
      *** Calculate position of window
      rownr=iif(row()<21,row()+1,row()-3)
      colnr=max(0,col()-len(message)-2)
      @ rownr,colnr to rownr+2,colnr+len(message)+1
      @ rownr+1,colnr+1 say message
      val_msg_st='S'
      return (.f.)
endcase

