/*
Ŀ
                                                                          
                            PRNBOX.PRG                                    
                                                                          
                    Source File for TSDPRN.LIB                            
                   Clipper 5.01 Printer Library                           
                                                                          
      Copyright ( C ) 1992 by Trilateral Systems Development Ltd.         
    All Rights Reserved * Version 1.00 * Release Date: Nov ??, 1992       
                                                                          
                         18  Bond St. South                               
                         Dundas, ON, Canada                               
                              L9H 3H1                                     
                           416-628-5086                                   
                                                                          
                                                                          
     Documented: 10-23-92      at 02:52:23pm                              

*/
/*

 Include Files

*/
#include "inkey.ch"
/*

 File wide Manifest Constants and Definitions

*/
#define B_TOPLEFT  ""
#define B_TOP      ""
#define B_TOPRIGHT ""
#define B_RIGHT    ""
#define B_BOTRIGHT ""
#define B_BOTTOM   ""
#define B_BOTLEFT  ""
#define B_LEFT     ""
#define B_SHAD     ""
#define B_LSHAD    ""
/*

 Defined Commands

*/
#command DEFAULT <p> TO <val> [,<pn> TO <valn>] ;
         => ;
         <p> := IIF(<p> == NIL, <val>, <p>) ;
         [;<pn> := IIF(<pn> == NIL, <valn>, <pn>)]
/*

 Test Code

*/
#ifdef TSW_TEST
/*
Ŀ
  Description: Test of Box Print Functions.                               
       Author: Vic Lewis                                                  
 Date created: 10-23-92                                                   
 Time created: 02:41:58pm                                                 
    Copyright: Trilateral Systems Development Ltd.                        
Ĵ
     function Main()                                                      
                                                                          
    Arguments: None                                                       
                                                                          
 Return Value: Nil                                                        
                                                                          

*/
function Main()
local nRow := 0, nCol := 5, nKey

cls
@ 10, 10 say "  Your Printer Should Have IBM Line Charcters in its"
@ 11, 10 say "                Current Character Set"
@ 13, 10 say "      You Must Have an Active Printer on LPT1"
@ 15, 10 say "Press ESC to Abort or Any Other Key to Continue the Test"

if !(( nKey := inkey( 0 ) ) == K_ESC )

    set device to print

    twPrintBox( @nRow, nCol, "This is a Test of the twPrintBox() Function" )
    nRow++

    twPrintCenterBox( @nRow, nCol, "Here's twPrintCenterBox()", 50 )
    nRow++

    twPrintBox( @nRow, nCol + 5, { "Let's See", "What Happens",;
        "When We Try to Pass an Array to twPrintBox()" } )

    twPrintBox( @nRow, nCol, { "Let's See", "What Happens",;
       "When We Try to Pass a Right Justified Array to twPrintBox()" }, "R" )

    twPrintBox( @nRow, nCol, { "Let's See", "What Happens",;
        "When We Try Center Justification with twPrintBox()" }, "C" )

    twPrintCenterBox( @nRow, nCol + 8,;
        { "", "How About an Array to twPrintCenterBox()",;
        "",;
        "With Blank Lines Inserted","" }, 50 )

    twPrintCenterBox( @nRow, nCol,;
         { "How About an Array TO twPrintCenterBox()",;
           "With No Blank Line Inserted",;
           "and Default Width" } )
    nRow++

    twPrintBox( @nRow, nCol + 8, "It Does NOT have to Make Shadows!",, .f. )

    twPrintCenterBox( @nRow, nCol, { "", "Test Complete!","",;
       "Compliments of Trilateral Systems Development Ltd.", "",;
       "Creators of TSDWIN.LIB Interface Library for Clipper 5.01(a)",;
       "", "and","", "Database Applications",;
       "for Business, Industry, Education and Government", "" } )

    eject
    set device to screen

endif // if !(( nKey := inkey( 0 ) ) == K_ESC )

@ 17, 10 say "                   Test Complete!"
inkey( 1 )
cls
return nil
/*

 End Test Code

*/
#endif
/*
Ŀ
  Description: Print output to a box, with or without shadowing.          
       Author: Vic Lewis                                                  
 Date created: 10-23-92                                                   
 Time created: 02:35:19pm                                                 
    Copyright: Trilateral Systems Development Ltd.                        
Ĵ
     function twPrintBox( nRow, nCol, xString, cJustify, lShadow )        
                                                                          
    Arguments: nRow - Printer Row (Pass by Reference is good)             
               nCol - Printer Columns                                     
               xString - String or Array of Strings                       
               cJustify - for Arrays ONLY                                 
                          "L" - Left Justify                              
                          "R" - Right Justify                             
                          "C" - Center Justify                            
                                                                          
 Return Value: nil                                                        
     See Also: twPrintCenterBox()                                         
                                                                          

*/
function twPrintBox( nRow, nCol, xString, cJustify, lShadow )
local nLength, i, nLenString, aOutPut

DEFAULT cJustify TO "L",;
        nCol TO pcol() - set( _SET_MARGIN ),;
        nRow TO prow(),;
        lShadow TO .t.
/*

 If an Array is Passed, This is the Number of elements.
 If a String is Passed, This is its length.

*/
nLenString := len( xString )

if valtype( xString ) == 'A'
    /*
                                                                      
     Define the Length of the Box
                                                                      
    */
    nLength := 1

    for i := 1 to nLenString
        nLength := max( nLength, len( xString[ i ] ))
    next

    nLength += 2
    /*
                                                                      
     Modify the String(s) for Output.
                                                                      
    */
    aOutPut := aclone( xString )

    for i := 1 to nLenString
        do case
            case cJustify == 'L'
                aOutPut[ i ] := padr( aOutPut[ i ], nLength - 2 )

            case cJustify == 'R'
                aOutPut[ i ] := padl( aOutPut[ i ], nLength - 2 )

            case cJustify == 'C'
                aOutPut[ i ] := padc( aOutPut[ i ], nLength - 2 )

        endcase

    next // for i := 1 to nLenString

else
    nLength := nLenString + 2
    nLenString := 1
    aOutPut := { xString }

endif // if valtype( xString ) == 'A'
/*

 Print the Box Top

*/
@ nRow++, nCol say B_TOPLEFT + repl( B_TOP, nLength ) + B_TOPRIGHT
/*

 Print the Box Left, String(s) and Box Right

*/
for i := 1 to nLenString
    @ nRow  , nCol say B_LEFT + " " + aOutPut[ i ] + " " + B_RIGHT
    /*
                                                                      
     Add Shadow Components if Allowed
                                                                      
    */
    if lShadow
        @ nRow++, nCol + nLength + 1 say B_LSHAD
    else
        nRow++
    endif
next // for i := 1 to nLenString
/*

 Do the Box Bottom

*/
@ nRow  , nCol say B_BOTLEFT + repl( B_BOTTOM, nLength ) + B_BOTRIGHT
/*

 Add Shadow Components if Allowed

*/
if lShadow
    @ nRow, nCol + nLength + 1 say B_LSHAD
    @ nRow, nCol + 1 say repl( B_SHAD, nLength + 1 )
endif
/*

 Adjust the Printer row

*/
nRow++
return nil
/*
Ŀ
  Description:                                                            
       Author: Vic Lewis                                                  
 Date created: 10-23-92                                                   
 Time created: 02:39:01pm                                                 
    Copyright: Trilateral Systems Development Ltd.                        
Ĵ
     function twPrintCenterBox( nRow, nCol, xString, nLength )            
                                                                          
    Arguments: nRow - Printer Row (Pass by Reference is good)             
               nCol - Printer Columns                                     
               xString - String or Array of Strings                       
               nLength - Box Length (NO ERROR CHECKING)                   
                                                                          
 Return Value: nil                                                        
     See Also: twPrintBox()                                               
                                                                          

*/
function twPrintCenterBox( nRow, nCol, xString, nLength )
local i, nLenString := len( xString )

DEFAULT nLength TO 70 - set( _SET_MARGIN ) - nCol

if valtype( xString ) == 'A'

    for i := 1 to nLenString
        xString[ i ] := padc( xString[ i ], nLength  )
    next

else
    xString := padc( xString, nLength )

endif // if valtype( xString ) == 'A'

twPrintBox( @nRow, @nCol, xString  )

return nil

