











                                    TMCEL - 1.7
 
                        Ted Mieske Clipper Engineers Library
                                                       


                        Written by: Ted J. Mieske                

		       Portions by: Bill Parker & Stefan Hanson














				    





			S H A R E W A R E   V E R S I O N

















          Copyright (c) 1991, 1992 by Ted J. Mieske.  All Rights Reserved.

        T.M.                                            08/14/92

	Current functions in TMCEL:


ELEC:
	 1.	COO()		- calculates Cost of Operation of Elec. Device

         2.     DEVICOK()       - test to see if a Serial Port is ready

        3.     EIR()           - convert Current/Resistance to Voltage

         4.     EPI()           - convert Wattage/Current to Voltage

         5.     EPR()           - convert Wattage/Resistance to Voltage

         6.     F2M()           - convert Frequency to Meters

         7.     IER()           - convert Voltage/Resistance to Current

         8.     IPE()           - convert Wattage/Voltage to Current

        9.     IPR()           - convert Wattage/Resistance to Current

        10.     LRC()           - LED Resistor Calculator

        11.     M2F()           - convert Meters to Frequency

        12.     PEI()           - convert Voltage/Current to Wattage

        13.     PER()           - convert Voltage/Resistance to Wattage

       14.     PIR()           - convert Current/Resistance to Wattage

        15.     PRNTOK()        - test to see if a Printer Port is ready

        16.     R2()            - calculate the value of 2 parallel resistors

        17.     REI()           - convert Voltage/Current to Resistance

        18.     REP()           - convert Voltage/Wattage to Resistance

        19.     RPI()           - convert Wattage/Current to Resistance

        20.     VA2W()          - converts Volt-Amperes to Watts

        21.     W2VA()          - converts Watts to Volt-Amperes

AUDIO:
	 1.	OGC()		- Op-amp Gain Control calculation

	 2.	PHONTONE()	- display & produce ALL tone-pairs of phone

	 3.	RDT60()		- reverberation delay time at a 60db drop

	 4.	SNGLTNE()	- produce (1) tone-pair of the phone system
				  
	 5.	VDELAY()	- velocity delay of sound in seconds

	 6.	WAVDIST()	- wavelength of a specific freq. in distance

MATH:
	 1.	ATN()		- ARCTANGENT math function

	 2.	BIN2DEC()	- convert from BINary to DECimal

	 3.	BIN2HEX()	- convert from BINary to HEX

	 4.	CHKAMNT()	- convert an numeric dollar amount to text

	 5.	COS()		- COSINE math function

	 6.	DEC2BIN()	- convert from DECimal to BINary

	 7.	DEC2HEX()	- convert from DECimal to HEX

	 8.	DEG()		- will return the DEGREES of a Radian number

	 9.	HEX2BIN()	- convert from HEX to BINary

	10.	HEX2DEC()	- convert from HEX to DECimal

	11.	KTOM()		- convert Kilometers to Miles (statute)

	12.	LOG10()		- LOG10 math function

	13.	MOD()		- returns the modulus of  X MOD Y

	14.	MTOK()		- convert miles (statute) to Kilometers

	15.	NODIV0()	- keeps one from the dreaded Divide-by-Zero

	16.	PI()		- just returns PI , or PI(n) for n # of times

	17.	POWER()		- raise a specific number, to a specific Power

	18.	RAD()		- will return the RADIANS of a Degree number

	19.	RANDUM()	- a random number generator

	20.	ROUNDIT()	- replaces the ROUND() function of Clipper!

	21.	SGN()		- returns the SIGN of a number

	22.	SIN()		- SINE math function

	23.	SQR()		- returns the SQUARE of a number

	24.	TAN()		- TANGENT math function


DATE/TIME:
	 1.	BOM()		- begining of month

	 2.	BONM()		- begining of next month

	 3.	BOPY()		- begining of previous year

	 4.	BOW()		- begining of week

	 5.	BOY()		- beginning of year

	 6.	DATETST()	- check to see if a date field is empty

	 7.	DTOW()    	- convert a numeric date to month with words

	 8.	EOLM()		- end of last month

	 9.	EOM()		- end of month

	10.	EOPY()		- end of previous month

	11.	EOW()		- end of week

	12.	EOY()		- end of year

	13.	JULDAYS()	- display current/past Julian days

	14.	LEAPYR()	- will return True/False on a Leap Year

	15.	MNTHCAL()	- display one month, with or without a window

	16.	NDIN2Y()	- gives the # of days were into a year

	17.	NDINM()		- number of days in a chosen month

	18.	THETIME()	- display the Standard time, with A.M., P.M.

	19.	TTOW()    	- convert time of day, into appropriate word

	20.	VLDDATE()	- point to a valid date

	21.	WOFM()		- find week of the month

	22.	YRDATE()	- returns the year as 2 or 4 digits


WINDOWS:
	 1.	ADVRTIZE()	- top-to-bottom message strober

        2.     ASK1()          - ask a Yes/No question

         3.     ASK2()          - ask a Yes/No question #2

        4.     BOXIT()         - draw a simple box on console

         5.     BYEWIN()        - blows-off the window

         6.     CENTER()        - center a msg. on the console

         7.     CHKCOLR()       - test for color monitor with optionional
                                  colors

         8.     CLRTHIS()       - clear the console with special effects

         9.     DROPBOX()       - drop-down box onto console

        10.     DROPCHR()       - Drop characters on console to certain position

       11.     ERRMSG()        - Display an error message

        12.     EXPAND()        - expand a sentence out, from the center

        13.     HIBAKBIT()      - used to either Blink, or set Hi-Intensity
				  Bit ON, for Background Colors

        14.     KILBOX()        - delete box instantly on console

        15.     KILWIN()        - implode the exploded window

        16.     MAKBOX()        - instant box on the console

        17.     MAKWIN()        - explode a window on the console

        18.     POPBOX()        - pop-up box onto console

       19.     SCANUP()        - roll-up text on the console

        20.     SHADWIN()       - add a Window with a shadow

        21.     STRECH()        - strech-out a line of text (i.e. T E X T)

        22.     TICKERT()       - performs a right-to-left character scan

        23.     VMENU()         - verticle display menu system


EVIRON:
	 1.	CTOF()		- convert Celsius to Fahrenheit

	 2.	FTOC()		- convert Fahrenheit to Celsius

         3.     HPWF()          - calculates the horsepower of a waterfall

	 4.	L2THD()		- calculate distance from time between seeing
                                  Lightning, and hearing Thunder

	 5.	WNDCHIL()	- calculates the WindChill Factor



NETWORK:

	 1.	FILELOK()	- Will Lock a File on a Network

	 2.	NETAVL()	- Will check to see if a File is available
				  to set EXCLUSE or SHARED

	 3.	RECLOK()	- Will Lock a Record on a Network
	


TOOLS:
	 1.	AGE()		- calculate any Age, from any Date

	 2.	ALARMS()	- collection of various Alarms - Bells - Tunes
	
	 3.	ANSICHK()	- checks to see if ANSI.SYS is loaded

	 4.	BEEPS()		- sound a tone n times at 1-second intervals

	 5.	CHKCNFG()	- checks your Files & Buffers for a specific #s

         6.     CHKENV()        - checks "SET CLIPPER=" for specific values

	 7.	CHKMEM		- display amount of current memory inside a
                                  program  [ CALL EXTERNAL ]

         8.     CURDRV()        - returns the current drive letter

        9.     DELAY()         - will delay specific # of seconds on any PC

        10.     DSKCHK()        - checks to see if enough FREE space is
				  on a disk to do a file backup.

        11.     FLDCNT()        - counts the number of fields in a database

        12.     INDXBAR()       - shows how far into an index, with graph-bar

        13.     INT2STR()       - convert an integer to a string

       14.     LIN()           - used to skip n lines on printer or console

        15.     MSGON()/OFF()   - display a message with a Flashing Elipses
				  
        16.     PADLEFT()       - pad a character string left with a fill char.

        17.     PADRGHT()       - pad a character string right with a fill char.

       18.     PADSPAC()       - pad a character string with spaces, or chop

        19.     PASSCHK()       - password checker

        20.     PERCENT()       - Displays a %, of how far into a PACK/USE

        21.     PHNCALL()       - PhoneBook with dialing

        22.     PICKIT()        - Picklist validator - for ACHOICE()

       23.     PRTOF()         - checks to see if Printer is at TOF, else 
                                  ejects

        24.     PULLOUT()       - pullout any data from a specific position
				  in a string.

        25.     RANDFIL()       - random file creater

        26.     SERIAL()        - returns the serial number of your TMCEL.LIB

        27.     THEPATH()       - will seek and display the PATH of a file

       28.     VERTMCL()       - returns version of TMCEL.LIB

        29.     VLD_AC()        - Validates a Phones Areacode number

        30.     VLD_CAN()       - Validates a Canadian Province code

        31.     VLD_ST()        - Validates a STates 2-digit code


  = available ONLY; (26 functions) in ShareWare version.

              Ŀ
              
                                                             
                      TMCEL LIBRARY - Version 1.7            
               Clipper Electronic Library for: Engineers     
                Copyright (c) 1991,92 by: Ted J. Mieske      
                                                             
            
            
            
          



     Why this Library?  Well sure, you see libraries that will control
     your Printer, make Boxes, handle Arrays or a number of Date func-
     tions, but; have you ever seen a .LIB that would perform extensive 
     Time, Date, HP Laser Printer, Environmental, Electronic, Ham Radio 
     or Audio formula calculations?  How about instant-display of sche-
     matic circuits and diagrams for reference, or display and hear the 
     frequencies of a telephone? (sort-of!)

     We put 2 years into this pup, and except for 4 modules that had to
     be written in 'C' or .ASM, the rest is pure Clipper code!  Although
     we have moved into the realm of 5.0x and GUI and ... well you know.
     The first release will be for Clipper Summer '87.  We did this for
     the simple reason that a number of you just don't want to switch,
     and we WANT your business too!

     I kept this intro short, so as not to: (1) bore you, and (2), get
     to the heart of its functions and use... Although it is being offer-
     ed as 'SHAREWARE'... (you know this was comming)!  To get the source
     code and the rest of the fucntions ... send your bucks!  We will do
     the rest.

      EXTRA'S! 

     There are a number of functions that ARE-NOT listed, but will be
     included in the shareware and registered version. See !README.DOC


     Also send in your ideas or modifications that you need or fixes that
     we missed. We want you a happy camper so we can sell a few of these,
     and get moved back to the West Coast.  (I HATE BEING LAND-BOUND, I
     *NEED* MY OCEAN, CLEAN-AIR BACK!!!!!)

     In time, I will have a direct BBS for support, for the time being,
     you can call: "Obscured by Clouds" at (817)731-1754 9600bps 8N1 for
     updates and complaints (sure we take those too!)  They have offered
     to do this for us, and you can leave mail directly to me. If for some
     reason they 'close shop', we will PostCard you another location.



      FUTURE ITEMS 

     I am already working on interfacing the outside world for the next
     version of TMCEL.LIB!  I have planed, an IN() and OUT function like
     BASIC Programs have; this way, you can do D/A and A/D, or control
     projects such as home security systems, open/close blinds, start
     the java in the morning... how about automating some operation or
     calling and polling a remote site for collecting data. And MORE,
     how about data aquisition control or automate that model RailRoad!

     Mouse support will also be added, as well as reading various types
     of picture files: .GIF, .PCX, .TIFF ... etc. etc.

     
     NOTE: You will find a separate file called: TMCELBN.DOC
           which lists SOME of the various Schematic screens
           used in performing calculations, as well as look-
           up tables for reference...these are in the regis-
           tered version.



      HERE GOES! 


      LAST MINUTE INFO 

     As usual, for last-minute updates, read the !README.DOC file that
     is located on the disk, or in the .ZIP file  *FIRST*.






      CORRESPONDENCE 

     To write us, address your input to: T.M.S. Micro
                                         209 Hurstview Dr.
                                         Hurst, TX  76053-6726




      LINKING the .LIB 

     Before Compiling/Linking we would like to suggest that some
     environment variables be set *FIRST*, as follows in your 
     AUTOEXEC.BAT:

     SET CLIPPER=F65,V22,R26,E0

     The reason for the F65, is for network purposes, you may want
     to ajust this down to F41 on standalone systems.  Setting "V" &
     "R" are up to you.  We have found that if "E" is set to Zero (0),
     you will avoid the posiblilty of a "System Crash", do to the 
     dreaded "OUT OF MEMORY" or Index's-corrupting-for-*NO*-appearent
     -reason syndrome! 



     We *ONLY* work with just one, and that is Blinker!  A two second
     re-link beats the "P - word" linker, that will take 7-20 minutes,
     so why use it?  GO FIGURE ... If you use another, that's up to
     you; so here's the command sequence for Blinker on the command 
     line:

     BLINKER FI <files>  LI TMCEL, CLIPPER, EXTEND  <--<< order IS important!

     ------------------------------------------------------------------

     From a batch (.BAT) file, our example would look like this:

     BLINK.BAT - the following lines are in this .BAT:

     CLIPPER %1
     BLINKER FI %1  LI TMCEL, CLIPPER, EXTEND
     DEL %1.OBJ
 
     ------------------------------------------------------------------

     BLINK1.BAT - another approach when using a .LNK file:

     CLIPPER %1
     BLINKER @FILENAME.LNK      <--<< the .LNK is NOT necessary

     The FILENAME.LNK would have the following layout:

     #BLINKER INCREMENTAL OFF   <--<< remove the '#' sign to save
     FI %1                            .EXE size; of course, you will
     LI TMCEL                         LOOSE line numbers on errors.
     LI CLIPPER, EXTEND

     So there are a few simple ways to handle the process.



      SO YOU WANT TO MAKE YOUR *OWN* LIBRARY ... HERE'S HOW 

     You should have a copy of LIB.EXE 3.17 or newer. Older versions
     will cause a "1005:lib. has NO cross reference", annoying error
     from Blinker, but is NOT critical!
     The Syntax would be: LIB <LIBNAME> <SWITCHS+OBJECT> ;

     EXAMPLE: LIB TMCEL -+_MODULE1 -+_MODULE2 -+_MODULE3 ;      

     This will create/update TMCEL.LIB with the list of .OBJ files
     you passed it.  SIMPLE!


     The steps are as follows:

     1. Compile your FILENAME.PRG file (some may require the -m switch),
        so that only the main modules is compiled.

     2. Add/Update the module (.OBJ) to your library     

     List of switchs:		+	add .OBJ to the Library
                                -	remove .OBJ from the Library
                                *       extract .OBJ name without removing
			       -+	replace .OBJ in the Library
                               -*       extract .OBJ and remove from Library

	

      THE LAYOUT 

     The library is broken down into groups of related use, so you 
     can find a function fast. They are:
 
      ELECTRONIC              AUDIO                   MATH        
      WINDOWS                 DATE/TIME               TOOLS      
      SCHEMATIC/DIAGRAMS      NETWORK

     So lets go through them one group at a time ...



                                                        ELECTRONIC 
        
        COO()           Cost of operating an Electrical Device

	Syntax
	
        COO(<expN1>,<expN2>,<expN3>)

        <expN1>  is a value that represents Wattage calculated.
        <expN2>  is a value that represents Time in Hours.
        <expN3>  is a value that represents Cost-Per-Kilowatt


	Example
        
                         
        COO(200,4,1.67)

        Returns: a character value  1.34 Cost for (4) hours use in 
                                         Dollars & Cents.


        
        DEVICOK()       Checks to see if COM Port is Ready

	Syntax
	
        DEVICOK(<expN>)

        <expN> COM Port to test

        Example
        
           
        IF DEVICOK(2)
         (then send something to COM2)
        ENDIF

        Returns: Logical State; and if .f., an Error Msg. with option 
                 to try again

        
        EIR()           Convert Current/Resistance to Voltage

	Syntax
	
        EIR(<expN1>,<expN2>)

        <expN1>  is a value that represents Current.
	<expN2>  is a value that represents Resistance.


	Example
        
                         
        EIR(3.6,2.7)

        Returns: a character value  9.72 Volts



        
        EPI()           Convert Power/Current to Voltage

	Syntax
	
        EPI(<expN1>,<expN2>)

        <expN1>  is a value that represents Power.
        <expN2>  is a value that represents Current.


	Example
        
                         
        EPI(52,3.44)

        Returns: a character value  15.12 Volts



        
        EPR()           Convert Power/Resistance to Voltage

	Syntax
	
        EPR(<expN1>,<expN2>)

        <expN1>  is a value that represents Power.
        <expN2>  is a value that represents Resistance.


	Example
        
                         
        EPR(48,4.1)

        Returns: a character value  14.03 Volts

        
        F2M()           Convert from Frequency to Meters

	Syntax
	
        F2M(<expN>)

        <expN> a is value for Frequency (Mhz)  that you want converted.


	Example
        
                         
        F2M(103.7)

        Returns: a character value  2.89 Meters



        
        IER()           Convert Voltage/Resistance to Current

	Syntax
	
        IER(<expN1>,<expN2>)

        <expN1>  is a value that represents Voltage.
        <expN2>  is a value that represents Resistance.


	Example
        
                         
        IER(24.2,5.7)

        Returns: a character value  4.25 Amps



        
        IPE()           Convert Power/Voltage to Current

	Syntax
	
        IPE(<expN1>,<expN2>)

        <expN1>  is a value that represents Power.
        <expN2>  is a value that represents Voltage.


	Example
        
                         
        IPE(35,5.1)

        Returns: a character value  6.86 Amps

        
        IPR()           Convert Power/Resistance to Current

	Syntax
	
        IPR(<expN1>,<expN2>)

        <expN1>  is a value that represents Power.
        <expN2>  is a value that represents Resistance.


	Example
        
                         
        IPR(120,1.7)

        Returns: a character value  8.4 Amps



        
        LRC()           LED  Load Resistor Calculator

	Syntax
	
        LRC(<expN1>,<expN2>,<expN3>)

        <expN1>  is a value that represents Input Voltage.
        <expN2>  is a value that represents desired/specified forward current.
        <expN3>  is a value that represents LED current draw per spec.


	Example
        
                         
        LRC(5,1.7,20)

        Returns: a character value  165 Ohms -- closets common value 
                                                would be 180  


        
	M2F() 		Convert from Meters to Frequency

	Syntax
	
	M2F(<expN>)

        <expN> is a value for Meters that you want converted.


	Example
        
                         
	M2F(2.78)

        Returns: a character value  107.91 Mhz

        
        PEI()           Convert Voltage/Current to Power

	Syntax
	
        PEI(<expN1>,<expN2>)

        <expN1>  is a value that represents Voltage.
        <expN2>  is a value that represents Current.


	Example
        
                         
        PEI(12,3.4)

        Returns: a character value  40.8 Watts



        
        PER()           Convert Voltage/Resistance to Power

	Syntax
	
        PER(<expN1>,<expN2>)

        <expN1>  is a value that represents Voltage.
        <expN2>  is a value that represents Resistance.


	Example
        
                         
        PER(12,6.14)

        Returns: a character value  23.45 Watts



        
        PIR()           Convert Current/Resistance to Power

	Syntax
	
        PIR(<expN1>,<expN2>)

        <expN1>  is a value that represents Current.
        <expN2>  is a value that represents Resistance.


	Example
        
                         
        PIR(75,11.44)

        Returns: a character value  64350 Watts

        
        PRNTOK()        Checks to see if printer is ON-LINE & Ready

	Syntax
	
        PRNTOK([<expL>])

        [<expL>] .T. Set Device to Print  for @ SAY  [default]  (optional)
                 .f. Set Print On  for ? or ?? 

        Example
        
           
        IF PRNTOK()
         DO LISTING
         SET DEVICE TO SCREEN
        ENDIF

        Returns: Logical State; and if .f., Error Msg. with option to 
                 try again



        
        R2()            Calculate the value of 2 Parrallel Resistors

	Syntax
	
        R2(<expN1>,<expN2>)

        <expN1>  is a value that represents Resistor #1.
        <expN2>  is a value that represents Resistor #2.


	Example
        
                         
        R2(47000,3900)

        Returns: a character value  3601.18 Ohms -- closets common value 
                                                    would be 3600 

        
        REI()           Convert Voltage/Current to Resistance

	Syntax
	
        REI(<expN1>,<expN2>)

        <expN1>  is a value that represents Voltage.
        <expN2>  is a value that represents Currnet.


	Example
        
                         
        REI(5.1,1.72)

        Returns: a character value  2.97 Ohms



        
        REP()           Convert Voltage/Wattage to Resistance

	Syntax
	
        REP(<expN1>,<expN2>)

        <expN1>  is a value that represents Voltage.
        <expN2>  is a value that represents Wattage.


	Example
        
                         
        REP(12.6,4)

        Returns: a character value  39.69 Ohms



        
        RPI()           Convert Power/Current to Resistance

	Syntax
	
        RPI(<expN1>,<expN2>)

        <expN1>  is a value that represents Power.
        <expN2>  is a value that represents Current.


	Example
        
                         
        RPI(100,2.66)

        Returns: a character value  14.22 Ohms

        
        VA2W()          Convert Volt-Amperes to Watts

	Syntax
	
        VA2W(<expN1>,[<expN2>])

        <expN1>  is a value that represents Volt-Amperes.
       [<expN2>] is a value that represents Crest Factor. [ default 1.5 ]

        This term (crest factor) is the amount of peak-current
        needed by a power supply.  The factor depends on the type
        of input AC waveform; a True Sine-Wave has a factor of
        2 or 3 ... a modified Sine-Wave may only exhibit 1 or 1.5.



	Example
        
                         
        VA2W(150)

        Returns: a character value  100 Watts



        
        W2VA()          Convert Watts to Volt-Amperes

	Syntax
	
        W2VA(<expN1>,[<expN2>])

        <expN1>  is a value that represents Wattage.
       [<expN2>] is a value that represents Crest Factor. [ default 1.5 ]

        NOTE: Crest Factor explained in previous function

        Example
        
                         
        W2VA(100)

        Returns: a character value  150 Volt-Amps

                                                        AUDIO 
	
        OGC()           Op-Amp Gain Control Calculation

	Syntax
	
        OGC(<expN1>,<expN2>,<expN3>)

        <expN1>  coresponds to the input voltage
        <expN2>  is the input resistor
        <expN3>  is the feed-back resistor


	Example
        
                         
        OGC(.5,100,470)

        Returns: a character value  2.35 volts output gain



        
        PHONTONE()      Displays ans ANSI diagram of Phone Frequences

	Syntax
	
        PHONTONE(<expC>)

        <expC>  is a digit represented by the phone-pad


        The full set of digits from 0-9 are available, as well as
        the pound sign (#) and askerisk (*)... also for those known
        special pads (such as ham radio), the A-D will respond also.



	Example
        
                         
        PHONTONE('9')

        Returns: frequences pair of 852 & 1471

        
        RDT60()         Reverberation Delay Time

	Syntax
	
        RDT60(<expN1>,<expN2>)

        <expN1>  is the total volume of the room (foot^3)
        <expN2>  is the absorption units

        Carpeting on concrete has an average co-efficient of .37
        (at 1 khz). Thus, a carpeted floor of 1,000 square feet
        would have 370 absorption units (.37 X 1000).

        This is set for a typical 60db drop of loss of signal.


	Example
        
                         
        RDT60(19200,824)

        Returns: a character value  1.17 second delay of reverberation



        
        SNGLTNE()       Will produce a single tone-pair    

	Syntax
	
        SNGLTNE(<expC>)

        <expC>  is a digit represented by phone-pad


	Example
        
                         
        SNGLTNE('4')

        Returns: frequences pair of 770 & 1209



        
        VDELAY()        Velocity of Sound Delay

	Syntax
	
        VDELAY(<expN>)

        <expN>  represents a specific frequency

        This uses a factor of 1130, which corresponds to normal room
        room temperature of 70 F   (21 C)


	Example
        
                         
        VDELAY(500)

        Returns: a character value  0.44248 second delay



        
        WAVDIST()       Wavelength of Sound in Distance

	Syntax
	
        WAVEDIST(<expN>)

        <expN>  represents a specific frequency

        Once again this uses a factor of 1130, which corresponds to
        normal room room temperature of 70 F   (21 C)

        Example
        
                         
        VDELAY(400)

        Returns: a character value  2.83 feet

                                                        MATH 
	
        ATN()           Arctangent math function

	Syntax
	
        ATN(<expN>)

        <expN>  a numeric value entered    (negatives may be
					    entered as well)

	Example
        
                         
        ATN(2)

        Returns: a numeric value  1.1071298



	
        BIN2DEC()       Binary to Decimal   16-Bit conversion

	Syntax
	
        BIN2DEC(<expN>)

        <expN>  a binary value entered

        You will noticed that only 15-Bits were entered; this is 
        because a hi-bit of 0 will be assumed for the 16th position.
        All leading zero's (0) will be left filled, if left-out!


	Example
        
                         
        BIN2DEC(110110000011010)

        Returns: a numeric value  27674

        
        BIN2HEX()       Binary to Hex   16-Bit conversion

	Syntax
	
        BIN2HEX(<expN>)

        <expN>  a binary value entered

        You will noticed that only 15-Bits were entered; this is 
        because a hi-bit of 0 will be assumed for the 16th position.
        All leading zero's (0) will be left filled, if left-out!


	Example
        
                         
        BIN2HEX(110110000011010)

        Returns: a character value  6C1A

        
        CHKAMNT()       Convert a numeric amount to Text

	Syntax
	
        CHKAMNT(<expN>)

        <expN>  a numeric amount entered


	Example
        
                         
        CHKAMNT(124.77)

        Returns: a character  One Hundred Twenty-Four Dollars and 77/100 Cents



        
        COS()           Cosine Math Function

	Syntax
	
        COS(<expN>,[<expC>])

         <expN>  is a value to convert to COSine
        [<expC>]  has a choice of blank, D or R        [ default is D ]

        [<expC>]  will assume 'D' (decimal) unless secified otherwise


        Example
        
                         
        COS(1,'R')

        Returns: a numeric value  0.540302 Radians



        
        DEC2BIN()       Decimal to Binary   16-Bit conversion

	Syntax
	
        DEC2BIN(<expN>)

        <expN>  a decimal value entered


	Example
        
                         
        DEC2BIN(26674)

        Returns: a character value  1101000 00110010   <- once again notice
                                                          leading (0) left
                                                          off the hi 8-bits  
        
        DEC2HEX()       Decimal to Hex   16-Bit conversion

	Syntax
	
        DEC2HEX(<expN>)

        <expN>  a decimal value entered


	Example
        
                         
        DEC2HEX(240)

        Returns: a character value  F0



        
        DEG()           Degrees to Radians conversion

	Syntax
	
        DEG(<expN>)

        <expN>  a degree value entered


	Example
        
                         
        DEG(2.4)

        Returns: a numeric value  80.2141 Radians



        
        HEX2BIN()       Hex to Binary   16-Bit conversion

	Syntax
	
        HEX2BIN(<expC>)

        <expC>  a hex value entered


	Example
        
                         
        HEX2BIN('F0')

        Returns: a character value  00000000 11110000

        
        HEX2DEC()       Hex to Decimal   16-Bit conversion

	Syntax
	
        HEX2DEC(<expC>)

        <expC>  a hex value entered


	Example
        
                         
        HEX2DEC('F0')

        Returns: a numeric value  240



        
        KTOM()          Kilometers to Miles (statute)

        Syntax           "NO this isn't some hick radio station"
	
        KTOM(<expN>)

        <expN>  a value in kilometers


	Example
        
                         
        KTOM(160)

        Returns: a numeric value  99.4240 statute miles



        
        LOG10()         LOG10 funciton

        Syntax
	
        LOG10(<expN>)

        <expN>  a value of LOG() or any known BASE10 number


	Example
        
                         
        LOG10(100)

        Returns: a numeric value  2

        
        MOD()           Modulus function

        Syntax
	
        MOD(<expN1>,<expN2>)

        <expN1>  is a value equal to X
        <expN2>  is a value equal to Y

        NOTE: This function is equal to Basics  X MOD Y

	Example
        
                         
        MOD(10.5,4)

        Returns: a numeric value  3



        
        NODIV0()        NO Divide by zero (0)

        Syntax
	
        NODIV0(<expN>)

        <expN>  is a denominator value to check

        NOTE: if the answer would end up 0, then a 1 is returned

	Example
        
                         
        NU = 14
        DN = 0
        ANS = NU / NODIV0(DN)

        Returns:  a numeric value of the leftovers



        
        MTOK()          Miles (statute) to Kilometers

        Syntax
	
        MTOK(<expN>)

        <expN>  a value in miles


	Example
        
                         
        MTOK(10)

        Returns: a character value  16.090 kilometers   
        
        PI()            Returns the value of 

        Syntax
	
        PI([<expN>])

        [<expN>]  a numeric value            [ default is 1 ]


	Example
        
                         
        PI(2)

        Returns: a numeric value  6.283185309



        
        POWER()         Raise a number by a specific Power

        Syntax
	
        POWER(<expN1>,<expN2>)

        <expN1>  a numeric value to be raised
        <expN2>  power to raise by


	Example
        
                         
        POWER(12,4)

        Returns: a numeric value  20736.00



        
        RAD()           Radians to Degrees conversion

	Syntax
	
        RAD(<expN>)

        <expN>  a radian value entered


	Example
        
                         
        RAD(45)

        Returns: a numeric value  0.785398 degrees

        
        RANDUM()        Random Number Generator

	Syntax
	
        RANDUM(<expN>)

         <expN> Number to seed generator with      

        NOTE: Number returned will be <= to <expN>


	Example
        
                         
        mNUM = RANDUM(67)
        FOR NEWVAL = 1 to mNUM
        ...

        Returns: a numeric value



        
        ROUNDIT()       Round-off a number

	Syntax
	
        ROUNDIT(<expN>)

        <expN>  any numeric value

        NOTE: This replaces the ROUND() function in Clipper (NO WORKY!)


	Example
        
                         
        ROUNDIT(7.47)

        Returns: a numeric value  7.5

        
        SIN()           SINE Math Function

	Syntax
	
        SIN(<expN>,[<expC>])

         <expN>   is a value to convert to SINe
        [<expC>]  has a choice of blank, D or R        [ default is D ]

        [<expC>]  will assume 'D' (decimal) unless secified otherwise


	Example
        
                         
        SIN(45,'D')

        Returns: a numeric value  0.707106 Degrees



        
        SGN()           Returns the Sign of any given number

	Syntax
	
        SGN(<expN>)

        <expN>  a value numeric entered

        NOTE: A positive returns  1
              A zero (0) returns  0
              A negative returns -1


	Example
        
                         
        SGN(-4)

        Returns: a numeric value  -1

        
        SQR()           Returns the Square of any given number

	Syntax
	
        SQR(<expN>)

        <expN>  a value numeric entered


	Example
        
                         
        SQR(4)

        Returns: a numeric value  16



        
        TAN()           TANgent Math Function

	Syntax
	
        TAN(<expN>,[<expC>])

         <expN>  is a value to convert to TANgent
        [<expC>]  has a choice of blank, D or R        [ default is D ]

        [<expC>]  will assume 'D' (decimal) unless secified otherwise


	Example
        
                         
        TAN(1,'R')

        Returns: a numeric value  1.55741 Radians

                                                        DATE/TIME
	
        BOM()           Beginning of Month

	Syntax
	
        BOM([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        BOM('05/17/92')

        Returns: a character string of  05/01/92



	
        BOMN()          Beginning of next Month

	Syntax
	
        BONM([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        BONM('03/18/92')

        Returns: a character string of  06/01/92



        
        BOPY()          Beginning of previous Year

	Syntax
	
        BOPY([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        BOPY('11/17/92')

        Returns: a character string of  01/01/91

        
        BOW()           Beginning of Week

	Syntax
	
        BOW([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        BOW(DATE())+7     <- lets assume this is 10/07/92

        Returns: a character value of  Monday    <- which would be 10/12/92



        
        BOY()           Begining of Year

	Syntax
	
        BOY([<expD>])

        <expD>  enter a optional date, else system date will be used

        This could also be used as begining of next year "BONY"

	Example
        
                         
        BOY(DATE())+366    <- lets assume this is 06/13/91

        Returns: a date string of: 01/01/92

        
        DATETST()       checks to see if a data field is empty

	Syntax
	
        DATETST([<expD>])

       [<expD>]  MUST have a manditory date type field


	Example
        
                         
        DATETST('&EVENT')

        Returns: '        '    <- this assumes that "EVENT" was empty



        
        DTOW()          Date to Word

	Syntax
	
        DTOW([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        DTOW('10/14/91')

        Returns: a character string of  October 14, 1991



        
        EOLM()          End of last Month

	Syntax
	
        EOLM([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        EOLM()             <- lets assume this is 03/13/91

        Returns: a character string of  02/28/91

        
        EOM()           End of Month

	Syntax
	
        EOM([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        EOM()             <- lets assume this is 07/07/91

        Returns: a character string of  07/31/91



        
        EOPY()          End of previous Year

	Syntax
	
        EOPY([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        EOPY(4)           <- lets assume this is 02/25/91

        Returns: a character string of  12/31/88



        
        EOW()           End of Week

	Syntax
	
        EOW([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        EOW(DATE())+14   <- lets assume this is 11/02/92

        Returns: a character of  Friday  <- which would be 11/20/92

        
        EOY()           End of Year

	Syntax
	
        EOY([<expD>])

        [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        EOY()            <- lets assume 09/11/92

        Returns: a character string of  12/31/92



        
        JULDAYS()       Display current/past Julian days

	Syntax
	
        JUYDAYS([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        JULDAYS('01/01/90')   <- lets assume 09/11/92

        Returns: a character of  2,446,432  Julian days have past



        
        LEAPYR()        Logical test for a Leap Year

	Syntax
	
        LEAPER(<none>)


	Example
        
                         
	IF LEAPYR()          	<- lets assume 09/11/92
         ? "There's 29 days this year"
        ELSE
         ? "There's 28 days this year"
        ENDI
 
        Returns: a logical value of: .T.            <- for this '92

        
        MNTHCAL()       Display a One Month Calender

	Syntax
	
        MNTHCAL([<expD>,<expN1>,<expN2>,<expN3>])

        [<expD >  enter a date, or leave blank
         <expN1>  input the starting Row
         <expN2>  input the starting Column
         <expN3>] input a number to specifiy the boarder  (default 1)

        NOTE: if NO parameters are passed, then <expN1> = 1  <expN2> = 1
                                                <expN3> = _ (no border)
              See BOXIT() for border box numbers

	Example
        
                         
        MNTHCAL(12,38,2)

        Returns: Calender in center of screen, with Single-Line Box



        
        NDIN2Y()        Give the number of days into a year

	Syntax
	
        NDIN2Y([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        NDIN2Y('07/27/91')

        Returns: a character of  208 Days

        
        NDINM()         Give the number of days in a specific Month

	Syntax
	
        NDINM([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        NDINM('09/14/91')

        Returns: a character of  30     <- days

        
        THETIME()       Display the time with 12-Hour format

	Syntax
	
        THETIME([<expN1>,<expN2>,<expL>])

        [<expN1>  input the starting Row
         <expN2>  input the starting Column
          <expL>] TRUE, colon will be Bright White/White
                  FALSE, colon will be Bright White/Black

        NOTE: if NO parameters are passed, then <expN1> = 12  <expN2> = 35
                                                 <expL> = .f. (default)
              Current system colors will be used for numbers

	Example
        
                         
        THETIME(12,38,.t.)    <- assume 2:14pm

        Returns: a character of  2:14pm  <- Colon will blink Bright White/White



        
        TTOW()          Time to Word

	Syntax
	
        TTOW(<none>)

        NOTE:     12:00 am - 11:59 am = Morning
                  12:00 pm -  5:59 pm = Afternoon
                   6:00 pm - 11:59 pm = Evening


	Example
        
                         
        TTOW()      <- assume its 4:16pm

        Returns: a character string of  Afternoon

        
        VLDDATE()       Point to a Valid Date

	Syntax
	
        VLDDATE([<expD>,<expN1>,<expN2>,<expC>])

       [<expD>  = pull-up current Month Calender
        <expN1> = Top   <expN2> = Left   <expC>] = Color  (all optional)

        NOTE: a simple pop-up calender will appear
              pointing to the current date


	Example
        
                         
        tdate = VLDDATE(date(),14,10,'G+/W')   <- point to 17 of 03/91

        Returns: a date string of  03/17/91



        
        WOFM()          Week of the Month

	Syntax
	
        WOFM([<expD>])

       [<expD>]  enter a optional date, else system date will be used


	Example
        
                         
        WOFM('04/14/92')

        Returns: a character of  3   <- week of the month



        
        YRDATE()        Return Year as 2 or 4 digits

	Syntax
	
        YRDATE([<expN>])

       [<expN>]  enter a 2 to drop Century  (optional)


	Example
        
                         
        YRDATE(2)        <- assume 1992

        Returns: a character string of  92

                                                        WINDOWS
	
        ADVRTIZE()      Top to Bottom Message Strober

	Syntax
	
        ADVRTIZE(<expC>)

        NOTE: this will drop a character string from top to bottom

	Example
        
                                                  
        ADVRTIZE('Jakes Garden of Gears')         
                                                  
        Returns: nada                             



        
        ASK1()          Display a Yes/No Message Box

	Syntax
	
        ASK1(<expC1>,[<expC2>,<expC3>,<expC4>])

         <expC1>  The YES Message to display
        [<expC2>  The NO Message to display (optional)
         <expC3>  Box Color (optional)
         <expC4>] Text Color (optional)


	Example
        
                         
        ASK1('OK','NO-WAY')

        Returns: message, and waits for <enter> on answer

        
        ASK2()          Display a Yes/No Message Box, with a question

	Syntax
	
        ASK2(<expC1>,[<expN>,<expC2>,<expC3>,<expL>,<expC4>,<expC5>])

         <expC1>  A question to ask
        [<expN>   Left-Top corner of Box (optional)
         <expC2>  The YES Message to display (optional)
         <expC3>  The NO Message to display (optional)
         <expC4>  Box Color (optional)
         <expC5>] Prompt Text Color (optional)


	Example
        
                         
        ASK2('APPLES STINK!','YA','NA',.t.,'R+/W','G/W')

        Returns: Asks if Apples STINK!, waits for response



        
        BOXIT()         Draw a simple Box on screen

	Syntax
	
        BOXIT([<expn1>,<expN2>,<expN3>,<expN4>,<expN5>])

        [<expN1>  = Top   
         <expN2>  = Left    
         <expN3>  = Bottom
         <expN4>  = Right 
         <expN5>] = Box Type

        Box Types: 1 = Double                       5 = Thick Line
                   2 = Single                       6 = NO Border
                   3 = Double Horz., Single Vert.
                   4 = Single Horz., Double Vert.

        NOTE: if NO parameters are passed, then a Box at Top-Left
              corner at: 5,23,14,55   with Double-Line


        Example
        
                         
        BOXIT(10,10,5,20,2)

        Returns: a character box

        
        BYEWIN()        Delete a Window made with SHADWIN()

	Syntax
	
        BYEWIN(<expB>)

        <expB> = is the name of the screen buffer to drop


	Example
        
                         
        BYEDWIN(winthis)

        Returns: nada

        
        CENTER()        Center text on Screen

	Syntax
	
        CENTER(<expN1>,<expC1>,[<expC2>,<expN2>])

         <expN1>  Row to display text at
         <expC1>  Text to display
        [<expC2>  color for message (optional)
         <expN2>] Length of row used [80 default] (optional)


	Example
        
                         
        CENTER(22,' Hi Air-Head! ','G/R',120)

        Returns: a character message and color at specific row/col



        
        CHKCOLR()       Test for Color Monitor

	Syntax
	
        CHKCOLR([<expC>])

        [<expC>]  Color combination to use   (optional)

        NOTE: If NO paramters are passed, then system attributes are used


	Example
        
                         
        CHKCOLR('G+/W')

        Returns: Bright Green on White  else  White on Black

        
        CLRTHIS()       Clear the screen with video effects

	Syntax
	
        CLRTHIS([<expN1>,<expN2>])

        [<expN1>  enter a optional number to use
               1 = pull-down window shade    2 = window shade pulled up
               3 = scan door right           4 = scan door left               
               5 = curtains open             6 = curtains closed
               7 = camera lens               8 = diagonal cut
               9 = verticle halfs sliced

         <expN2>] delay time of function         (defaults are: 1,20)


	Example
        
                         
        CHRTHIS(7)           <- camera lens

        Returns: nada



        
        DROPBOX()       Drop-down Box

	Syntax
	
        DROPBOX(<expN1>,<expN2>,<expN3>,<expN4>,<expN5>,<expN6>,[<expL>,
                 <expC1>,<expC2>])

         <expN1>  Top line position
         <expN2>  Left line position
         <expN3>  Bottom line position
         <expN4>  Right line position
         <expN5>  Box type (see BOXIT() for types)
         <expN6>  a numeric number for the delay of drawing the box
        [<expL>   flag that will allow for a shadow or not (optional)
         <expC1>] title for this box (optional)


	Example
        
                         
        DROPBOX(12,12,15,60,4,110,.t.)

        Returns: nada

        
        DROPCHR()       Drop characters to a specific place on screen

	Syntax
	
        DROPCHR(<expN1>,<expN2>,<expC>)

         <expN1>  Row to drop too
         <expN2>  Column to drop too
         <expC>   Text to drop


	Example
        
                         
        DROPCHR(14,14,'Drop the piece, Mugsy!')

        Returns: a character message



        
        ERRMSG()        Display an Error Message for failed function

	Syntax
	
        ERRMSG(<expC1>,[<expC2>,<expC3>,<expL>])

         <expC1>  Message to display
        [<expC2>  Box Color (optional)
         <expC3>  Message Color (optional)
         <expL>]  Flag to have sound or not [default ON]  (optional)


	Example
        
                         
        ERRMSG('More Memory, Cheapskate!')

        Returns: a character message-in-a-box

        
        EXPAND()        Expand text from Center outward

	Syntax
	
        EXPAND(<expC>,<expN1>,[<expN2>,<expN3>])

         <expC>   Text to display
         <expN1>  Row to display text           
        [<expN2>  Delay speed to expand at [default 20] (optional)
         <expN3>] Column to start erxpanding at [default 40] (optional)


	Example
        
                         
        EXPAND('TMCEL is getting spread around',14,80)

        Returns: a character message
 


        
        HIBAKBIT()      Control the intensity/blink of background

	Syntax
	
        HIBAKBIT(<[expL>])

         [<expL>] TRUE, Background will Blink  [default]  (optinal)
                  FALSE, Background will be Hi-Intensity


        Example
        
                         
        HIBAKBIT(.f.)

        Returns: Hi-intensity background



        
        KILBOX()        Delete a Box made with MAKBOX()

	Syntax
	
        KILBOX(<expB>)

        <expB> = is the name of the screen buffer to drop


	Example
        
                         
        KILBOX(boxthis)

        Returns: nada

        
        KILWIN()        Delete a Window made with MAKWIN()

	Syntax
	
        KILWIN(<expB>,[<expN>])

        <expB>  = is the name of the screen buffer to drop
       [<expN>] = delay speed in which to kill the window (optional)


	Example
        
                         
        KILWIN(winthis,140)

        Returns: nada
 


        
        MAKBOX()        Create an instant box in the screen

	Syntax
	
        MAKBOX(<expN1>,<expN2>,<expN3>,<expN4>,<expN5>,<expN6>,[<expC1>,
                <expL>,<expC2>])

         <expN1>  Top line position
         <expN2>  Left line position
         <expN3>  Bottom line position
         <expN4>  Right line position
         <expN5>  Box type (see BOXIT() for types)
         <expN6>  a numeric number for the delay of drawing the box
        [<expC1>  a character to use as a filler
         <expL>   flag that will allow for a shadow or not (optional)
         <expC2>] title for this box (optional)


	Example
        
                         
        MAKBOX(12,12,15,60,4,110,'',.t.,"BOXs 'R US")

        Returns: nada

        
        MAKWIN()        Explode a window on the screen

	Syntax
	
        MAKWIN(<expN1>,<expN2>,<expN3>,<expN4>,[<expN5>,<expN6>,<expC1>,
                <expB>,<expC2>])

         <expN1>  Top line position
         <expN2>  Left line position
         <expN3>  Bottom line position
         <expN4>  Right line position
        [<expN5>  Box type (see BOXIT() for types) (optional)
         <expN6>  a numeric number for the delay of drawing the box (optional)
         <expC1>  a color pair for the window (optional)
         <expB>   the array name to save the window shot for implosition
         <expC2>] title for this box (optional)


	Example
        
                         
        MAKWIN(12,12,15,60,4,110,'B+/R','SAVTHS',"WINDOWs 'R US")

        Returns: nada

        
        POPBOX()        Pop-down Box

	Syntax
	
        POPBOX(<expN1>,<expN2>,<expN3>,<expN4>,<expN5>,<expN6>,[<expL>,
                 <expC>])

         <expN1>  Top line position
         <expN2>  Left line position
         <expN3>  Bottom line position
         <expN4>  Right line position
         <expN5>  Box type (see BOXIT() for types)
         <expN6>  a numeric number for the delay of drawing the box
        [<expL>   flag that will allow for a shadow or not (optional)
         <expC>] title for this box (optional)


	Example
        
                         
        POPBOX(12,12,15,60,4,110,.t.)

        Returns: nada



        
        SCANUP()        Raise text up from the bottom of screen

	Syntax
	
        SCANUP(<expC>,[expN>])

        <expC>  = text to scroll-up from the bottom of screen
       [<expN>] = delay for scrolling text  (optional)


	Example
        
                         
        SCANUP('This is a test of the Emergency Broadcasting',85)
        SCANUP('System...had this been a real threat! so on',85)

        Returns: a character strings

        
        SHADWIN()       Shadowed Window

	Syntax
	
        SHADWIN(<expN1>,<expN2>,<expN3>,<expN4>,[<expN5>,<expC>])

         <expN1>  Top line position
         <expN2>  Left line position
         <expN3>  Bottom line position
         <expN4>  Right line position
        [<expN5>  Box type (see BOXIT() for types)
         <expC>]  title for this box (optional)


	Example
        
                         
        SHADWIN(10,10,20,50,2,'3 STOOGES')

        Returns: window with optional text



        
        STRECH()        Strech-out a line of text

	Syntax
	
        STRECH(<expC>,[<expN>])

        <expC>  = text to strech-out
       [<expN>] = space between characters  [default =1]  (optional)


	Example
        
                         
        STRECH('WIDER!',2)

        Returns: a character string of:  "W  I  D  E  R  !"

        
        TICRTPE()       Display text from right-to-left

	Syntax
	
        TICRTPE(<expN1>,<expC1>,[<expN2>,<expC2>])

         <expN1>  Row to display text
         <expC1>  Text to display           
        [<expN2>  Delay speed  (optional)
         <expC2>] Different color to set text to  (optional)


	Example
        
                         
        TICRTPE(12,'Current DOW-JONES average is at 15.78%',70)

        Returns: a character message, from right-to-left



        
        VMENU()         Verticle Menu Display

	Syntax
	
        VMENU(<expC1>,[<expC2>,<expN>,<expC3>,<expC4>])

         <expC1>  The array that contains the menu options
        [<expC2>  Title of the menu box (optional)
         <expN>   Box Type [default 1] (optional, see BOXIT() for types)
         <expC3>  Box Color (optional)
         <expC4>] Title Color (optional)

        Example
        
                         
        VMENU('options','MAIN',2,'W/R')

        Returns: verticle menu, with above value set

                                                        ENVIRONMENT
        
        CTOF()          Convert Celsius to Fahrenheit

	Syntax
	
        CTOF(<none>)



	Example
        
                         
        CTOF()
                 Opens a window, and asks for Celsius

        Returns: nada



        
        FTOC()          Convert Fahrenheit to Celsius

	Syntax
	
        FTOC(<none>)



	Example
        
                         
        FTOC()
                 Opens a window, and asks for Fahrenheit

        Returns: nada   



        
        HPWF()          Horsepower of a Waterfall

	Syntax
	
        HPWF(<expN1>,<expN2>,<expN3>)

         <expN1> Cross-section of water in square feet
         <expN2> Velocity of Flow in Feet-Per-Minute
         <expN3> Head of fall in Feet


	Example
        
                         
        HPWF(4,600,50)

        Returns: a character value of  225.45 HorsePower

        
        L2THD()         Lightning to Thunder Distance

	Syntax
	
        L2THD(<expN>)

         <expN> Time in seconds from lightning to thunder


	Example
        
                         
        L2THD(5)

        Returns: a character value of  1.10 miles



        
        WNDCHIL()       Calculates the WindChill Factor

	Syntax
	
        WNDCHIL(<none>)


        Example
        
                         
        WNDCHIL()
                 Opens a window, and asks for Wind Speed, Current Temp.

        Returns: nada

                                                        NETWORK
        
        FILELOK()       Lock a File on a Network

	Syntax
	
        FILELOK(<none>)


        Example
        
                         
        IF FILELOK()
         DO UPDATES
        ENDIF

        Returns: a logical value, or an alarm notice



        
        NETAVL()        Open a File for Exclusive or Shared use'

	Syntax
	
        NETAVL(<expC>,<expL2>,[<expN1>...<expN8>])

         <expC1>      Name of file to use
         <expL>       .T. = Exclusive,   .f. = Shared
        [<expC2...8>] Include up to 8 Indexes (optional


	Example
        
            
        SET EXCLUSIVE OFF
        IF ! NETAVL('EARNINGS,.T.)
         RETURN
        ENDIF

        Returns:  .T. if available,   .f. if NOT!

        
        RECLOK()        Lock a Record of a File on a Network

	Syntax
	
        RECLOK(<none>)

        Example
        
                         
        IF RECLOK()
         REPLACE PHONE with mPHONE
        ENDIF

        Returns: a logical value, or an alarm notice

                                                        TOOLS
        
        AGE()           Calculate an Age

	Syntax
	
        AGE(<expD>,<expC>)

         <expD> current or any year
         <expC> year born, or searching for


	Example
        
                         
        ANS = AGE(DATE(),'12/51')
        ? ANS

        Returns: a numeric value of  39



        
        ALARMS()        A variety of Alert Sounds

	Syntax
	
        ALARMS(<expN>)

         <expN> a numeric value of the following list:

           1   Dual-Alert Tone-Set #1
           2   HI-LO-HI
           3   Single Tone
           4   Small Tune
           5   The Fifth    (NO, not the Booze!)
           6   HI-LO Buzz
           7   Charge!
           8   LO-MED-HI 
           9   Siren
          10   NANNY,NANNY,BOO,BOO
          11   Thud
          12   HI-LO Beep
          13   Raspberry
          14   DUAL-ALERT Tone-Set #2
          15   Looney Tunes Theme


	Example
        
                         
        ALARMS(5)

        Returns: Bethovens 5th tune

        
        ANSICHK()       Checks to see if ANSI.SYS is in CONFIG.SYS

	Syntax
	
        ANSICHK(<none>)


        Example
        
                         
        CLEA
        ANSICHK()
        ? NONOMSG
        QUIT

        Returns: NULL if ALL is OK, else a message if NOT



        
        BEEPS()         Ring the Bell n times

	Syntax
	
        BEEPS([<expN>])

        [<expN>] Number of times to ring the Bell [default 1 beep]

         NOTE: This will be at 1-Second intervals, NO-MATTER
               what CPU is used...

	Example
        
                         
        BEEPS(4)

        Returns: nada      



        
        CHKCNFG()       Checks for certain amount of Files & Buffers

	Syntax
	
        CHKCNFG(<expC>,[<expN1>,<expN2>])

         <expC>   File to test
        [<expN1>  Number of Files to test for (optional)
         <expN2>] Number of Buffers to test for (optional)


	Example
        
                         
        CHKCNFG('CONFIG.SYS',41,17)

        Returns: nada, or a warning message                  
        
        CHKENV()        Test Clipper Environment Variables

	Syntax
	
        CHKENV(<expN1>,<expN2>,<expN3>,<expN4>,<expN5>,<expN6>)

         <expN1> Numeric value for: 'F' Files
         <expN2> Numeric value for: 'V' Max. Memory Available
         <expN3> Numeric value for: 'R' Reserve Memory (Runtime)
         <expN4> Numeric value for: 'E' Expanded Memory
         <expN5> Numeric value for: 'X' Excluded Memory (indexs)
         <expN6> Numeric value for: 'S' ?

         NOTE: ALL VALUES *MUST* BE ENTERED!  If one is NOT needed,
               then enter a 0 at its position.

	Example
        
                         
        IF CHKENV(65,22,26,0,0,0)
         @ 10,14 SAY 'OK'
        ELSE
         @ 10,14 SAY 'BAD!'
        ENDIF

        Returns: a logical value

        
        CHKMEM()        Pop-Up window with current Memory Free

	Syntax
	
        CHKMEM(<none>)


        Example
        
                         
        EXTERNAL CHKMEM
        SET KEY 306 TO CHKMEM()

        Now when you want to see Free Memory, just press ALT-M

        Returns: nada                           



        
        CURDRV()        Will return the Current Drive your at

	Syntax
	
        CURDRV(<none>)


	Example
        
                         
        ans = CURDRV()

        Returns: character variable of the drive

        
        DELAY()         Delay for n number of seconds

	Syntax
	
        DELAY([<expN>])

        [<expN>] Number of seconds of Delay  [default 1 sec.]

         NOTE: This will be at 1-Second intervals, NO-MATTER
               what CPU is used...

	Example
        
                         
        DELAY(7)

        Returns: nada      



        
        DSKCHK()        Checks a Floppy drive for Free Space

	Syntax
	
        DSKCHK(<expC1>,[<expC2>,<expC3>])

         <expC1>  Database name to transfer
        [<expC2>  Floppy Drive to transfer to  [Default 'A'] (optional) 
         <expC3>] Another name to give file  [Default <expC1>] (optional)


	Example
        
                         
        DSKCHK('BUGS','B','GONE')

        Returns: nada, or an ERROR MSG.

        
        FLDCNT()        Counts number of Fields in a DataBase

	Syntax
	
        FLDCNT(<expC>)

         <expC> Name of DataBase to check      


	Example
        
                         
        SET EXCLUSIVE OFF
        FILN = '        '
        @ 10,20 SAY 'ENTER DATABASE NAME: ' GET FILN PICT '!!!!!!!!'
        READ
        FILN = RTRIM('&FILN')
        ANS = FLDCNT('&FILN')
        IF EMPTY(ANS)
        ELSE
         @ 12,22 SAY '[ &FILN ] HAS: ' + TRANSFORM(ANS,'9999') + ' FIELDS'
        ENDIF

        Returns: a numeric value

        
        INDXBAR()       Graphically Displays an Index Percentage

	Syntax
	
        INDXBAR(<expC1>,[<expC2>,<expN>,<expL>])

         <expC1> Index Name
        [<expC2> Index Key(s) [Defaults to <expC1>]  (optional)
         <expN>  Row to start display at [Defaults to 9]  (optional)
         <expL>] Display current Record Counter  (optional)

         NOTE: Will EXIT immediately if DataBase is NOT found,
               or the KEY FIELD is WRONG or MISSING!

	Example
        
                         
        USE HOMER
        INDXBAR('BART','PROBLEMS',14,.T.)
        RETURN

        Returns: nada



        
        INT2STR()       Convert an Numeric to a String

	Syntax
	
        INT2STR(<expN>,[<expL>])

         <expN>  Numeric number to pass
        [<expL>] .T. if wanting 2 Decimal places  (optional)

        NOTE: Handy for removing the Left-Side "WHITE SPACE"
              of the results returned.


	Example
        
                         
        ANS = INT2STR(30.0406,.T.)
        ? ANS

        Returns: a character value of  30.04

        
        LIN()           Number of Lines to skip when Printing

	Syntax
	
        LIN(<expN>)

         <expN> Number of lines to skip

        NOTE: Although PROW() will work, this still can serve a purpose

	Example
        
           
        SET PRINT ON
        ? 'This is the first line...'
        LIN(7)
        ? 'This is line eight...'
        SET PRINT OFF

        Returns: nada      



        
        MSGON/MSGOFF()  Display a single-line message

	Syntax
	
        MSGON([<expC1>,<expL>,<expC2>,<expN1>,<expN2>])

        [<expC1>  Message you want to display  (optional)
         <expL>   .T. want tone alert [Default]  .f. NO tone alert (optional)
         <expC2>  Alternate Colors to use  (optional)
         <expN1>  Top position to display Box  (optional)
         <expN2>] Left position to display Box  (optional)

        NOTE: "Now Printing... please wait..." ,
              will display, if <expC1> is NOT passed.

	Example
        
                         
        MSGON('Re-Indexing the Wine List') 
        INDXBAR('WINES')
        MSGOFF()

        Returns: nada         

        
        PADLEFT()       Pad a Character string to the left      

	Syntax
	
        PADLEFT(<expC1>,<expN>,<expC2>)

         <expC1> Character String to Pad
         <expN>  FULL-Length of the Character String to Pad
         <expC2> Character to Pad the String with


	Example
        
                         
        PADLEFT('010111',8,'0')

        Returns: a character value of  "00010111"



        
        PADRGHT()       Pad a Character string to the Right     

	Syntax
	
        PADRGHT(<expC1>,<expN>,<expC2>)

         <expC1> Character String to Pad
         <expN>  FULL-Length of the Character String to Pad
         <expC2> Character to Pad the String with


	Example
        
                         
        PADRGHT('777',12,'4')

        Returns: a character value of  "77744444"



        
        PADSPAC()       Pad a Character string with Spaces      

	Syntax
	
        PADRGHT(<expC>,<expN>)

         <expC> Character String to add spaces, (or strip-off)
         <expN> Number of positions to the right


	Example
        
                         
        PADSPAC('T.M.S. Micro',14)

        Returns: a character string of  "T.M.S. Micro  "       

        
        PASSCHK()       Password Checking routine      

	Syntax
	
        PASSCHK(<expC>,[<expN>])

         <expC>  Character String PassWord to check against
        [<expN>] Row to place Box on  [Default 14]  (optional)

        NOTE: Naturally, the PASSWORD 'WILL-NOT' show on screen

	Example
        
                         
        IF PASSCHK('YOURMOM'12)
         DO SOMETHING
        ELSE
         RETU
        ENDIF

        Returns: a logical value                          



        
        PERCENT()       Percent of how far into a process

	Syntax
	
        PERCENT(<expN1>,<expN2>)

         <expN1> Starting Record number [Usually 1]
         <expN2> Ending Record number


	Example
        
                         
        USE AFILE
        DO WHIL ! EOF()
         @ 24,20 SAY PENCENT(RECNO(),RECCOUNT())
         REPLACE SOMETHING WITH mSOMETHING
         SKIP
        ENDDO

        Returns: a character value                        

        
        PICKIT()        A Front-End to  ACHOICE()

	Syntax
	
        PICKIT(<expN1>,<expN2>,<expN3>,<expN4>,<expC1>,[<expC2>,<expC3>,
               <expC4>,<expN5>,<expL>,<expC5>,<expC6>,<expN6>,<expC7>])

         <expN1>  Top line position
         <expN2>  Left line position
         <expN3>  Bottom line position
         <expN4>  Right line position
         <expC1>  the array name
        [<expC2>  Box Color  (optional)
         <expC3>  Bar Color  (optional)
         <expC4>  Status-line Color  (optional)
         <expN5>  Length of the array  (optional)
         <expL>   Weather to TAG items or not  (optional) 
         <expC5>  Un-Selected Color  (optional)
         <expC6>  HiLite item Color  (optional)
         <expN6>  Initial Element to HiLite  (optional)
         <expC7>] DrawBar Color   (optional)


	Example
        
                         
        tcnt = 137
        PRIVATE cityst_[tcnt], results
        RESULTS = PICKIT(16,7,22,73,cityst_,'','','',tcnt,.f.,GR+/B')
        ...
        ... etc.

        Returns: a numeric value

        
        PHNCALL()       Nifty Phone Book with Calling feature

	Syntax
	
        PHNCALL(<none>)


	Example
        

        EXTERNAL PHNCALL
        SET KEY -6 TO PHNCALL
        
        Just press F7 at any time to get to the Phone Book 

        Returns: nada



        
        PRTOF()         Checks for Printer Top-of-Form

	Syntax
	
        PRTOF([<expL>])

        [<expL>] .T. will check for Top-of-Form, and send EJECT if needed
                 .f. will return logical state of .T. or .f.  [default]

        Example
        

        ...
        ? 'NAME        ADDRESS             CITY       ST  ZIPCODE'           
        IF CNT = 55
         CNT = CNT + 1
        ELSE
         PRTOF(.t.)
         CNT = 1
        ENDIF
        ... etc.

        Returns: a logical value, or Ejects the page

        
        RANDFIL()       Random Filename Generator

	Syntax
	
        RANDFIL(<expC>)

         <expC> Name of DataBase to create Random Filename from

        NOTE: Filename of <expC> *MUST* already exist, or you
              will RETUrn inneadiately!

	Example
        
                         
        USE
        ANS = RANDFIL('MAX')
        USE &ANS

        Returns: a character value  filename



        
        SERIAL()        Returns your Libranries Serial Number

	Syntax
	
        SERIAL([<expL>])

        [<expL>] .T. = disable clearing Serial # Window
                 .f. = Clear Serial # Window, after display [default]

        NOTE: If TRUE, then a: KILWIN(boxser,nn)  will have to be issued. 
              nn = is a value for the delay of imploding window


	Example
        
                         
        SERIAL(.t.)
        ...
        ...
        KILWIN(boxser,90)

        Returns: nada           

        
        THEPATH()       Find any File on the PATH Statement

	Syntax
	
        THEPATH(<expC>)

         <expC> Name of File to search for


	Example
        
                         
        PTH = THEPATH('STD')       <--<< Good 'OL StupenDOS               
        ? PTH                            (Sorry Xtree, you loose!)

        Returns: a character value  C:\UTILS\   (NOTE: on my system)



        
        VERTMCL()       The Version # of this Library

	Syntax
	
        VERTMCL()


        Example
        
                         
        VERTMCL()
        INKEY(0)


        Returns: a character value

        
        VLD_AC()        Checks for a Valid AreaCode

	Syntax
	
        VLD_AC(<expN>)        

         <expN> AreaCode number to check      


	Example
        
                         
        ...
        mAC = SPACE(3)
        SET DELI TO '[]'
        SET DELI ON
        @ 10,30 SAY 'Enter AC: ' GET mAC PICT '999' VALID VLD_AC(@mAC)
        READ
        SET DELI OFF
        CENTER(20,' AreaCode for this area is [ &mAC ] ','BG/N')
        ...


        Returns: a numeric value

        
        VLD_CAN()       Checks for a Valid Canadian Postal Code

	Syntax
	
        VLD_CAN(<expC1>,<expC2>)


         <expC1> Providence State Code
         <expC2> Providence Postal Code

         NOTE: An input of: MBR   R3B 1G4 - would be Good (TRUE)
                     while: MBR   M1T 1G4 - would be BAD  (FALSE)
                                    M1T IS-NOT in the Manitoba region,
                                    rather, it is in the Ontario region
	Example
        
                         
        ...
        mST = SPACE(3)
        mPOSTCOD = SPACE(7)
        @ 10, 4 GET mST PICT '@!'
        @ 12, 4 GET mPOSTCOD PICT '!9! 9!9' VALID VLD_CAN(@mST,@mPOSTCOD)
        READ
        ...


        Returns: a logical value



        
        VLD_ST()        Checks for a Valid State Code

	Syntax
	
        VLD_ST(<expC>)        

         <expC> 2-Digit (abbreviation) for State Code


	Example
        
                         
        ...
        mST = SPACE(2)
        SET DELI TO '[]'
        SET DELI ON
        @ 10,30 SAY 'Enter ST: ' GET mST PICT '!!' VALID VLD_ST(@mST)
        READ
        SET DELI OFF
        CENTER(20,' State Code for this City is [ &mST ] ','BG/N')
        ...


        Returns: a numeric value


