************
*
*	Program....:  Text Interface Handler
*	Filename...:  TEXTHAND.PRG
*	Version....:  2.01
*	Author.....:  Robert C. Zilcoski
*	Date.......:  11/27/89
*	Purpose....:  To provide an efficient alternative to memo fields
*
************

************
*
*	If you find this system useful, a donation of $7 would be appreciated.
*	If you cannot afford $7, but you still find the system useful, any 
*	contribution would be appreciated.  Also, if you make enhancements
*       To this program, I would be interested in hearing about them.
*       I would be happy to try to help you if you have problems installing
*       or using this system.
*
*       Robert Zilcoski
*       PO Box 4716       
*       Rockville, MD 20850
*
************

************
*
*       I wrote these routines because I was dissatisfied with dBASE III+
*       memo fields.  Each item saved to a memo field requires at least 512
*       bytes.  Worse yet, when blocks are deleted, there is no way to
*       re-use the deleted blocks without using a custom memo field packer.
*
*       Hence, the Text Interface Handler.  It is very flexible in its  
*       setup.  For instance, the default size for text blocks are 64 bytes,
*       meaning a maximum waste of 63 bytes per record, instead of 511 bytes
*       as with .DBT files.  However, if you wish to increase or decrease the
*       size of the blocks, simply modify the structure of the database to
*       suit your needs.  Of course, this must be done before any records are
*       placed in it.  The key is a minimum of 8 bytes.  This can be  
*       increased to suit your needs.
*
*       NOTE:      Text from 1 to 65520 bytes may be saved.
*
*       WARNING:   The key _DELETE_ is reserved for record maintenience.
*                  DO NOT ACCESS THIS DATABASE WITH DBASE III+/IV IT 
*                  CONTAINS CHR(0)'s WHICH DBASE III+/IV CANNOT HANDLE
*                  IT MAY DESTORY YOUR TEXT BASE!
*
*       I believe that a utility should not interfere with a pre-existing 
*       program, or place restrictions on future programming.  Therefore,
*       there are NO PUBLIC variables used, and currently SELECTed areas are 
*       re-selected after all text interface operations.  I suggest using 
*       one of CLIPPERs higher SELECTtion areas out of the 254 available.
*       the only restriction for using these functions are that the four
*       functions OPENTEXT(), CLOSETEXT(), LOADTEXT(), and SAVETEXT() have
*       not been previously defined.  This program does make use of any
*       SETtings either.
*
************

*--------------------------------------------------------------------------
*              |              OPENTEXT()
*--------------------------------------------------------------------------
*              |
*  Syntax:     |    OPENTEXT(<expN>)
*              |
*  Argument:   |    <expN> corresponds to the area to SELECT for the text 
*              |           database.  Omitting <expN> results in the
*              |           SELECTtion of the first unused area.
*              |
*  Return:     |    A logical value.
*              |    (.T.) indicates that the operation was successful
*              |    (.F.) indicates that the file TEXT_DBF.DBF was
*              |          not present.
*              |
*  Usage:      |    Use OPENTEXT() to open the text interface.  This 
*              |    function is analogus to the USE command.
*              |
*              |
*--------------------------------------------------------------------------

*--------------------------------------------------------------------------
*              |              CLOSETEXT()
*--------------------------------------------------------------------------
*              |
*  Syntax:     |    CLOSETEXT()
*              |
*  Return:     |    A logical value.  
*              |    This function will always return (.T.)
*              |
*  Usage:      |    Use CLOSETEXT() to close the text interface. 
*              |
*--------------------------------------------------------------------------

*--------------------------------------------------------------------------
*              |              LOADTEXT()
*--------------------------------------------------------------------------
*              |
*  Syntax:     |    LOADTEXT(<expC>)
*              |
*  Argument:   |    <expC> is a unique key in the text database.
*              |      
*  Return:     |    A character string.
*              |    The retrieved text or null if the record was not found.
*              |
*  Usage:      |    LOADTEXT() is used to retrieve previously saved text
*              |    from the text interface.  
*              |
*---------------------------------------------------------------------------

*--------------------------------------------------------------------------
*              |              SAVETEXT()
*--------------------------------------------------------------------------
*              |
*  Syntax:     |    SAVETEXT(<expC1>,[@]<expC2>)
*              |
*  Argument:   |    <expC1> is the unique key to file <expC2> under.       
*              |    <expC2> is the text to save.  Pass by reference  
*              |            if possible to save time.
*              |
*  Return:     |    A logical value.
*              |    (.T.) indicates that the text was REPLACED
*              |    (.F.) indicates that the text was ADDED
*              |
*  Usage:      |    SAVETEXT() is used to add, replace, or delete text   
*              |    in the text database.  To add or replace text, call
*              |    this function with <expC1> and <expC2>.  To delete
*              |    text from the database, exclude <expC2>.
*
*--------------------------------------------------------------------------

***********************
*
*

function opentext

   parameters this_area

   private fail_open, orig_area

   orig_area = alias()
  
   fail_open = ! file("text_dbf.dbf")

   if ! fail_open

      select (if(pcount()=0,0,this_area))
      use text_dbf alias text_dbf

      if .not. file("text_dbf.ntx")
         index on text_key to text_dbf
      endif

      set index to text_dbf

   endif

   if .not. empty(orig_area)
      select (select(orig_area))
   endif

return ! fail_open

*
*
***********************
*
*

function closetext

   private orig_area

   orig_area = alias()

   select text_dbf
   use

   if .not. empty(orig_area) .and. ! upper(orig_area) = "TEXT_DBF" 
      select (select(orig_area))
   endif

return .t.

*
*
***********************
*
*

function loadtext

   parameters text_key
   private text_data, orig_area
   text_data = []
   orig_area = alias()
   select text_dbf

   *** Seek key

   seek m->text_key

   if found()

      *** Process all links in chain

      do while .t.
         text_data = m->text_data + text_data
         if bin2l(next_point) = 0
            exit
         else
            goto bin2l(next_point)
         endif
      enddo

   endif

   if .not. empty(orig_area)
      select (select(orig_area))
   endif

   release all except text_data

return trim(m->text_data)

*
*
************************
*
*

function savetext

   parameters text_key, text_data
   
   *** If only the key was specified, then create text_data with NULL

   if pcount() = 1
      text_data = []
   endif

   private orig_area, key_found, tot_links, link, next_point, prev_point
   private temp_point
   orig_area = alias()

   *** Seek key

   select text_dbf
   seek m->text_key
   key_found = found()

   *** If key was found, delete all links in the chain

   if key_found
      do while .t.
         replace text_key with "_DELETE_"
         if bin2l(next_point) > 0
            goto bin2l(next_point)
         else
            exit
         endif
      enddo
   endif

   *** Determine total links needed for chain

   tot_links = len(m->text_data)/len(text_data)
   tot_links = tot_links + if( m->tot_links = int(m->tot_links) ,0,1 )
   tot_links = int(tot_links)
   
   if tot_links > 0
      
      *** Process pointers for first link

      seek "_DELETE_"
      next_point = if(found(),recno(),reccount()+1)
      prev_point = 0      

      *** Add links to chain

      for link = 1 to tot_links

          *** Position database to assigned link

          if m->next_point > reccount()
             append blank
          else
             goto m->next_point
          endif

          *** Place key in link if this is the first link, otherwise make sure it's blank
  
          replace text_key with if(link=1,m->text_key,space(8))

          *** Process next pointer 

          temp_point = recno()
          seek "_DELETE_"
          next_point = if(found(),recno(),reccount()+1)
          goto temp_point
        
          *** Save text and pointers

          replace text_data with substr(m->text_data,(len(text_data)*(link-1))+1,len(text_data)), ;
                  next_point with l2bin(m->next_point), ;
                  prev_point with l2bin(m->prev_point)

          *** Save current record number as previous pointer

          prev_point = recno()

      next

      *** Null out next pointer for last record.

      replace next_point with l2bin(0)

   endif
 
   if .not. empty(orig_area)
      select (select(orig_area))
   endif

   commit

   release all except key_found

return key_found

*
*
********************
