/* 
**		file:			d_open.c
**		purpose:		routine to open a dbaseiii file for access by the other routines
**						in dbf.lib.
**		usage:		d = (struct DBF *)malloc(sizeof(struct DBF));
**						strcpy(d->filename,"filename.dbf");
**						d_open(d);
**						... access file with other routines ...
**						d_close(d);
**						free(d);
**		notes:		compile with "tcc -c d_open".  include this file in dbf.lib
**						see dbf.h for structure of DBF.  copy filename into structure
**						before calling d_open.
**		returns:		0			 if successful with structure filled in
**						NO_FILE	 if unable to find file
**						OUT_OF_MEM if not enough memory
**						BAD_FORMAT if not dBASE file
**		author:	 	Mark Sadler
**		revised:		6/18/87
*/ 

#include <stdio.h>
#include <alloc.h>
#include "dbf.h"

int d_open(struct DBF *d)
{
	int i;
	int n;

	d->status = not_open;							 /* in case can not open       */
	if((d->file_ptr = fopen(d->filename,"r+b")) == NULL)
		return(NO_FILE);

	rewind(d->file_ptr);

	fread((void *)&d->dbf_version,(unsigned)1,(unsigned)12,d->file_ptr);	/* read prolog                 */


	if (d->dbf_version != DB3FILE					/* check for dbiii file marker */
		&& d->dbf_version != DB3WITHMEMO
		|| d->update_mo == 0)
			{
			fclose(d->file_ptr);
			return(BAD_FORMAT);
			}

	d->current_record = 0L;
	d->num_fields = ((d->header_length - (FIELD_REC_LEN+1)) / HEADER_PROLOG);

	if((d->fields_ptr = (struct FIELD_RECORD *)malloc((unsigned)(d->num_fields * FIELD_REC_LEN)))==NULL)
		return(OUT_OF_MEM);

	/* position at field descriptions */
	fseek(d->file_ptr,(long)HEADER_PROLOG,0);
	
	/* read into field description array */
	fread((void *)d->fields_ptr,sizeof *d->fields_ptr,(unsigned)d->num_fields,d->file_ptr); 

	if((d->record_ptr = (char *)malloc(d->record_length))==NULL)
		return(OUT_OF_MEM);

	/* initialize pointers to fields in record. */
	for(i=0,n=1;i<d->num_fields;i++)		/* n is offset from start of rec     */
		{ 											/* @ n=0 is the deleted record flag  */
		d->fields_ptr[i].field_data_address = d->record_ptr + n;
		n += d->fields_ptr[i].len;
		}

	d->status = not_updated;						 /* open successfull */
	return(0);
}

#ifdef DEBUG_MAIN		/* test program */
main(int argc,char **argv)
{
	struct DBF d;
	int errornum;
	int i;

	if (argc != 2)
		{
		printf("Usage d_open filename");
		exit(1);
		}

	strcpy(d.filename,argv[1]);
	if(!strchr(d.filename,'.'))										 /* default to .dbf file	 */
		strcat(d.filename,".DBF");

	if((errornum = d_open(&d))!=0)												 /* open file							*/
	{
		printf("Error opening file: ");
		switch (errornum)
		{
			case OUT_OF_MEM:
				printf("Not enough memory.\n");
				break;
			case NO_FILE:
				printf("Can not open file %s.\n",d.filename);
				break;
			case BAD_FORMAT:
				printf("File %s is not a dBASE III file.\n",d.filename);
				break;
		}
		exit(1);
	}
	
	printf("\nFile Name: %s",d.filename);
	printf("\nCurrent Record: %ld",d.current_record);
	printf("\nDBF signature: %d",d.dbf_version);
	if (d.status==not_updated)
		printf("\nStatus Not Updated");
	else
		printf("\nStatus Not Open");
	printf("\nNumber of Fields: %d",d.num_fields);
	printf("\nUpdate Year: %d",d.update_yr);
	printf("\nUpdate Month: %d",d.update_mo);
	printf("\nUpdate Day: %d",d.update_day);
	printf("\nNumber of Records: %ld",d.records);
	printf("\nRecord Length: %d",d.record_length);
	for (i=0;i<d.num_fields;i++)
		printf("\nField #%d: %s",i,d.fields_ptr[i].name);
}
#endif
