*****
*
*	tbrdemo.prg
*

#include "inkey.ch"


parameters datafile, indexfile
*memvar datafile, indexfile
local b, n, aCol, cMac, cType, gType, more, kS, isAppend

*private b, cur_field, isAppend
memvar getlist

	if Valtype(datafile) == "U"
		?
		? "Must enter name of data file on command line."
		?
		quit

	end

	if .not. (File(datafile) .or. File(datafile + ".dbf"))
		?
		? "File not found."
		?
		quit

	end

	SetBlink(.t.)
	clear screen

	* file exists
	if Valtype(indexfile) == "C" .and.;
	   (File(indexfile) .or. File(indexfile + IndexExt()))
		use (datafile) index (indexfile)

	else
		use (datafile)

	end

	b := TBrowseDB(3, 6, 22, 73)
	b:headSep := ""
	b:colSep  := "  "
	b:footSep := ""

	aCol := TBColumnNew(";Record#", {|| Transform(Recno(),"9999999") })
	b:addColumn(aCol)

	for n = 1 to Fcount()
		cMac := "{||" + FieldName(n) + "}"
		aCol := TBColumnNew("This is;" + FieldName(n), &cMac)

		aCol:footing := "That was;" + FieldName(n)

		do case
		case Type(FieldName(n)) == "C"
			aCol:colorBlock := {|x,y| if(Len(Trim(x))<(Len(x)/2),{3,4},{5,6})}
		case Type(FieldName(n)) == "N"
			aCol:colorBlock := {|x,y| if(x<0,{11,12},if(x<500,{7,8},{9,10}))}
		case Type(FieldName(n)) == "D"
			aCol:width := 10
			aCol:defColor := {11,12}
		case Type(FieldName(n)) == "L"
			aCol:defColor := {13,14}
		end

		b:addColumn(aCol)
	next

	b:colorSpec := "W/N,N/W,BG,W+/BG,BG+,W+*/BG,G,W+/G,G+,W+*/G,R,W+/R,RB,W+/RB"
	b:skipBlock := {|x| Skipped(x, isAppend)}

	* draw box to illustrate window
	@ 2, 5, 20, 74 BOX "͸Գ"
	@ 5, 5  SAY ""
	@ 5, 74 SAY ""

	b:freeze := 1

	cType := SetCursor(0)
	isAppend := .f.

	more := .t.
	while (more)
		if ( b:colPos < 2 )
			b:colPos := 2
		end

		while ( .not. b:stabilize() )
			if ( NextKey() != 0 )
				exit
			end
		end

		if ((kS := Inkey()) == 0)
			if ( b:hitBottom )
				@ 1,62 Say "Record " + "Eof "

				if .not. isAppend
*					@ 24, 27 say "Add new record(s)? (y/n) "
*					if Chr(Inkey(0)) $ "YyTt"
						isAppend := .t.
						b:down()
						b:stabilize()	/* cause scroll */
						b:colorRect({b:rowPos,2,b:rowPos,b:colCount}, {2,2})
						SetCursor(cType)
*					end
*					@ 24, 27 say "                         "
				end

			elseif LastRec() == 0
				@ 1,62 Say "Record " + "None"
			elseif ( b:hitTop )
				@ 1,62 Say "Record " + "Bof "
			else
				@ 1,62 Say "Record " + LTrim(Str(Recno())) + "    "
			end

			while ( .not. b:stabilize() )
			end

			kS := Inkey(0)
		end

		do case
		case kS == K_DOWN
			if ( isAppend )
				if ( Recno() != Lastrec() + 1 )
					b:refreshCurrent()
					b:down()
					b:stabilize()	/* cause scroll */
					b:colorRect({b:rowPos,2,b:rowPos,b:colCount}, {2,2})
				end
			else
				b:down()
			end

		case kS == K_UP
			b:up()
			if ( isAppend )
				isAppend := .f.
				b:refreshAll()
				SetCursor(0)
			end

		case kS == K_PGDN
			if ( !isAppend )
				b:pageDown()
			end

		case kS == K_PGUP
			b:pageUp()
			if ( isAppend )
				isAppend := .f.
				b:refreshAll()
				SetCursor(0)
			end

		case kS == K_CTRL_PGUP
			b:goTop()
			if ( isAppend )
				isAppend := .f.
				SetCursor(0)
			end

		case kS == K_CTRL_PGDN
			b:goBottom()
			if ( isAppend )
				isAppend := .f.
				SetCursor(0)
			end

		case kS == K_RIGHT
			b:right()

		case kS == K_LEFT
			b:left()

		case kS == K_HOME
			b:home()

		case kS == K_END
			b:end()

		case kS == K_CTRL_LEFT
			b:panLeft()

		case kS == K_CTRL_RIGHT
			b:panRight()

		case kS == K_CTRL_HOME
			b:panHome()

		case kS == K_CTRL_END
			b:panEnd()

		case kS == K_RETURN
			n := b:colPos()
			if ( n > 1 .and. ( isAppend .or. Recno() != Lastrec() + 1 ) )
				while ( .not. b:stabilize() )
				end

				if ( isAppend .and. Recno() == Lastrec() + 1 )
					append blank
				end

				cur_field = FieldName(n - 1)
				@ Row(), Col() Get &cur_field
				gType := SetCursor(3)
				Read
				SetCursor(gType)

*				if ( change in index key eval )
*					b:refreshAll()
*				else
					b:refreshCurrent()
*				end

				if ( isAppend )
					b:colorRect({b:rowPos,2,b:rowPos,b:colCount}, {2,2})
				end
			end
		case kS == K_ESC
			more := .f.
		end
	end

	SetCursor(cType)

	@ 24,79 SAY " "

quit


****
*	Skipped(n)
*

func Skipped(n, isAppend)
local i

	i := 0
	if ( lastrec() != 0 )
		if ( n == 0 )
			skip 0

		elseif ( n > 0 .and. recno() != lastrec() + 1 )
			while ( i < n )
				skip 1
				if ( eof() )
					if ( isAppend )
						i++
					else
						skip -1
					end

					exit
				end

				i++
			end

		elseif ( n < 0 )
			while ( i > n )
				skip -1
				if ( bof() )
					exit
				end

				i--
			end
		end
	end

return (i)


* eof tbrdemo.prg
