;*********************************
;** tag.m		goto macro or
;**				function based on
;**				supplied tag.
;**

(macro tag
(
	(string
		tag_name
		pattern
		file
		extension
		f_pat
	)
	(int
		old_buf
		new_buf
	)
	
	(= old_buf (inq_buffer))
	(if (&& (!= (get_parm 0 tag_name "tag: ") 0)(!= tag_name ""))
	(
		(sprintf pattern "<%s[\\t]" tag_name)
		(= new_buf (create_buffer "Tags" "tags" 1))
		(set_buffer new_buf)
		(top_of_buffer)
		(if (> (search_fwd pattern) 0)
		(
			(beginning_of_line)
		   (get_token) ;** skip tag name
			(= file (get_token))
			(= pattern (get_token))
			(= f_pat (substr pattern 1 1))
			(set_buffer old_buf)
			(delete_buffer new_buf)
			(edit_file file)
			(inq_names NULL extension NULL)
			(set_msg_level 3)
			(execute_macro (+ "." extension))
			(set_msg_level 0)
			(top_of_buffer)
			(if (isdigit f_pat)
			(
				(move_abs (atoi pattern) 1)
			)
			;else
			(
				(search_fwd pattern)
			))
		)
		;else
		(
			(message "%s not in tags file" tag_name)
			(set_buffer old_buf)
			(delete_buffer new_buf)
		))
	)
	;else
	(
		(message "")
	))
))

(macro isdigit
(
	(string chr)
	(if (get_parm 0 chr)
	(
		(if (&& (>= chr "0")(<= chr "9"))
		(
			(returns 1)
		)
		;else
		(
			(returns 0)
		))
	)
	;else
	(
		(returns 0)
	))
))

(macro get_token
(
	(string
		token
		char
	)
	
	(= token "")
	(while (== (index "\t\n" (= char (read 1))) 0)
	(
		(+= token char)
		(next_char)
	))
	(returns token)
	(next_char)
))
