****************************************************************************
*
*   STRTOOLS.PRG:   A set of tools for analyzing character strings.
*
*   Written using Clipper 5.01
*   by Brian Rogers, 9 Nov 92.
*
*   Compile with:
*       CLIPPER STRTOOLS /N /W
*
****************************************************************************

****
*
*   AtAlpha( cTarget ) --> nIndex
*
*   Returns the first occurence of isalpha() in cTarget.
*   Returns 0 if there are no occurences of isalpha() or 
*   if cTarget is not a character string.
*
FUNCTION AtAlpha( cTarget )
    LOCAL nIndex:= 0        // current character being checked for isalpha()
    LOCAL nTargetLen        // length of cTarget, if it's a character string
    LOCAL lAlphaFound:= .f. // Whether or not an isalpha() has been found yet
    if ValType( cTarget ) = "C" .and. !empty( cTarget )
        // Storing the length in a variable keeps us from recomputing it
        // with every iteration of the loop.
        nTargetLen:= len( cTarget:= trim( cTarget ) )   // trim to save time
        while (nIndex++ < nTargetLen) ;
        .and. !(lAlphaFound:= isalpha( substr( cTarget, nIndex, 1 ) ))
        end
    endif
    return (if( lAlphaFound, nIndex, 0 ))
    // AtAlpha()



****
*
*   RatAlpha( cTarget ) --> nIndex
*
*   Returns the last occurence of isalpha() in cTarget.
*   Returns 0 if there are no occurences of isalpha() or 
*   if cTarget is not a character string.
*
FUNCTION RatAlpha( cTarget )
    LOCAL nIndex:= 0        // current character being checked for isalpha()
    LOCAL lAlphaFound:= .f. // Whether or not an isalpha() has been found yet
    if ValType( cTarget ) = "C" .and. !empty( cTarget )
        nIndex:= len( cTarget:= trim( cTarget ) ) + 1   // trim to save time
        while (--nIndex > 0)    /* start at end */  ;
        .and. !isalpha( substr( cTarget, nIndex, 1 ) )
        end
    endif
    return (nIndex)
    // RatAlpha()



****
*
*   AtDigit( cTarget ) --> nIndex
*
*   Returns the first occurence of isDigit() in cTarget.
*   Returns 0 if there are no occurences of isDigit() or 
*   if cTarget is not a character string.
*
FUNCTION AtDigit( cTarget )
    LOCAL nIndex:= 0        // current character being checked for isDigit()
    LOCAL nTargetLen        // length of cTarget, if it's a character string
    LOCAL lDigitFound:= .f. // Whether or not an isDigit() has been found yet
    if ValType( cTarget ) = "C" .and. !empty( cTarget )
        // Storing the length in a variable keeps us from recomputing it
        // with every iteration of the loop.
        nTargetLen:= len( cTarget:= trim( cTarget ) )   // trim to save time
        while (nIndex++ < nTargetLen) ;
        .and. !(lDigitFound:= isDigit( substr( cTarget, nIndex, 1 ) ))
        end
    endif
    return (if( lDigitFound, nIndex, 0 ))
    // AtDigit()



****
*
*   RatDigit( cTarget ) --> nIndex
*
*   Returns the last occurence of isDigit() in cTarget.
*   Returns 0 if there are no occurences of isDigit() or 
*   if cTarget is not a character string.
*
FUNCTION RatDigit( cTarget )
    LOCAL nIndex:= 0        // current character being checked for isDigit()
    LOCAL lDigitFound:= .f. // Whether or not an isDigit() has been found yet
    if ValType( cTarget ) = "C" .and. !empty( cTarget )
        nIndex:= len( cTarget:= trim( cTarget ) ) + 1   // trim to save time
        while (--nIndex > 0)    /* start at end */  ;
        .and. !isDigit( substr( cTarget, nIndex, 1 ) )
        end
    endif
    return (nIndex)
    // RatDigit()



****
*
*   IsAllAlpha( cTarget ) --> lAllAlpha
*
*   Returns .T. if every character in cTarget is an alphabetical 
*   character -- via isalpha().
*   Returns .F. if any character in cTarget is not an alpha character
*   or if cTarget is not a character string.
*
FUNCTION IsAllAlpha( cTarget )
    LOCAL lAllAlpha:= .f.   // Whether or not cTarget is only alpha chars
    LOCAL nIndex:= 0        // Character currently being checked
    LOCAL nTargetLen        // length of cTarget
    if valtype( cTarget ) = "C" .and. !empty( cTarget )
        nTargetLen:= len( cTarget )
        while (nIndex++ < nTargetLen) ;
        .and. (lAllAlpha:= isalpha( substr( cTarget, nIndex, 1 ) ))
        end
    endif
    return (lAllAlpha)
    // IsAllAlpha()



****
*
*   IsAllDigit( cTarget ) --> lAllDigit
*
*   Returns .T. if every character in cTarget is a digit (1 through 
*   9) -- via isDigit().
*   Returns .F. if any character in cTarget is not a Digit or if 
*   cTarget is not a character string.
*
FUNCTION IsAllDigit( cTarget )
    LOCAL lAllDigit:= .f.   // Whether or not cTarget is only Digits
    LOCAL nIndex:= 0        // Character currently being checked
    LOCAL nTargetLen        // length of cTarget
    if valtype( cTarget ) = "C" .and. !empty( cTarget )
        nTargetLen:= len( cTarget )
        while (nIndex++ < nTargetLen) ;
        .and. (lAllDigit:= isDigit( substr( cTarget, nIndex, 1 ) ))
        end
    endif
    return (lAllDigit)
    // IsAllDigit()



****
*
*   IsAllAlDig( cTarget ) --> lAllAlDig
*
*   Returns .T. if every character in cTarget is a digit (0 
*   through 9) or a letter -- via isDigit() .or. isAlpha().
*   Returns .F. if any character in cTarget is not a digit 
*   or letter, or if cTarget is not a character string.
*
FUNCTION IsAllAlDig( cTarget )
    LOCAL lAllAlDig:= .f.   // cTarget is only digits and letters
    LOCAL nIndex:= 0        // Character currently being checked
    LOCAL nTargetLen        // length of cTarget
    if valtype( cTarget ) = "C" .and. !empty( cTarget )
        nTargetLen:= len( cTarget )
        while (nIndex++ < nTargetLen) ;
        .and. (lAllAlDig:= ( isDigit( substr( cTarget, nIndex, 1 ) ) ;
                             .or. isAlpha( substr( cTarget, nIndex, 1 ) ) ;
                           ) ;
              )
        end
    endif
    return (lAllAlDig)
    // IsAllAlDig()

