/*
  Strong.ch V1.0
  ¿                                                         
   Ŵ Description: #INCLUDE this file for strong type support 
    Ŵ              within CA-Clipper PRG files.               
      Ŵ                                                         
        Ŵ                                                         
           Author     : Marc Gagnon (c) 1994 [CIS 71175,437]       
                                                           
  ٰ
    

Syntax:

      [STATIC] FUNCTION <idFunction>[ ( [ <idParameter> [AS|REF <idType>] ]
                                        [,...]
                                      )
                                    ] [ AS <idType> [ <idConvention> ] ]
                                      [ EXPORT LOCAL ]

        LOCAL  <idVariable> [,...] [ AS <idType> ]
        STATIC <idVariable> [,...] [ AS <idType> ]

Arguements:

        <idType> is any of the following strong types supported in VO.  For
                undetermined types use the "USUAL" type.  This strong typing
                can be used for formal parameter typing, function typing,
                and local & static variable typing.

                ARRAY      DWORD      LONGINT    REAL4      SYMBOL
                BYTE       FLOAT      OBJECT     REAL8      USUAL
                CODEBLOCK  INT        PSZ        SHORTINT   WORD
                DATE       LOGIC      PTR        STRING


        <idConvention> is the function calling convention to be used
                       mainly for parameter passing and return value
                       handling.  Can be any of the following:

                   CLIPPER, STRICT, PASCAL, CALLBACK

Notes:

        *To limit the number of preprocessor directives (i.e:memory
         and compile time savings), I implemented strong type support
         with "xTRANSLATE" in a very basic manner.

         The programmer must place the AS <idType> clause in the proper
         places (parameters, locals, statics and functions).  If placed
         anywhere else (in expressions or other commands) the AS <idType>
         clause will be accepted and simply nullified.

         A compile time error will occur when a non-supported <idType> or
         <idConvention> is specified.

*/


//-----------------------------------------------------------------------
#xTRANSLATE AS <idType:ARRAY,                                           ;
                       BYTE,                                            ;
                       CODEBLOCK,                                       ;
                       DATE,                                            ;
                       DWORD,                                           ;
                       FLOAT,                                           ;
                       INT,                                             ;
                       LOGIC,                                           ;
                       LONGINT,                                         ;
                       OBJECT,                                          ;
                       PSZ,                                             ;
                       PTR,                                             ;
                       REAL4,                                           ;
                       REAL8,                                           ;
                       SHORTINT,                                        ;
                       STRING,                                          ;
                       SYMBOL,                                          ;
                       USUAL,                                           ;
                       WORD                                             ;
               >                                                        ;
             [ <idConvention:CLIPPER, STRICT, PASCAL, CALLBACK> ]       ;
                         =>

#xTRANSLATE EXPORT LOCAL =>
#xTRANSLATE REF <idType> => AS <idType>
