; Program Name: strings.asm 
; Author: George Dunham 
; Copyright (c) 1988 by Unified Systems Computer Services,Inc. 
;-----------------------------------------------------------------------------
; Created: 8/18/1988 at 23:57
;
;=============================================================================
;
; Function : ABYTE()
;
; Syntax   : chr=ABYTE(Exp_C,Exp_N)
;                      
;                           
;                            Subscript
;                       String
;
; Purpose  : Return the n'th character from the string.
;
; Called From: CLIPPER S'87
;
; NOTE:    1. Great for using strings as character arrays
;          2. Defaults to the first Character.
;            
; Example  : string = 'ABCDE'
;            chr=ABYTE(string,4)         Result: ? chr   && 'D'
;
;=============================================================================
;
; Function : SXLATE()
;
; Syntax   : chr=SXLATE(Exp_C,Exp_C)
;                      
;                            
;                             String2  (String to translate)
;                        String1  (Translation table)
;
; Purpose  : Return translated string - Great for simple encription.
;
; Explanation : For each character in string2 the Hex value is used as
;               a subscript into the translate table and the character
;               at that position is then substituted into string2
;
; Called From: CLIPPER S'87
;
;=============================================================================
; Revision: 1.0 Last Revised: 8/18/1988 at 23:57
; Description: Original Creation.
;.............................................................................
;---------------------------- ALL RIGHTS RESERVED ----------------------------
PUBLIC ABYTE, SXLATE
 
 

extrn   __PARNI:far 
extrn   __PARC:far 
extrn   __PARCLEN:far 
extrn   __RETC:far 
 
       DGROUP  GROUP   datasg
       datasg  SEGMENT  '_DATA'
       sindex   dw      0
       slen     dw      1
       xlen     dw      1
       xseg     dw      0
       xoff     dw      0
       char     dw      0
       datasg  ENDS            

_PROG segment 'CODE' 

ASSUME  cs:_PROG,ds:DGROUP,es:DGROUP

SXLATE  PROC    FAR
        push    bp                   ; Save registers
        mov     bp,sp                ; Point bp to stack
        push    ds                   ; .
        push    es                   ; .
        push    si                   ; .
        push    di                   ; .
        mov     ax,2                 ; Param 2
        push    ax                   ; PUSH it
        call    __PARCLEN            ; Len of param 2 in AX
        add     sp,2                 ; Fix up stack
        mov     xlen,ax              ; Save Len
        mov     ax,1                 ; Param 1
        push    ax                   ; PUSH it
        call    __PARC               ; Get pointer to string1
        add     sp,2                 ; Fix up stack
        push    ax                   ; Save pointer
        push    dx                   ; .
        mov     ax,2                 ; Param 2
        push    ax                   ; PUSH it
        call    __PARC               ; Get pointer to string2
        add     sp,2                 ; Fix up stack
        mov     xseg,dx              ; Save pointer
        mov     xoff,ax              ; .
        mov     cx,xlen              ; Set counter to LEN(string2)
        pop     ds                   ; SEG pointer to string1
        pop     bx                   ; OFF pointer to string1
        push    ax                   ; OFF pointer to string2
        push    dx                   ; SEG pointer to string2
        pop     es                   ; SEG pointer to string2
        pop     di                   ; OFF pointer to string2
top:                                 ; Top of loop
        mov     al,BYTE PTR es:[di]  ; Chr from string2
        xlat                         ; AL has XLATED chr
        stosb                        ; to string2
        loop    top                  ; again
                                     ; 
        pop     di                   ; Restore regs
        pop     si                   ; or you'll never be 
        pop     es                   ;
        pop     ds                   ; heard from again!
        pop     bp                   ;
        push    xseg                 ; Put Segment on stack
        push    xoff                 ; Put Offset on stack
        call    __RETC               ; Return them to CLIPPER.
        add     sp,4                 ; Fix up stack.
        ret                          ; RETURN
SXLATE  ENDP

ABYTE   PROC    FAR
        push    bp                   ; Save registers
        mov     bp,sp                ; Point bp to stack
        push    ds                   ; .
        push    es                   ; .
        push    si                   ; .
        push    di                   ;  
        mov     word ptr char,0      ; Init return var
        mov     ax,2                 ; Param 2
        push    ax                   ; Push it
        call    __PARNI              ; Get integer
        add     sp,2                 ; Fix up stack
        mov     sindex,ax            ; Set subscript
        mov     ax,1                 ; Param 1
        push    ax                   ; Push it
        call    __PARCLEN            ; Get LEN(string)
        add     sp,2                 ; Fix up stack
        cmp     ax,sindex            ; Is subscript > LEN(string)
        jb      retl                 ; Yes goto retl
retm:                                ; No continue...
        mov     ax,1                 ; Param 1
        push    ax                   ; Push it
        call    __PARC               ; Get string
        add     sp,2                 ; Fix up stack
        add     ax,sindex            ; Subscript in AX
        push    ds                   ; Save SEG
        push    dx                   ; String SEG to stack
        pop     ds                   ; String SEG to DS
        dec     ax                   ; Fix up AX
        mov     si,ax                ; Source index
        lodsw                        ; Chr to AL
        xor     ah,ah                ; Clear AH
        pop     ds                   ; Restore DATA SEG
TEMPST:                              ; 
        mov     char,ax              ; Save char
        jmp     retz                 ; Goto end
                                     ; 
retl:                                ;
        mov     sindex,1             ; Force the first chr
        jmp     retm                 ; Return to getting string
retz:                                ; 
        pop     di                   ; Restore regs
        pop     si                   ; or you'll never be 
        pop     es                   ;
        pop     ds                   ; heard from again!
        pop     bp                   ;
        mov     ax,datasg            ; DATA SEG
        push    ax                   ; Put Segment on stack
        mov     ax, OFFSET char      ; Pointer to char
        push    ax                   ; Put Offset on stack
        call    __RETC               ; Return them to CLIPPER.
        add     sp,4                 ; Fix up stack.
        ret                          ; RETURN
ABYTE   ENDP
_PROG   ENDS 
        END  

