/*  ---------------------------------------------------------------------
 *
 *  stampver - Version stamping utility v1.0
 *             Glenn Scott (10/8/92)
 *
 *  Syntax:  stampver <filespec> <version> <date>
 *
 *  <filespec> can include wildcards
 *  <version>  is any version number that can be expressed as a
 *             time on the files.  In other words, version 1.0
 *             is 01:00:00am.  Version 2.75 is impossible.
 *             Version 2.1 is 02:10:00. 
 *             
 *  <date>     Is the date to stamp on the files.
 *
 *  Yeah, it's kind of limited but it works.  Bad data on the command
 *  line will kill you dead somewhere.
 *
 */

#include "ftint86.ch"

#define    INT21              33
#define    SET_DATETIME    22273         // 0x5701
#define    FO_READWRITE        2
#define    CARRY_FLAG          0

#define    HOUR(x)        (val(substr((x),1,2)))
#define    MINS(x)        (val(substr((x),4,2)))
#define    SECS(x)        (int(val(substr((x),7,2))/2))

#define    YR(x)          (year((x))-1980)

#define    RET_SUCCESS         0
#define    RET_FOERROR        -1
#define    RET_INT86ERR       -2
#define    RET_FAILED         -3

/* -------------------------------------------------------------------- */

function main( cSpec, cVer, cDate )
  local cTime 

  if pcount() != 3
     usage()
     quit
  endif

  cDate := ctod( cDate )
  cTime := verToTime( cVer )

  aeval( directory(cSpec),;
           { |x| qout( "Stamping " + x[1], ft_fdtime( x[1], cDate, cTime ) ) };
       )

  return nil

/* -------------------------------------------------------------------- */

function verToTime( cVer )
  local cHr, cMin

  cHr  := left( cVer, at( ".", cVer ) - 1 )
  cMin := subs( cVer, at( ".", cVer ) + 1 )

  if len( cHr ) == 1 
     cHr := "0" + cHr
  endif

  if len( cMin ) == 1
     cMin += "0"
  endif

  return cHr + ":" + cMin + ":" + "00"
  
/* -------------------------------------------------------------------- */

static function ft_fdtime( cFile, dDate, cTime )
  local aRegs[ INT86_MAX_REGS ], nRes, hF, nDate16, nTime16

  dDate := iif( dDate == nil, date(), dDate )
  cTime := iif( cTime == nil, time(), cTime )

  nTime16 := 2048 * HOUR( cTime )  +;     // Bits 11-15
               32 * MINS( cTime )  +;     // Bits  5-10
                    SECS( cTime )         // Bits  0-4

  nDate16 :=  512 * YR( dDate )    +;     // Bits  9-15
               32 * month( dDate ) +;     // Bits  5-8
                    day( dDate )

  if ( hF := fopen( cFile, 2 ) ) > 0
     aRegs[ AX ] := SET_DATETIME
     aRegs[ BX ] := hF
     aRegs[ CX ] := nTime16
     aRegs[ DX ] := nDate16

     if ft_int86( INT21, aRegs )
        nRes := iif( ft_isBitOn( aRegs[ FLAGS ], CARRY_FLAG ),;
                       RET_FAILED, RET_SUCCESS;
                   )
     else
        nRes := RET_INT86ERR
     endif

     fclose( hF )

  else
     nRes := RET_FOERROR
  endif

  return nRes 

/* -------------------------------------------------------------------- */

static function usage()
   qout( " Syntax:  stampver <filespec> <version> <date>" )
   qout( " " )
   qout( " <filespec> can include wildcards" )
   qout( " <version>  is any version number that can be expressed as a " )
   qout( "            time on the files.  In other words, version 1.0" )
   qout( "            is 01:00:00am.  Version 2.75 is impossible." )
   qout( "            Version 2.1 is 02:10:00. " )
   qout( " " )
   qout( " <date>     Is the date to stamp on the files." )
   qout( " " )
   return nil

