/*
-----------------------------------------------------------------------------
                  *** A Word From Our Sponsor ***

StatusBar() automatically initializes a status bar on the screen, then
fills in a progress bar as you index, fread, append from, etc.  It is one
of the many functions available in STEVE5.LIB, a complete library of useful
functions from:
                     Stephen L. Woolstenhulme
                     3805 Indigo Drive
                     Plano, Texas 75075
                     
                     CIS: 73060,1302

Order today!  The complete library, with norton guides and source code,
is just $99.  Texas residents please add sales tax.

This function, with full source code, is given as a "teaser" sample of
the good things to come if you buy the full library <g>.  Feel free to
use StatusBar() in all your applications!
-----------------------------------------------------------------------------

Program:  STATUSBA.PRG
 Author:  Stephen L. Woolstenhulme
Purpose:  Display a 'status of completion' box and bar.

 Syntax:  StatusBar( < nBytes >, < nSize >, [< nDispRow >],
          [< cTitle >], [< cColor >] )--> .t.

 Params:  nBytes   - Current recno() or bytes completed.
                     0 to initialize.
          nSize    - The total number of bytes/records.
          nDispRow - Top row to display status box.
                     Defaults to maxrow() - 4.
          cTitle   - The title for this status bar.
                     Defaults to '%'.
          cColor   - The color for the status bar.

Returns: .t.

Example:  Note -- Call StatusBar() once to set up, again to do the work,
                  and a third time to clean things up.

// Initialize everything.
StatusBar( 0, reccount(), 18, 'Indexing by Name', 'W+/R' )

// Build the new index, calling StatusBar in the code block.
dbcreateindex( 'BY_NAME.NTX', 'upper( LAST + FIRST )', ;
      { || StatusBar( recno() ), upper( LAST + FIRST ) } )

// Clear everything off.
StatusBar(0)

*/

#include 'setcurs.ch'
function StatusBar( nBytes, nSize, nDispRow, cTitle, cColor )
  static lBox, cScrn, cActiveColor, nMaxRow, nTotalSize, nKeyState
  local nMaxcol := maxcol(), nMaxLen, nReplicate
  local nPos, nInc, i
  nMaxLen := nMaxCol - 20

  if lBox == NIL .or. nBytes == 0

    if lBox != NIL .and. lBox
      // Restore screen, reset state variables.
      RestScreen( nMaxRow -4, 10 , nMaxRow - 1, nMaxCol - 10 + 1, cScrn )
      lBox         := NIL
      cActiveColor := NIL
      nMaxRow      := NIL
      nTotalSize   := NIL
      SetCursor( nKeyState )
    else            

      if cActiveColor == NIL .or. cColor != NIL
        cActiveColor := if( cColor != NIL, cColor, setcolor( ) )
      endif                            

      if nMaxRow == NIL .or. nDispRow != NIL
        nMaxRow := if( nDispRow == NIL , maxRow( ) , nDispRow + 4 )
      endif

      if nTotalSize == NIL .or. nSize != NIL
         nTotalSize := if( nSize == NIL, 0, nSize )
      endif              

      nKeyState := SetCursor( SC_NONE )

      // Save and draw our box.
      cScrn := SaveScreen( nMaxRow -4, 10 , nMaxRow - 1, ;
               nMaxCol - 10 + 1 )
      DispBox( nMaxRow -4, 10 , nMaxRow - 2, ;
               nMaxCol - 10, "͸Գ ", cActiveColor )

      // Draw on the number for our status bar.
      nInc := nMaxLen / 11 
      nPos := 0 
      nPos += nInc
      
      for i := 1 to 9                    
        SetPos( nMaxRow - 3, 11 + nPos )
        DevOut( str( i * 10 , 2 )  + '%', cActiveColor )
        nPos += nInc
      next 
      
      // Write our title.
      if( cTitle == NIL, cTitle := 'Completion Percentage', )
      cTitle := '[ ' + cTitle + ' ]'
      @ nDispRow, maxcol() / 2 - ( len( cTitle ) / 2 ) say cTitle color cColor
      lBox := .t. 
    endif

  else  

    if nBytes <= nTotalSize
      nReplicate := ( nMaxCol - 21 ) * ( nBytes / nTotalSize )
      SetPos( nMaxRow - 3, 11 )
      DevOut( replicate( '', nReplicate  ), cActiveColor )
    endif

  endif

return .t.
