DOSSEG
.MODEL      LARGE

PUBLIC      _iOffset, _bIsColor, _iTicks, _lLastRec, _lplRecno, _bUseBar
PUBLIC      _timeron, _timeroff, _bActive

EXTRN       __aFldiv:FAR        ;MS C runtime library routine for dividing longs
EXTRN       setint:FAR          ;see ints.asm

.DATA
_iTicks     dw      18          ;number of timer ticks between display updates
_lLastRec   dd      1           ;number of records in the database
_lplRecno   dd      0           ;pointer to the current record #
_iOffset    dw      0           ;offset into video memory for display
_bIsColor   dw      1           ;non-zero if color monitor present
_bUseBar    dw      1           ;non-zero if bar is to be used for display
installed   dw      0           ;non-zero if timer isr has been installed
_bActive    dw      0           ;non-zero if display is active
tickcount   dw      0           ;number of ticks until next display update
lastPercent dw      0           ;0 <= lastPercent <=50, last displayed percent
old8h       dw      2 dup(0)    ;old timer interrupt vector

.CODE

;----------------------------------_TIMERON-------------------------------------

;PURPOSE: Initializes progress display.  Installs timer routine if not yet
;         installed

_timeron    proc    far
            cmp     installed,0         ;see if timer routine installed
            jne     setactive

            mov     ax,SEG timerctrl    ;install timer int
            push    ax
            mov     ax,OFFSET timerctrl
            push    ax
            mov     ax,08h
            push    ax
            call    SETINT
            add     sp,6
            mov     old8h[0],ax         ;save old timer interrupt vector
            mov     old8h[2],dx
            mov     installed,1

setactive:  mov     ax,_iTicks
            mov     tickcount,ax
            mov     lastPercent,0
            mov     _bActive,1
            ret
_timeron    ENDP

;---------------------------------_TIMEROFF-------------------------------------

;PURPOSE: Turns of progress display.

_timeroff   proc    far
            push    es
            push    di

            mov     _bActive,0          ;disable progress display

            mov     bx,0b000h           ;load proper video segment
            cmp     _bIsColor,0
            je      notcolor2
            mov     bx,0b800h
notcolor2:  mov     es,bx
            mov     di,_iOffset

            cmp     _bUseBar,0          ;use bar or percent number?
            je      usenum2

            mov     ax,50               ;fill in complete bar
            mov     bl,''
bloop:      mov     es:[di],bl
            add     di,2
            dec     ax
            jnz     bloop
            jmp     offdone

usenum2:    mov     BYTE PTR es:[di],'1'        ;show 100 percent
            mov     BYTE PTR es:[di + 2],'0'
            mov     BYTE PTR es:[di + 4],'0'

offdone:    pop     di
            pop     es
            ret
_timeroff   ENDP

;----------------------------------TIMERCTRL-------------------------------------

oldtimer    label   dword
cs_old8h    dw      2 dup(?)

TIMERCTRL   proc    far
            pushf
            push    ds

            push    cx                  ;load old timer address into code seg
            mov     cx,DGROUP
            mov     ds,cx
            assume  ds:DGROUP
            mov     cx,old8h
            mov     cs:cs_old8h,cx
            mov     cx,old8h[2]
            mov     cs:cs_old8h[2],cx
            pop     cx

            cmp     _bActive,0          ;see if we're active
            jne     decrement
            jmp     calloldtime

decrement:  dec     tickcount           ;check for need to updat display
            jz      rollover
            jmp     calloldtime

rollover:   push    ax
            push    bx
            push    cx
            push    dx
            push    si
            push    di
            push    es

            mov     ax,_iTicks          ;reset tickcount
            mov     tickcount,ax

            les     si,_lplRecno
            mov     ax,es:[si]
            add     si,2
            mov     dx,es:[si]

            shl     ax,1                ;ax:dx = (recno() * 50), uses shift-add
            rcl     dx,1                ;technique to avoid long multiply
            mov     bx,ax
            mov     cx,dx
            shl     ax,1
            rcl     dx,1
            shl     ax,1
            rcl     dx,1
            shl     ax,1
            rcl     dx,1
            add     bx,ax
            adc     cx,dx
            shl     ax,1
            rcl     dx,1
            add     ax,bx
            adc     dx,cx

            mov     bx,WORD PTR _lLastRec[2]    ;load up for call to long div
            push    bx
            mov     bx,WORD PTR _lLastRec[0]
            push    bx
            push    dx
            push    ax
            call    FAR PTR __aFldiv            ;note, no stack clean up needed
                                                ;here.  Very strange.

            mov     cx,ax                       ;see if we really need to
            sub     ax,lastPercent              ;update display
            jbe     restoreregs

            push    cx
            mov     bx,0b000h           ;load video segment
            cmp     _bIsColor,0
            je      notcolor
            mov     bx,0b800h
notcolor:   mov     es,bx
            mov     di,_iOffset

            cmp     _bUseBar,0          ;use bar or percent number?
            je      usenumber

            mov     bl,''              ;fill in bar extension from last call
            add     di,lastPercent
            add     di,lastPercent
barloop:    mov     es:[di],bl
            add     di,2
            dec     ax
            jnz     barloop
            jmp     storelp

usenumber:  add     ax,lastPercent      ;display progress as percent number
            shl     ax,1
            add     di,4
            mov     bx,10

numloop:    cmp     ax,0
            je      storelp
            div     bl
            add     ah,48
            mov     es:[di],ah
            sub     ah,ah
            sub     di,2
            jmp     numloop

storelp:    pop     cx                  ;set lastPercent to current position
            mov     lastPercent,cx

restoreregs:pop     es
            pop     di
            pop     si
            pop     dx
            pop     cx
            pop     bx
            pop     ax

calloldtime:pop     ds                  ;jump to old timer routine
            popf
            assume  ds:nothing
            jmp     oldtimer
TIMERCTRL   ENDP
            END
