DOSSEG
.MODEL      LARGE

PUBLIC      SETINT

.DATA
intcount    dw      0           ;number of ints installed
ints        dw      30 dup(?)   ;array of old interrupt vectors and their #s
old21h      dw      2 dup(0)    ;old int 21h vector

.CODE

;-----------------------------------SETINT--------------------------------------

;PURPOSE: Saves old interrupt vector and number specified by intnum.  Installs
;         routine pointed to by newintseg:newintofs

SETINT      proc    far
            push    bp
            mov     bp,sp
intnum      equ     <[bp + 6]>
newintofs   equ     <[bp + 8]>
newintseg   equ     <[bp + 10]>
            push    es

            mov     ax,old21h[0]            ;see if exitctrl already installed
            mov     dx,old21h[2]
            or      ax,dx
            jnz     exitinst

            mov     ax,3521h                ;save old exit handler
            int     21h
            mov     old21h,bx
            mov     old21h[2],es

            push    ds                      ;set new exit handler
            mov     dx,OFFSET exitctrl
            mov     ax,SEG exitctrl
            mov     ds,ax
            mov     ax,2521h
            int     21h
            pop     ds

exitinst:   mov     ax,intnum               ;get old int pointer
            mov     ah,35h
            int     21h
            push    bx
            push    es

            push    ds
            mov     ax,intnum               ;set new int pointer
            mov     ah,25h
            mov     dx,newintofs
            mov     bx,newintseg
            mov     ds,bx
            int     21h
            pop     ds

            mov     bx,intcount             ;record old int pointer and num
            mov     ax,bx
            shl     ax,1
            add     bx,ax
            shl     bx,1
            add     bx,OFFSET ints
            mov     ax,intnum
            mov     [bx],ax
            pop     dx
            pop     ax
            mov     [bx + 2],ax
            mov     [bx + 4],dx
            inc     intcount

            pop     es
            mov     sp,bp
            pop     bp
            ret
SETINT      ENDP

;----------------------------------EXITCTRL-------------------------------------

EXITCTRL    proc    far
            jmp     overdata

exit_int    label   dword
old21h_c    dw      2 dup(?)

overdata:   pushf
            cmp     ah,4ch          ;only interested in function 4ch
            jne     calloldexit

            push    ax
            push    bx
            push    cx
            push    dx
            push    ds
            push    es
            push    di

            mov     ax,@DATA
            mov     ds,ax
            assume  ds:DGROUP

intloop:    cmp     intcount,0      ;restore all modified interrupt vectors
            je      loopdone
            dec     intcount
            mov     bx,intcount
            mov     ax,bx
            shl     ax,1
            add     bx,ax
            shl     bx,1
            add     bx,OFFSET ints
            push    ds
            mov     ah,25h
            mov     al,[bx]
            mov     dx,[bx + 2]
            mov     cx,[bx + 4]
            mov     ds,cx
            int     21h
            pop     ds
            jmp     intloop

loopdone:   mov     ax,2521h        ;restore old int 21h vector
            mov     dx,old21h
            mov     cx,old21h[2]
            mov     ds,cx
            int     21h
            pop     di
            pop     es
            pop     ds
            pop     dx
            pop     cx
            pop     bx
            pop     ax

calloldexit:push    ax              ;jump to old int 21h routine
            push    ds
            mov     ax,@DATA
            mov     ds,ax
            assume  ds:DGROUP
            mov     ax,old21h
            mov     cs:old21h_c,ax
            mov     ax,old21h[2]
            mov     cs:old21h_c[2],ax
            pop     ds
            pop     ax
            popf
            assume  ds:nothing,es:nothing
            jmp     exit_int
EXITCTRL    ENDP

END
