function ecran (couleur,mode)

local ecran1,ecran2,nrow,ncol,natt,nval,ecran

/* 
Paramtres 1 : 1= Ecran couleur    0= Ecran monochrome
Paramtres 2 : 1,2 ou 3    ( Affichage ecran )
Si le paramtre 2 est forc a 4, L'ecran se referme 
*/

if pcount()<>2 .or. valtype(couleur)<>"N" .or. valtype(mode)<>"N"
   save screen to ecran
   centre("ECRAN : Erreur de paramtres, Tapez une touche...",0)
   pause(0)
   restore screen from ecran
   return(NIL)
endif

ecran1 := setcolor()
ecran2 := { || transfert(couleur) }

if eval(ecran2)="1"
   set color to 3/0
else
   set color to w/n
endif

do case

   case mode=1

      nrow := 0
      while nrow <25

         @ nrow,00 say replicate(chr(176),80)
         nrow++

      end


   case mode=2

      nrow := 0
      ncol := 24
       
      while nrow <13 
 
         @ nrow,00 say replicate(chr(176),80)
         @ ncol,00 say replicate(chr(176),80)

         natt:= 120
         while natt>0
            natt--
         end

         nrow++
         ncol--

      end



   case mode=3

      nrow := 0
      ncol := 0
      nval := ""
               
      while nrow<13

         @ nrow,ncol,24-nrow,80-ncol box nval
         @ nrow,(ncol+1),24-nrow,80-(ncol+1) box nval
         @ nrow,(ncol+2),24-nrow,80-(ncol+2) box nval
         nrow++
         ncol=ncol+3

         natt := 170
         while natt>0
            natt--
         end
      
      end


   case mode=4

      set color to n/n
      nrow := 0
      ncol := 0
      nval := "        "

      while nrow<13

         @ nrow,ncol,24-nrow,80-(ncol) box nval
         @ nrow,ncol+1,24-nrow,80-(ncol+1) box nval
         @ nrow,ncol+2,24-nrow,80-(ncol+2) box nval

         nrow++
         ncol=ncol+3

         natt:=170
         while natt>0
            natt--
         end
      
      end

      set color to w/n
      clear

endcase


set color to ecran1

return(NIL)


/* Code block permettant de transferer un champ quelconque en caractre */
static function transfert (trans1)

do case 

   case valtype(trans1)="N"
      return(ltrim(str(trans1)))
 
   case valtype(trans1)="C"
      return(trans1)

   case valtype(trans1)="D"
      return(dtoc(trans1))

   case valtype(trans1)="L"
      return(if(trans1,"T","F"))

   otherwise 
      centre("Ce type de champs ne peut s'afficher, Tapez une touche...",0)
      pause(0)
      quit

endcase

return(NIL)



function pause (pause1)

/* Paramtre : Pause de X secondes */
local ecran

if pcount()<>1 .or. valtype(pause1)<>"N"
   save screen to ecran
   centre("PAUSE : Erreur de paramtres, Tapez une touche...",0)
   set cursor off
   inkey(0)
   set cursor on 
   restore screen from ecran
   return(NIL)
endif

set cursor off
inkey(pause1)
set cursor on

return(NIL)


function centre (centre1,centre2)

/* Paramtres : Chaine a centrer, Ligne d'affichage */

local centre3,centre4,centre5,ecran

if pcount()<>2 .or. valtype(centre1)<>"C" .or. valtype(centre2)<>"N"
   save screen to ecran
   centre3="           Erreur dans le passage des paramtres, Tapez une touche...           "
   @ 00,00 get centre3
   clear gets
   pause(0)
   restore screen from ecran
   return(NIL)
endif

centre1=alltrim(centre1)

if len(centre1)>79
   save screen to ecran
   centre3="            Cette chaine est trop longue, L'affichage est impossible            "
   @ 00,00 get centre3
   clear gets
   restore screen from ecran
   return(NIL)
endif

tone(800,1)

centre3 := 80-len(centre1)
centre3 := int(centre3/2)
centre4 := space(centre3)+centre1+space(centre3)

centre5=centre4+space(80-len(centre4))

@ centre2,00 get centre5
clear gets

return(NIL)


/* Gnration de menus droulants... */
function menuplus 

parameters _p1,_p2,_p3,_p4,_p5,_p6,_p7,_p8,_p9,_p10,_p11,_p12

local ecran,m1,m3,m4,m5,m6,m7,m8
set console on
set cursor on

/*
P1 : Ligne
P2 : Colonne
P3 -> P2 : Differentes options.
*/

m3 := {"N","N","C","C","C","C","C","C","C","C","C","C"}

if pcount()<3 .or. pcount()>12
   save screen to ecran
   centre("MENUPLUS : Erreur de paramtres, Tapez une touche...",0)
   pause(0)
   restore screen from ecran 
   return(NIL)
else

   m5 := 0
   m4 := 0

   for m1=1 to pcount()
       m2 := "_p"+ltrim(str(m1))

       if valtype(&m2)<>m3[m1] .and. valtype(&m2)<>"U"
           save screen to ecran
           centre("MENUPLUS : Le paramtre "+ltrim(str(m1))+" est incorrecte, Tapez une touche...",0)
           pause(0)
           restore screen from ecran 
           return(NIL)
       else

           if m1>2 .and. valtype(&m2)<>"U"
               m5++
               &m2=alltrim(&m2)

               if len(&m2)>m4
                   m4=len(&m2)
               endif
           endif

       endif 

   next m1

endif 

if m4=0
    save screen to ecran
    centre("Traitement impossible, Aucune option n'a t complte, Tapez une touche..",0)
    pause(0)
    restore screen from ecran
    return(NIL)
endif

m6 := setcolor()

ombre(_p1+1,_p2+1,_p1+m5+2,_p2+m4+5,8,0)

set color to b/g,b/w
@ _p1,_p2,_p1+m5+1,_p2+m4+3 box "         "

m7 := _p1+1
m8 := 3

while m5>0

   m1 := "_P"+ltrim(str(m8))

   if empty(&m1)
       @ m7,_p2+2 say ""
   else
       @ m7,_p2+2 prompt &m1+space(m4-len(&m1))
   endif

   m8++
   m7++
   m5--

end

menu to m2

set color to m6
return(m2)


function menu 

parameters _menu1,_menu2,_menu3,_menu4,_menu5,_menu6,_menu7,_menu8,_menu9,_menu10
local m1,m2,m3,m4,m5,m6,m7,m8,m9,ecran

set console on
set cursor on

/* 
   Menu1           = Ligne
   Menu2 -> Menu10 = Differentes options.
*/


m3 := {"N","C","C","C","C","C","C","C","C","C"}

if pcount()<2 .or. pcount()>10
   save screen to ecran
   centre("MENU : Erreur de paramtres, Tapez une touche...",0)
   pause(0)
   restore screen from ecran 
   return(NIL)
else

   m5 := 0
   m4 := 0

   for m1=1 to pcount()
       m2 := "_menu"+ltrim(str(m1))

       if valtype(&m2)<>m3[m1] .and. valtype(&m2)<>"U"
           save screen to ecran
           centre("MENU : Le paramtre "+ltrim(str(m1))+" est incorrecte, Tapez une touche...",0)
           pause(0)
           restore screen from ecran 
           return(NIL)
       else

           if m1>1 .and. valtype(&m2)<>"U"
               m5++
               &m2=alltrim(&m2)
               m4=m4+len(&m2)
           endif

       endif 

   next m1

endif

/* 
   M5 : Nombre d'elements a placer
   M4 : Longueur maxi des elements
*/

m1 := int((80-m4)/(m5+1))
m6 := m1
m7 := 2

m9 := setcolor()
set color to b/bg,w/b
@ _menu1,00 say space(80)

while m5>0

   m2 := "_menu"+ltrim(str(m7))
   @ _menu1,m6 prompt &m2

   m5--
   m6+=len(&m2)
   m6+=m1
   m7++

end

menu to m8

set color to m9
return(m8)



function message (mess1,mess2,mess3)

/* 
Mess1 : Ligne de saisie
Mess2 : Colonne de saisie
Mess3 : Longueur de la saisie
*/

local m1,m2,m3,m6,ecran

set console on
set cursor on

if valtype(mess1)<>"N" .or. valtype(mess2)<>"N" .or. valtype(mess3)<>"N" .and. pcount()<3 .or. pcount()>3
   save screen to ecran
   centre("MESSAGE : Erreur dans le passage des paramtres, Tapez une touche...",0)
   pause(0)
   restore screen from ecran
   return(NIL)
endif

if mess2+mess3>77
   save screen to ecran
   centre("MESSAGE : Le message risque de dborder de l'ecran, Tapez une touche...",0)
   pause(0)
   restore screen from ecran
   return(NIL)
endif

m6 := setcolor()

ombre(mess1+1,mess2-1,mess1+3,mess2+mess3+3,8,0)
set color to b/g,w/b
@ mess1,mess2-2,mess1+2,mess2+mess3+1 box "͸Գ "

m1 := space(mess3)
@ mess1+1,mess2 get m1
read

set color to m6
return(m1)



function confirme (ligne,colonne,quitter)

local m1,m2,m3,m6,ecran

m6 := setcolor()
save screen to ecran

if pcount()<2 .and. valtype(ligne)<>"N" .or. valtype(colonne)<>"N"
   centre("CONFIRME : Erreur dans le passage des parametres, Tapez une touche...",0)
   pause(0)
   restore screen from ecran
   return(.f.)
endif

if ligne>19 .or. colonne>55
   centre("CONFIRME : Le traitement risque de sortir de l'ecran, Tapez une touche...",0)
   pause(0)
   restore screen from ecran
   return(.f.)
endif

ombre(ligne+1,colonne+1,ligne+4,colonne+23,8,0)
set color to b/g
@ ligne,colonne,ligne+3,colonne+21 box "͸Գ "

@ ligne,colonne+3 say " Confirmation "

set color to w+/b,w*/rb

@ ligne+2,colonne+3 clear to ligne+2,colonne+9
@ ligne+2,colonne+22 clear to ligne+2,colonne+18

@ ligne+2,colonne+3  prompt "  Oui  "
@ ligne+2,colonne+12 prompt "  Non  "

menu to m2

if m2=0 .or. m2=2
   restore screen from ecran
   set color to m6
   return(.F.)
endif

if quitter<>NIL
   set color to w/n,n/w
   set cursor on
   set printer to
   cls
   clear all
   quit
endif

return(.T.)



function boiter (boite2,boite3,boite4,boite5)

local boite1

if pcount()<>4
   centre("BOITE : Erreur dans le passage des parametres, Tapez une touche...",0)
   pause(0)
   return(.f.)
endif

boite1 = setcolor()

ombre(boite2+1,boite3+2,boite4+1,boite5+2,8,0)

set color to w+/r
@ boite2,boite3 clear to boite4,boite5

set color to boite1

return(.t.)





function boite (boite2,boite3,boite4,boite5)

local boite1

if pcount()<>4
   centre("BOITE : Erreur dans le passage des parametres, Tapez une touche...",0)
   pause(0)
   return(.f.)
endif

boite1 = setcolor()

ombre(boite2+1,boite3+2,boite4+1,boite5+2,8,0) 

set color to b/g
@ boite2,boite3 clear to boite4,boite5

set color to boite1

return(.t.)



