/***                                                                        
* clipint.c                                                                 
*                                                                           
* Interrupt class                                                           
*                                                                           
* c_int86() - Make interrupt call                                           
*/                                                                          
                                                                        
#include "nandef.h"                                                         
#include "extend.h"                                                         
#include "dos.h"                                                            
                                                                        
/***                                                                        
* CHARACTER c_int86(intno, inregs)                                          
*                                                                           
* NUMERIC intno    - Interrupt number                                       
* CHARACTER inregs - Input registers                                        
*                                                                           
* Returns output registers                                                  
*/                                                                          
                                                                        
CLIPPER c_int86()                                                           
                                                                        
{                                                                           
    union REGS outregs;    /* We will return these output registers         
                              to Clipper */                                 
                                                                        
    int86(_parni(1), (union REGS *) _parc(2), &outregs);                    
                                                                        
    _retclen((char *) &outregs, sizeof(union REGS));                        
                                                                           

