*******************************************************************************
*                                                                             *
*                                PATH examples                                *
*                                                                             *
*                              Jayson R. Minard                               *
*                                                                             *
*******************************************************************************


*- the following header files include the prototypes for the string and
*  path functions.

#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR

*- the following function corrects a path into a string that the filename
*  can be added to:
*
*     path = FixPath( path )
*     path = path + "filename.ext"
*

FUNCTION CHAR Fixpath
  PARAMETERS VALUE CHAR filespec

  * NOTE:  this only works with paths and not with full filenames...

  VARDEF
    CHAR   final_spec based filespec
    CHAR   other_spec
  ENDDEF

  *- get rid of spaces
  final_spec = TRIM( final_spec )

  IF LEN( final_spec ) = 0
  *- if the string is empty, get the current directory
    final_spec = CHR( CURDRIVE() + 'A' ) + ":" + CURDIR( 0 )

  ELSE

    *- check for . first (current directory)

    IF LEFT( final_spec, 2 ) = ".\"
    *- call ourselves to get the current directory
      final_spec = Fixpath( "" ) + SUBSTR( final_spec, 3, LEN( final_spec )-2 )
    ELSE

      *- check for .. now (previous directory)

      IF LEFT( final_spec, 3 )="..\"
        other_spec = TRIM( Fixpath( "" ) )

        DO WHILE LEFT( final_spec, 3 ) = "..\"
          final_spec = TRIM( SUBSTR( final_spec, 4, LEN( final_spec )-3 ) )

          *- get the current directory 'other_spec' and find it's previous dir
          IF LEN( other_spec )>2

            IF RIGHT( other_spec, 1 ) = "\"
              other_spec = LEFT( other_spec, LEN( other_spec )-1 )
            ENDIF

            IF RAT( "\", other_spec )>0
              other_spec = LEFT( other_spec, RAT( "\", other_spec )-1 )
            ENDIF

          ENDIF

        ENDDO

        *- add a trailing \
        IF RIGHT( other_spec, 1 ) <> "\"
          other_spec = other_spec + "\"
          final_spec = other_spec + final_spec
        ENDIF

      ENDIF

    ENDIF

  ENDIF

  *- make sure a drive name is attached

  IF .NOT. ( SUBSTR( final_spec, 2, 1 ) = ":" )
    IF SUBSTR( final_spec, 1, 1 ) = "\"
      final_spec = CHR( CURDRIVE() + 'A' ) + ":" + final_spec
    ELSE
      final_spec = CHR( CURDRIVE() + 'A' ) + ":\" + final_spec
    ENDIF

  ELSE
    IF LEN( final_spec ) = 2
      final_spec = final_spec + "\"
    ENDIF

  ENDIF

  *- ensure that path ends with a \

  IF .NOT. ( SUBSTR( final_spec, LEN( final_spec ), 1 ) = "\" )
    final_spec = final_spec + "\"
  ENDIF

  *- retrim to eliminate leading and trailing spaces

  final_spec = UPPER( TRIM( final_spec ) )

  RETURN final_spec
ENDPRO                                 && FUNCTION CHAR FixPath

VARDEF
  CHAR( 128 ) old_path, new_path
ENDDEF

PROCEDURE FORCE_MAIN


  old_path = ".\test\test\temp"
  CLEAR

  @10, 0 SAY "Enter path 1: " GET old_path PICTURE "@!@S40"
  READ

  @12, 0 SAY "  old path: "+old_path
  new_path = Fixpath( old_path )
  @13, 0 SAY "  new path: "+new_path

  old_path = Fixpath( "..\" )
  @15, 0 SAY "Enter path 2: " GET old_path PICTURE "@!@S40"
  READ

  @17, 0 SAY "  old path: "+old_path
  new_path = Fixpath( old_path )
  @19, 0 SAY "  new path: "+new_path
  ?
  ?

ENDPRO