1                   NORMAL.STY                                                          POSTSCRP @ 0        *****************************************************************************
* Function: Send()
* Authors : Jake Jacob & Tom Chang
* Version : Summer 87
* Syntax  : Send(<expC1>,<expC2>[,<expN1>[,<expN2>]])
*           <expC1> = filename or printport, TEXT.TXT,LPT1,LPT2,etc.
*           <expC2> = character string to send or print.
*           <expN1> = method of positioning the pointer.
*        0 = beginning of file.
*        1 = somewhere within the file.
*        2 = end of file.
*           <expN2> = number of bytes to move forward if
*        <expn2> = 1.

FUNCTION SEND
PARAMETERS FILE_PORT, STRING, METHOD, POINTER

    PRIVATE FH, RETVALUE, METHOD, POINTER
    RETVALUE = 1

    IF LEN(STRING) = 0
       RETURN 7
    ENDIF
    IF .NOT. (METHOD >= 0 .AND. METHOD <= 2)
       RETURN 11
    ENDIF
    IF METHOD = 1 .AND. PCOUNT() = 3 .AND. POINTER <= 0
       RETURN 9
    ENDIF

    FH = FOPEN(FILE_PORT,2)

    IF FH = -1
       DO CASE
          CASE FERROR() = 2
            RETVALUE = 2                && file/port does not exist
          CASE FERROR() = 3
            RETVALUE = 3                && path not found
          CASE FERROR() = 4
            RETVALUE = 4                && no more handles left
          CASE FERROR() = 5
            RETVALUE = 5      && access denied
          CASE FERROR() = 15
            RETVALUE = 10               && invalid drive
        ENDCASE
    ELSE
        IF PCOUNT() > 2
            IF METHOD = 0 .OR. METHOD = 2
                FSEEK(FH,0,METHOD)
            ELSE
                IF PCOUNT() > 3
                    FSEEK(FH,POINTER,0)
                    IF FERROR() = 1
                        RETURN 12
                    ENDIF
                ENDIF
            ENDIF
        ENDIF
        ERROR = FWRITE(FH,STRING) = 0
        DO CASE
           CASE ERROR = 0
                RETVALUE = 6            && cannot write to file/port
           CASE ERROR != LEN(STRING)
                RETVALUE = 8            && buffer partially sent
        ENDCASE
    ENDIF

    FCLOSE(FH)

RETURN RETVALUE
܀                  U        0  Y                                                              
Y  t              2  D  F                                                              
F  ^  o  z                                                                            
  9  ;  K  [  x        2  s                                                              
s          )  3  L  w                                                                  
        ?  Z  q                                                                      
    ,  R                                                                            
          R                                                                             
     -  V      !                (       10/17/8910/17/89V  