* ------------------------------------------------------------------------- *
* Function: CreateScrStack                                                  *
* Syntax:   CreateScrStack(<work area>, <RAM to use>, [<path>])             *
* Where:    <work area>  = a number of an area to use for the database      *
*                          where the memo field with the stack are located. *
*           <RAM to use> = amount of RAM that can be used before the memo   *
*                          field is used.  Using the memo field increases   *
*                          available RAM for other purposes but             *
*                          significantly reduces speed of screen exchanges. *
*           <path>       = Optional.  Path to use for the stack database.   *
*                          Should be a RAM disk if one is available.        *
* Purpose:  Setup public variables and create a memo field to be used for   *
*           the stack.                                                      *
* ------------------------------------------------------------------------- *
FUNCTION CreateScrStack
PARAMETERS db_area, mem_alloc, PATH
PUBLIC sys_scr_idx, sys_mem_stack, sys_mem_left
PRIVATE screens,cur_sel
sys_mem_left = mem_alloc * 1024
sys_mem_stack = ''
STORE SELECT() TO cur_sel
SELECT (db_area)
IF PCount() < 3
   screens = "stack.dbf"
ELSE
   screens = PATH+"stack.dbf"
ENDIF
IF FILE(screens)
   USE (screens) EXCLUSIVE
ENDIF
* -----
* If the database is unable to be opened exclusively, it's on a network and
* someone has already created it.  In that case, we only want to append a 
* record and keep it locked until we leave the program.
* -----
IF .NOT. neterr()
   CREATE temp
   APPEND BLANK
   REPLACE field_name WITH "SCR_STACK", field_type WITH "M";
      field_len WITH 10, field_dec WITH 0
   USE
   CREATE (screens) FROM temp
   ERASE temp.dbf
ENDIF
USE (screens) ALIAS scr
APPEND BLANK
sys_scr_idx = 0
SELECT (cur_sel)
RETURN(.T.)
*** End Function CreateScrSt ***

* ------------------------------------------------------------------------- *
* Function:    MakeBox                                                      *
* Syntax:      MakeBox(Top, Left, Bottom, Right)                            *
* Purpose:     Push the bound area on the stack and clear the area          *
* ------------------------------------------------------------------------- *
FUNCTION MakeBox
PARAMETERS t,l,b,r
PushScr(savebox(t,l,b,r))
@ t,l CLEAR TO b,r
RETURN(.T.)
*** End Function MakeBox ***

* ------------------------------------------------------------------------- *
* Function:    UnMakeBox                                                    *
* Purpose:     Pop the last saved box and restore it to the screen          *
* ------------------------------------------------------------------------- *
FUNCTION UnMakeBox
RestBox(PopScr())
RETURN(.T.)
*** End Function UnMakeBox ***

* ------------------------------------------------------------------------- *
* Function:    PushScr                                                      *
* Syntax:      PushScr(ScrBox)                                              *
* Purpose:     Push the screen mem var on the stack. If the RAM is already  *
*              used up, replace all chr(26) (EOF character) with chr(227)   *
*              which is PI and is unlikely to be on the screen. chr(226)    *
*              (Greek Gamma) is used as a separator character as it is also *
*              unlikely to be on the screen.                                *
*              If there is still room in RAM, add the box and subtract it's *
*              size from the sys_mem_left variable.                         *
* ------------------------------------------------------------------------- *
FUNCTION PushScr
PARAMETERS scr_box
sys_scr_idx = sys_scr_idx + 1
if len(scr_box) >= sys_mem_left .or. .not. empty(scr->scr_stack)
    REPLACE scr->scr_stack WITH strtran(scr_box,CHR(26),CHR(227)) +;
           CHR(226) + scr->scr_stack
else
    sys_mem_stack = scr_box + chr(226) + sys_mem_stack
    sys_mem_left = sys_mem_left - (len(scr_box))
endif
RETURN(.T.)
*** End Function PushScr ***

* ------------------------------------------------------------------------- *
* Function:    PopScr                                                       *
* Purpose:     Pop the saved screen off the stack                           *
* ------------------------------------------------------------------------- *
FUNCTION PopScr
PRIVATE scr_box
IF sys_scr_idx < 1
   RETURN("")
ENDIF
if ! empty(scr->scr_stack)
    STORE SUBSTR(scr->scr_stack,1,AT(CHR(226),scr->scr_stack)-1) TO scr_box
    REPLACE scr->scr_stack WITH;
       SUBSTR(scr->scr_stack, AT(CHR(226),scr->scr_stack)+1,;
       LEN(scr->scr_stack))
    scr_box = StrTran(scr_box,chr(227),chr(26))
else
    STORE SUBSTR(sys_mem_stack,1,AT(CHR(226),sys_mem_stack)-1) TO scr_box
    sys_mem_stack = SUBSTR(sys_mem_stack, AT(CHR(226),sys_mem_stack)+1,LEN(sys_mem_stack))
    sys_mem_left = sys_mem_left + len(scr_box)
endif
sys_scr_idx = sys_scr_idx - 1
RETURN(scr_box)
*** End Function PopScr ***

