*/////////////////////////////////////////////////////////////////////////////*
*                                                                             *
*                                SCRN.PRG                                     *
*                   Copyright (c) 1989  by Richard W. Rahn                    *
*                                                                             *
*         Demonstration of restoring a screen saved to a memory variable      *
*         in a wipe from left to right fashion.                               *
*                                                                             *
*  Author  : Richard W. Rahn    3/16/89                                       *
*                                                                             *
*  Comments: I have come across many different routines that can pop-up       *
*            boxes/windows with various cosmetic twists but I have seen       *
*            none that can restore a screen or screen portion with a          *
*            cosmetic twist. I decided to take a few minutes and experiment.  *
*            Below is the result.                                             *
*                                                                             *
*                                                                             *
*            You are free to use this routine in any form that you wish.      *
*            All I ask is that you share with the development community       *
*            any improvements or modifications to this code.                  *
*                                                                             *
*            Any comments or suggestions can be addressed to me at:           *
*                                                                             *
*            Plantz BBS        (312) - 885-2303    ID0146                     *
*            The BOSS          (201) - 568-7293    Richard Rahn               *
*            Clip Joint        (312) - 383-7517    Richard Rahn               *
*/////////////////////////////////////////////////////////////////////////////*
set color to w+/n
clear

* Screen cooridinates
  t=10
  l=5
  b=20
  r=75

* draw stuff on screen
  set color to w+/b
  @ t,l to b,r double
  @ t,l clear to b,r
  @ t+1,l+2 say '   This is a demonstration of restoring a screen piece by piece.'
  @ t+3,l+2 say '         This function is written entirely in Clipper.'
  @ t+5,l+2 say '  This is the original box that will be saved and then restored.'
  @ t+7,l+2 say '              Copyright (c) 1989 by Richard W. Rahn'
  @ t+9,l+2 say '                    Press any key to continue..'

* Save screen portion
  tmp = savescreen(t,l,b,r)
  inkey(0)

* Draw a box over original box
  set color to w+/r
  @ t,l clear to b,r
  @ t,l to b,r double
  @ t+2,l+2 say '                New box popped over old blue box.'
  @ t+6,l+2 say '                  Press any key to continue...'
  inkey(0)

* Implode original screen back over new screen
  implode(t,l,b,r,tmp)
  inkey(0)
  set color to
  clear
  quit

* Function to implode a screen memory variable
* Parameters t   - Top row of screen image
*            l   - Left column of screen image
*            b   - Bottom row of screen image
*            r   - Right column of saved screen image
*            img - Screen memory Variable
*
  FUNCTION implode
   parameter t,l,b,r,img
   private t,l,b,r
   private num_rows, num_cols, x, y, ixstr, m_1, m_2, rest_str, img

   * calculate number of rows
     num_rows = (b-t) + 1

   * calculate number of cols
     num_cols = (r-l) + 1

   * Separate screen variable into rows
     for x = 1 to num_rows
         ixstr = ltrim(str(x))
         private row&ixstr.
         m_1 = ((2*num_cols) * (x-1)) + 1
         m_2 = (2*num_cols) * x
         row&ixstr. = substr(img,m_1,m_2)
     next

   * Set up screen restore variables and restore them
     for x = 1 to num_cols

       * get vertical image to restore
         rest_str = ''
         for y = 1 to num_rows
            iystr    = ltrim(str(y))
            rest_str = rest_str + substr(row&iystr.,(x*2)-1,2)
         next

       * calculate coordinates
         m_tr = t
         m_lc = (l+x) -1
         m_br = b
         m_rc = m_lc

       * Write screen protion to screen
         restscreen(m_tr,m_lc,m_br,m_rc,rest_str)

     next

  RETURN .T.