* Function: FILES
* Author..: Richard Low
* Syntax..: FILES( <expC> [, <expC> [, <expC> ... )
* Returns.: True if all the files listed as parameters exist.
* Assumes.: Filenames are character strings or character variables.
*           Will allow up to 9 filenames to check at once.

FUNCTION FILES
PARAMETERS p_1, p_2, p_3, p_4, p_5, p_6, p_7, p_8, p_9
PRIVATE f_pcount, f_x, f_parname

*-- see how many parameters were passed
f_pcount = PCOUNT()

*-- check each one
FOR f_x = 1 TO f_pcount
   *-- build a memvar of the parameter name
   f_parname = 'p_' + LTRIM(STR(f_x,3,0))

   *-- make sure it's character type, if not, bomb out
   IF .NOT. TYPE(f_parname) = 'C'
      RETURN (.F.)
   ENDIF

   *-- if any one of them does not exist, we return .F.
   IF .NOT. FILE(&f_parname)
      RETURN (.F.)
   ENDIF

NEXT f_x

*-- otherwise all files must be there
RETURN (.T.)
