* Function: CENTER
* Author..: Richard Low
* Syntax..: CENTER( [exp<N>,] exp<C> )
* Returns.: Column number to center <expC> on an 80 column monitor.
*           If <expN> is specified, it displays exp<C> centered on
*           row exp<N>.

FUNCTION CENTER
PARAMETERS p1, p2

DO CASE
   *-- if 1st parameter is character, no row number given
   CASE TYPE('p1') = 'C'
      *-- just return column to center, making sure its positive
      RETURN MAX( INT((80-LEN(p1))/2), 0 )

   *-- if 1st parm is numeric, and 2nd parm is character
   CASE TYPE('p1') = 'N' .AND. TYPE('p2') = 'C'
      *-- make sure it is in range 0 to 24
      IF p1 >= 0 .AND. p1 <= 24
         *-- say it on screen
         @ p1,(80-LEN(p2))/2 SAY p2
      ENDIF
      *-- and return value (make sure it is positive
      RETURN MAX( INT((80-LEN(p2))/2), 0 )

ENDCASE

*-- otherwise bad parms
RETURN (0)
