#include "inkey.ch"
#include "setcurs.ch"

MEMVAR SCInpStd, SCInpEnh, SCInpUnsel, lColorsChanged, ;
       SCBackground, SCDlgText, ;
       oMenuInterface, oMenuBuildHelp, oBarMenu, oMenuDateTime, ;
       oMenuBoxes, oMenuGauge, oMenuDbf, oMenuColors, oMenuMisc

function main()
local oScrnColors, lRedraw, oStatus, oBox
local lQuit
private lColorsChanged, ;
        oMenuInterface, oMenuBuildHelp, oBarMenu, oMenuDateTime, ;
        oMenuBoxes, oMenuGauge, oMenuDbf, oMenuColors, oMenuMisc
    lRedraw := .T.
    lQuit := .F.
    lColorsChanged := .F.

    QScrPush()
    setBlink(.F.)
    setCursor( SC_NONE )
    oScrnColors := qSysColors():new()
    if qIsColor()
       copy file colors.cfg to xcolors.cfg
       oScrnColors:setDefFile( "COLORS.CFG" ) //Set config file
    else
       copy file mono.cfg to xmono.cfg
       oScrnColors:setDefFile( "MONO.CFG" ) //Set config file
    endif
    oScrnColors:setColors()      //Get color defaults from config file
    oStatus := QStatus():new()
    setColor( SCInpStd+","+SCInpEnh+",,,"+SCInpUnsel )
    loadMenu()
    QBackDrop()
    headStone( @oStatus )
    WHILE ! lQuit
	   oBarMenu:exec( lRedraw )
       lRedraw := .F.
       lQuit := ( lastKey() == K_ESC )
       if lColorsChanged
           setColor( SCInpStd+","+SCInpEnh+",,,"+SCInpUnsel )
           oStatus:pop()
           QBackDrop()
           headStone( @oStatus )
           lQuit := .F.
           loadMenu()
           lRedraw := .T.
           lColorsChanged := .F.
       endif
    ENDDO
    QScrPop()

return Nil

function loadMenu()

    oMenuMisc := QPulldown():new( { ;
           {"Qa~MaxStrLen()", {||misc("qamaxstrlen")}, .T., "Find the length of the longest string in an array"}, ;
           {"Q~AtoS()", {||misc("qatos")}, .T., "Convert an array to a string"}, ;
           {"Q~StoA()", {||misc("qstoa")}, .T., "Parse a delimited string into an array"}, ;
           {"QB~lank()", {||misc("qblank")}, .T., "Return a blank value from any expression"}, ;
           {"Q~Dos()", {||misc("qdos")}, .T., "Shell to memory/disk and run a DOS program"}, ;
           {"arg~Uments", {||misc("arguments")}, .T., "Handle DOS command line arguments"}, ;
		   {"Q~ProgName", {||misc("progname")}, .T., "The name of the executing program"}, ;
		   {"~Toggle", {|o|misc("toggle", o:isChecked)}, .T., "The pulldown menu has toggle options", .T.} ;
           })

    oMenuGauge := QPulldown():new( { ;
          {"~Percent Gauge", {||_gauge()}, .T., "Gauge showing percent complete"}, ;
          {"~Rotating Dial", {||_dial()}, .T., "Rotating dial showing processing"}, ;
          {"~Indexing Status", {||_index()}, .T., "Index progression gauge"} ;
           })

    oMenuBoxes := QPulldown():new( { ;
          {"~Popup", {||_box()}, .T., "Popup box" },;
          {"~Messages", {||_msgbox()}, .T., "Popup boxed message" }, ;
          {"~Alert", {||_alert()}, .T., "Menued messages" }, ;
          {"~Questions", {||_question()}, .T., "Asking the user Yes/No questions" } ;
           })

    oMenuDbf := QPulldown():new( { ;
          {"~Browsing", {||_browse()}, .T., ;
                        "Variations of the same browse function"}, ;
          {"~Records", { ||misc( "records" ) }, .T., "Record maintenance"}, ;
          {"~Locking", { ||misc( "locking" ) }, .T., "Locking records/files"}, ;
          {"~Attributes", { ||misc( "database attributes" ) }, .T., "Save and restore database attributes"} ;
          } )

    oMenuColors := QPulldown():new( { ;
          {"~Setting", {||_colors( @lColorsChanged )}, .T., "Setting system colors"}, ;
          {"~Detecting", {||misc("qiscolor")}, .T., "Detecting whether or not to use color"}, ;
          {"Saving", {||misc("qcopush")}, .T., "Saving/restoring color settings"} ;
          } )


    oMenuInterface := QPulldown():new( { ;
          {"c~Olors", oMenuColors, .T., ;
                      "Managing system colors"},;
          {"bo~Xing", oMenuBoxes, .T., "Boxed display functions"},;
          {"~Gauges", oMenuGauge, .T., "Displaying progression gauges"}, ;
          {"~Picklist", {||_pick()}, .T., "Pick lists"}, ;
          {"~Memos/Files", {||_memo()}, .T., "Editing memos or files"}, ;
          {"Q~BackDrop()", {||misc( "backdrop") }, .T., "Creating a background screen"}, ;
          {"Q~Centre()",   {||misc( "centre" ) }, .T., "Centering text between two points" }, ;
          {"Q~InvColor()", {||misc( "invcolor" ) }, .T., "Swap foreground and background colors" }, ;
          {"Screens", {||misc("screens")}, .T., "Saving/restoring regions of the screen"}, ;
          {"QBigLetters", {||misc("bigletters")}, .T., "Display a message in BIG letters" } ;
          })

    oMenuDateTime := QPulldown():new( { ;
          {"Q~AlphaDate", {||_alphaDate()}, .T., "Displaying dates in a variety of formats" }, ;
          {"Q~Calendar", {||_qcal()}, .T., "Pop-up calendar" }, ;
          {"Q~StoD", {||misc("qstod")},.T., "String to date" }, ;
          {"Q~TimeDiff", {||misc("qtimediff")},.T., "Difference between two times" }, ;
          {"Q~StoT", {||misc("qstot")},.T., "Seconds to time" }, ;
          {"Q~TtoS", {||misc("qttos")},.T., "Time to seconds" } ;
          })

    oMenuBuildHelp := QPulldown():new( { ;
          {"~About", {||misc("about")}, .T., "About this program"}, ;
          {"~Building", {||_helpCreate()}, .T., "Building context sensitive help into your applications"} ;
          })

    oBarMenu := QBarMenu():new( { ;
          {"~Interface",   oMenuInterface, "User-interface functions"}, ;
          {"d~Atabase", oMenuDbf, "Database functions"}, ;
          {"~Date/Time",   oMenuDateTime, "Date/Time functions"}, ;
          {"~Misc", oMenuMisc, "Miscellaneous functions"}, ;
          {"~Help",   oMenuBuildHelp, "Building context sensitive help"} ;
          }, 01 )

return Nil

function headStone( oStatus )
   @ 7, 23, 14, 55 box space(9) color SCBackground
   QBigLetters( 8, 25, "QLIB", SCBackground )
   @ 12, 29 say "  Interface Library" color SCBackground
   @ 13, 29 say " Author: Leigh Morum" color SCBackground
   oStatus:push( "QwikFunction Library Ver 1.0                              Copyright (c) 1993")
return Nil

function misc( cTopic, xParam )
local oBox
   do case

      case cTopic == "arguments"
           QAlert( "Arguments", ;
                   "QLIB has a number of functions to handle dos command                ;" + ;
                   "line arguments. For example:                                        ;" + ;
                   "QISARGUMENT() Determine if a string was a command line argument     ;" + ;
                   "QARGCOUNT()   Determine how many command line arguments were passed ;" + ;
                   "QARGNO()      Determine the position of a command line argument     ;" + ;
                   "QARGSARRAY()  Return an array of command line arguments             ;" + ;
                   "QARGUMENT()   Determine the nth command line argument               " ;
                   ,,2 )


      case cTopic == "backdrop"
           QAlert( "QBackDrop()", ;
                   "Fills a region of the screen with a specified character ;" + ;
                   "in the specified color.                                 ;;" + ;
                   "If no parameters are supplied, then '' fills the entire;" + ;
                   "screen in the background color set by QSysColors().     ",,2 )

      case cTopic == "centre"
           QAlert( "QCentre()", ;
                   "This functions finds the column that would  ;" + ;
                   "centre a string given the string, an offset,;" + ;
                   "and the width of the centering region.      ",,2 )

      case cTopic == "invcolor"
           QAlert( "QInvColor()", ;
                   "Switches the foreground and background colors;" + ;
                   "For example, QInverse('W+/B') returns 'B/W*' ",,2 )

      case cTopic == "records"
           QAlert( "Records", ;
                   "The three functions QABlank, QAScatter and QAGather ;" + ;
                   "exist to aid record maintenance.  QABlank is used   ;" + ;
                   "for APPENDING records as it copies blank fields for ;" + ;
                   "the database into an array.  QAScatter is used for  ;" + ;
                   "EDITING records as it takes the data in a record and;" + ;
                   "stores that data into an array.                     ;;" + ;
                   "This makes it simple matter to edit memory variables;" + ;
                   "when appending or editing a record. After the user  ;" + ;
                   "has edited the variables, the user can still cancel ;" + ;
                   "the append or the changes since the database has    ;" + ;
                   "still not been affected by this stage.              ;;" + ;
                   "The QGather() function saves the array of data back ;"+ ;
                   "to the database file.                               ",,2)

      case cTopic == "locking"
           QAlert( "Locking", ;
                   "QLockRec() and QLockFile() functions let you lock ;" + ;
                   "records and databases exclusively with an optional;" + ;
                   "timeout.                                          ",,2)

      case cTopic == "database attributes"
           QAlert( "Database Attributes", ;
                   "The QPushDBF() and QPopDBF() functions let you push;" + ;
                   "and pop database attributes such as the work area, ;" + ;
                   "current record, index order, softseek status and   ;" + ;
                   "deleted status.                                    ;",,2)

      case cTopic == "qstod"
           QAlert( "QStoD()", ;
                   "Convert a string to a date.  You can use this;" + ;
                   "function to convert a string that was created;" + ;
                   "using the Clipper DtoS() function back into a;" + ;
                   "date.                                        ",,2)

      case cTopic == "qstot"
           QAlert( "QStoT()", ;
                   "Convert a number of seconds into a time. You;" + ;
                   "would typically use this function along with;" + ;
                   "QTtoS() when manipulating times.             ",,2)

      case cTopic == "qttos"
           QAlert( "QTtoS()", ;
                   "The opposite of QStoT.  Convert a time to a number   ;" + ;
                   "of seconds so that times can be added and subtracted ;" + ;
                   "from each other.                                     ",,2)

      case cTopic == "qtimediff"
           QAlert( "QTimeDiff()", ;
                   "Calculate the difference between two times in;" + ;
                   "HH:MM:SS format. This time can be converted  ;" + ;
                   "to number of seconds by applying the QTtoS() ;" + ;
                   "function to the difference.                  ",,2)

      case cTopic == "qiscolor"
           QAlert( "QIsColor()", ;
                   "This function lets your users force your application   ;" + ;
                   "to run in monochrome mode.  Useful for laptops, strange;" + ;
                   "video cards and grey scale monitors.                   ",,2)

      case cTopic == "qcopush"
           QAlert( "QCoPush()/QCoPop()", ;
                   "These functions are used to save (optionally set) and ;" + ;
                   "restore color settings.  You don't have to worry about;" + ;
                   "assigning the current color settings to a variable and;" + ;
                   "then settings them again using that variable.         ",,2)

      case cTopic == "qamaxstrlen"
           QAlert( "QAMaxStrLen()", ;
                   "This function finds the length of the longest element;" + ;
                   "in an array.  For example, you may want to calculate ;" + ;
                   "how wide to make an achoice() window                 ",,2)

      case cTopic == "qatos"
           QAlert( "QAtoS()", ;
                   "This function takes an array and converts it into a ;" + ;
                   "string delimited with a character.  For example, you;" + ;
                   "may want to display a message indicating which      ;" + ;
                   "records or array elements were tagged.              ",,2)

      case cTopic == "qstoa"
           QAlert( "QStoA()", ;
                   "This function takes a delimited string and parses;" + ;
                   "it into an array.  It is the opposite of the     ;" + ;
                   "QAtoS() function.                                ",,2)

      case cTopic == "qblank"
           QAlert( "QBlank()", ;
                   "This function returns the blank equivalent;" + ;
                   "of any expression. It is typically used to;" + ;
                   "initialize a variable with a field name   ;" + ;
                   "for editing purposes.                     ",,2)

      case cTopic == "screens"
           QAlert( "QScPush()/QScPop()", ;
                   "This function is used to save and restore;" + ;
                   "regions of the screen. Instead of saving ;" + ;
                   "regions of the screen to a variable using;" + ;
                   "the saveScreen() function, you just push ;" + ;
                   "and pop regions using these functions.   ",,2)

      case cTopic == "bigletters"
           oBox := QBox():new( 5, 14, 14, 64, ;
                "QBigLetters()", "", 2 ):on()
           @  9, 20 say "Display" color SCDlgText
           QBigLetters( 8, 28, "BIG", SCDlgText)
           @  9, 51 say "messages" color SCDlgText
           @ 12, QCentre( "Hit any key...." ) say "Hit any key...." color SCDlgText
           inkey(0)
           oBox:off()

      case cTopic == "about"
           QAlert( "About", ;
                   "QwikFunction Library Ver 1.0;;" + ;
                   "Author: Leigh Morum;;" + ;
                   "CIS ID 73052,1756" )

     case cTopic == "progname"
          QAlert( "QProgName()", ;
                  "This function returns the name of the executing program.;"+;
                  "You are now running "+QProgName(),,2)

     case cTopic == "qdos"
          QAlert( "QDOS()", ;
                 "This function uses the Blinker's SWPRUNCMD() function to;" + ;
                 "jump to DOS or to run another application.              ",,2 )
          if "UI" == type( "SWPRUNCMD()" )
			 if QAlert( "QDos() Demonstration", ;
                     "Since the SWPRUNCMD() function is currently;" + ;
                     "linked in, you can test this function now. ", + ;
                     { "Jump to DOS", "Skip it" } ) == 1
                QAlert( "QDos()", ;
                     "The function returned "+QDos(),,2 )

             endif
          endif

	  case cTopic == "toggle"
		   QAlert( "Toggle Status", "The toggle is now set to "+iif( xParam, "ON", "OFF" ),,2 )
      otherwise
           QAlert( "OOPS", "No description for this option",,2)
   endCase
return Nil
