*////////////[ Copyright (c) 1989 by Richard W. Rahn ]///////////////*
*                                                                    *
* DEMO.PRG                                                           *
* Purpose : To demonstrate the UDF PICKLIST()                        *
*                                                                    *
*  To use you need to compile this demonstration program and link    *
*  it with the p_list.obj file distributed with this demonstration.  *
*           (you need Clipper.lib and Extend.lib)                    *
*                                                                    *
*  i.e. CLIPPER demo                                                 *
*       PLINK86 FI demo,p_list LIB clipper,extend                    *
*                                                                    *
*  You may order the source code for PICKLIST() by sending           *
*  $3.00 (U.S. currency) to:                                         *
*                   RWR Data Solutions, Inc.                         *
*                   551 Roosevelt Rd. Ste #151                       *
*                   Glen Ellyn Il 60137                              *
*                                                                    *
* ///////////////////////////////////////////////////////////////////*

set color to gr+/n
status = 0
m_rec  = 0
x      = 0
clear

* Initial message
***************************************************************
  text

   PICKLIST()

   The function PICKLIST() is designed to allow a user to select one or more
   items from a list.

   The syntax for calling PICKLIST() is :

              var = PICKLIST(<ARRAY1>, @<ARRAY2>)

   Where:  ARRAY1 is an array of character type elements
             and
           ARRAY2 is a cooresponding array of logical values initialized 
                  to .F. (false)

   PICKLIST() will present the elements from ARRAY1 and allow the user to
   scroll through the list and tag/untag one or more elements. Tagged elements
   will have the cooresponding element in ARRAY2 set to .T..
   
   PICKLIST() will return the number of elements selected.

   Please read through the demonstration program for more detail.


   Press any key to continue...

  endtext
  inkey(0)


* Load an array with items to be selected
***************************************************
  use states
  m_rec = reccount()

  private ar1[m_rec],ar2[m_rec]
  afill(ar2,.F.)

  for x = 1 to m_rec
      ar1[x] = st_abbrev + '  ' + st_name + '  ' + st_capital
      skip
  next
  use


* Demonstration loop
***************************************************

  do while .T.

      * Call PICKLIST() to allow multiple selection
      * First some notes on PICKLIST()

        * 1) PICKLIST() performs the following validation on the arrays passed
        *      a-> They must be arrays
        *           If not, a -1 is returned
        *
        *      b-> They must have the same length (number of elements)
        *           If not, a -2 is returned
        *
        *      c-> All elements in array 1 must be character
        *           If not, a -3 is returned
        *
        *      d-> All elements in array 2 must be logical
        *           If not, a -4 is returned
        *
        *
        * 2) PICKLIST() will initialize all elements in array 2 to .F.
        *
        * 3) Make sure that you pass ARRAY2 by reference (i.e. Preceded by
        *    the '@' sign @array2 )
        *
        * OK now call PICKLIST(). Remember that a numeric value is returned
        * indicating the number of elements chosen from array1.

        status = picklist(ar1,@ar2)

        set color to
        clear

      * This is where you would evaluate the selected items.
      * Notice that I reference array2 to determine if the cooresponding
      * element from array1 was chosen.

        if status > 0

           * One or more items selected.
              for x = 1 to m_rec
                  if ar2[x]
                      ? ar1[x]
                  endif
              next
              ?
              ? '*** ' + ltrim(str(status)) + ' Items Selected'
              ?

        else

           * No items selected. User returned without selection or hit ESCAPE
           * or error in arrays passed to PICKLIST().
             ? 'No selections made. ('+ ltrim(str(status)) + ')'

        endif

        wait 'Press any key to select again. ESC to quit.'
        if lastkey() == 27
           exit
        endif


  enddo


* Parting message
************************************************************************
  set color to
  clear
  text


    You may receive your complete copy of the source code for PICKLIST(),
    'A Clipper List Selection Routine' by sending $3.00 (U.S. currency) to:

                         RWR Data Solutions, Inc.
                         551 Roosevelt Rd. Ste #151
                         Glen Ellyn Il 60137
                         (708) 858-8544

                  Comments and suggestions welcome !


  endtext


*** END OF DEMO.PRG
