;------------------------------------------------------------------------------
; Filename: PRCHECK.ASM
; Program.: Clipper Extended Library
; Authors.: Charles Yeo
; Date....: February 17, 1991
; Syntax..: ISREADY(lptn) := True if parallel printer n is online and ready.
;         : PSTAT(lptn)   := parallel printer status
;         : lptn must be in range of 1 to 3
;         : Status bits   7 - NOT busy          *
;                         6 - Acknowledge
;                         5 - Out of Paper
;                         4 - Selected          *
;                         3 - I/O error
;                         2 - unused
;                         1 - No port
;                         0 - Timeout
;                                               * needed for ready
;         : Return Status 0 - Ready
;                         1 - Offline
;                         2 - Out of Paper
;                         3 - Disconnected
;                         4 - Unknown or Combination error
;
;                         5 - Illegal Port
;                         6 - Port not Numeric
;                         7 - Incorrect number of parameters
;


   NAME   PRCHECK

;

   PUBLIC ISREADY
   PUBLIC PSTAT

; Clipper fetch and return value calls
;   EXTRN   __PARNI:FAR    ; get an integer from Clipper
;   EXTRN   __RETL:FAR     ; return logical true or false
;   EXTRN   __RETNI:FAR    ; return an integer to Clipper
;   EXTRN   __PARINFO:FAR  ; check parameters passed

INCLUDE extasm.inc
; defines external calls and data type values for parinfo

_PROG SEGMENT

         ASSUME CS:_PROG

ISREADY PROC FAR

         PUSH BP                 ; preserve return address
         MOV  BP, SP
         PUSH DS                 ; save registers
         PUSH SI
         PUSH DI

         MOV  AX, 0              ; check for parameter count
         PUSH AX
         CALL __PARINFO          ; parameter count in AX
         ADD  SP, 2
         CMP  AX, 1
         JNE  NOTREADY

         MOV AX, 1               ; check parameter type
         PUSH AX
         CALL __PARINFO          ; parameter type in AX
         ADD SP, 2
         CMP AX, NUMERIC         ; is it numeric
         JNE NOTREADY
        
         MOV  AX, 1              ; get port number from Clipper
         PUSH AX
         CALL __PARNI
         ADD  SP, 2
   
         CMP  AX, 0              ; is it a legal value
         JLE  NOTREADY
         CMP  AX, 4
         JAE  NOTREADY

         DEC  AX                 ; make lpt1 = 0, lpt2 = 1, lpt3 = 2
         MOV  DX, AX             ; function requires Printer number in DX
         MOV  AH, 2H             ; printer status function
         INT  17H                ; read printer status

         MOV  BX,1               ; true
         CMP  AH,90H             ; not busy or selected (90h = 10010000)
         JE   RET_STATE          ; return false if other than above

NOTREADY:
         XOR  BX,BX              ; false

RET_STATE:
         PUSH BX                 ; put return value on the stack
         CALL __RETL             ; return logical value to Clipper
         POP  BX                 ; restore the stack

         POP  DI                 ; restore all Clipper registers
         POP  SI
         POP  DS
         POP  BP

         RET

ISREADY  ENDP


;


PSTAT    PROC FAR

         PUSH BP                 ; preserve return address
         MOV  BP, SP
         PUSH DS                 ; save registers
         PUSH SI
         PUSH DI

         MOV  AX, 0              ; check for parameter count
         PUSH AX
         CALL __PARINFO          ; parameter count in AX
         ADD  SP, 2
         CMP  AX, 1
         JNE  TOOMANYPARAMETERS

         MOV AX, 1               ; check parameter type
         PUSH AX
         CALL __PARINFO          ; parameter type in AX
         ADD SP, 2
         CMP AX, NUMERIC         ; is it numeric
         JNE BADPARAMETER
        
         MOV  AX, 1              ; get port number from Clipper
         PUSH AX
         CALL __PARNI
         ADD  SP, 2
   
         CMP  AX, 0              ; is it a legal value
         JLE  BADPORT
         CMP  AX, 4
         JAE  BADPORT

         DEC  AX                 ; make lpt1 = 0, lpt2 = 1, lpt3 = 2
         MOV  DX, AX             ; function needs Printer number in DX
         MOV  AH, 2H             ; printer status function
         INT  17H                ; read printer status, status in AH

         CMP  AH, 90H            ; not busy or selected (90h = 10010000)
         JZ   READY

         CMP  AH, 0H             ; off line (0h = 00000000)
         JZ   OFFLINE

         CMP  AH, 28H            ; out of paper (28h = 00101000)
         JZ   OUTOFPAPER

         CMP  AH, 0B0H           ; disconnected (0Bh = 10110000)
         JZ   DISCONNECTED

         JMP  UNKNOWN

TOOMANYPARAMETERS:
         MOV  AX, 07H
         JMP RET_BYTE

BADPARAMETER:
         MOV  AX, 06H
         JMP RET_BYTE

BADPORT:
         MOV  AX, 05H
         JMP RET_BYTE

UNKNOWN:
         MOV  AX, 04H
         JMP RET_BYTE

DISCONNECTED:
         MOV  AX, 03H
         JMP RET_BYTE

OUTOFPAPER:
         MOV  AX, 02H
         JMP RET_BYTE

OFFLINE:
         MOV  AX, 01H
         JMP RET_BYTE

READY:
         MOV  AX, 0H

RET_BYTE:
         PUSH AX                 ; put return value on the stack
         CALL __RETNI            ; return logical value to Clipper
         POP  BX                 ; restore the stack

         POP  DI                 ; restore all Clipper registers
         POP  SI
         POP  DS
         POP  BP

         RET

PSTAT    ENDP



_PROG    ENDS

         END

; EOF PRCHECK.asm -------------------------------------------------------------

