SET TALK OFF
PUBLIC CLIPPER
CLEAR
TEXT
            ---    This is a demo of PROPER.BIN & OBJ    ---
 
This is a short demo of the PROPER BIN (OBJ) program. PROPER can be
called from FoxBASE+, Clipper, Quicksilver, or dBASE III PLUS. (It's
a little redundant for Quicksilver since it emulates the Quicksilver
PROPER() function, except that it makes your code a bit more portable).

PROPER capitalizes the first character of each word in a string of
characters (the string cannot be a field variable, only a memvar).

It will capitalize only a letter that follows either a space or a
non-alphanumeric character. I plan to add some enhancements, such
as skipping over words like "a," "an," and "the" (except for the
first word), and also special handling for "McAnything" etc.

LINK the OBJ code to your Clipper application. LOAD PROPER.BIN from dBASE
or FoxBASE. With Quicksilver--either CCALL PROPER and link it in (there goes
the portability) or LOAD the BIN routine just as from dBASE. Since dBASE
III PLUS doesn't support UDFs, for portability reasons the calling syntax
is exactly the same from any of these environments: CALL Proper WITH <memvar>.

ENDTEXT

string=spac(254)
@ 22,1 SAY 'String to make "proper":' GET string PICTURE "@S40"
READ
string=TRIM(RTRIM(LOWER(string)))

* DO PROPER WITH string       && uncomment this line for benchmarking
                              && against native dBASE code
IF .NOT. CLIPPER
*\ LOAD PROPER
ENDIF

*\ IF .T.
*\ CCALL PROPER WITH string
*\ ELSE
CALL PROPER WITH string       && comment out this line for benchmark
*\ ENDIF

@ 23,0 SAY "PROPER returns: " + string
WAIT
CLEAR
RETURN
