* PROPER.PRG -- Capitalize first letter of words in a string

parameter source_str

digits="0123456789"
inword="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"

sourclen = LEN(source_str)  && get length of source string
thispos  = 1                && start at first character in source_str
sepflag  = .T.            && first character is "after separator"

DO WHILE thispos <= sourclen                  && for each position
     thischar=SUBSTR(source_str,thispos,1)    && isolate character
     IF thischar$inword .AND. sepflag         && if new "word"
                                              && and alphanumeric
        sepflag = .f.                         && next char not new word


        * LEFT function in EXTENDDB.
        source_str = IIF(thispos=1,'',LEFT(source_str,thispos-1))+;
                     UPPER(thischar)+;
                     SUBSTR(source_str,thispos+1)
                                          && capitalize letter
      ELSE
          IF .NOT. thischar$inword        && if this char not
                                          && alphanumeric
                sepflag = .t.             && next is new word
          ENDIF
    ENDIF
    thispos = thispos + 1                 && goto next position
ENDDO

RETURN


  * Clipper LEFT() function, similar to LEFT() in EXTENDDB.PRG.
  FUNCTION left

  PARAMETERS lstring, llen
  RETURN SUBSTR(lstring, 1, llen)

