*:*********************************************************************
*:
*:        Program: PROGPH.PRG
*:
*:         System: PROGPH - Index grapher
*:         Author: Phil Steele with mods by Barry Vinson
*:
*:  Procs & Fncts: BAR()
*:
*:          Calls: BAR()          (function  in PROGPH.PRG)
*:
*:           Uses: (DBFNAME).DBF  
*:
*:        Indexes: &NTXNAME
*:
*:      Documented 04/21/89 at 22:53                SNAP!  version 3.12f
*:*********************************************************************
* The routines used to generate the graph and graph box were
* taken verbatim from page 19 of "64 Clipper user defined functions"
* by Philip Steele.  The program was modified to take the names
* of the database and index files as well as the index descriptions
* as parameters.  Many thanks to Mr. Steele for allowing me to
* use his work.
**********************************************************************
* SET CURSOR OFF                         && Ŀ
* GRAPH = ? (1 if you want to show graph &&  Set up by the calling
* any other number if you want to "hide" &&   program
* the graph i.e. PACK or REINDEX.        && 

* FUNCTION PROGPH && add this line if you want to use this as
*                    a function
PARAMETERS dbfname,ntxdef,ntxname
*                         
*                         -INDEX FILE NAME
*                   
*                   INDEX FIELD OR INDEX DEFINITION
*             
*             THE NAME OF THE DATABASE FILE

@ 12,(80/2 - LEN("I N D E X I N G")/2) SAY "I N D E X I N G"
@ 13,(80/2 - LEN(CHR(25))/2) SAY CHR(25)
DO BV_cntr WITH 14, dbfname + ".dbf","H"
@ 18,10 TO 23,69 DOUBLE
@ 21,11 TO 21,68 DOUBLE
@ 21,10 SAY ""
@ 21,69 SAY " "
@ 19,24 SAY "P E R C E N T   C O M P L E T E"
@ 20,14 SAY "0   10   20   30   40   50"
@ 20,43 SAY "60   70   80   90   100"

USE (dbfname)                && the database file to use

INDEX ON bar(&ntxdef.) TO &ntxname.

RETURN                       && to the calling program
* be sure to add ('') for a return value if used as a function

*!*********************************************************************
*!
*!       Function: BAR()
*!
*!      Called by: PROGPH.PRG                    
*!
*!*********************************************************************
FUNCTION bar                  && draws the progress bar

PARAMETERS ifield
PRIVATE    ifield,tot
tot = RECCOUNT()

IF RECNO()  < tot + 1
   pct = RECNO() * 100 / tot
   IF graph = 1
      @ 22,14 SAY REPLICATE("",(pct/2)+1) && draw the bar
      IF pct >=100                
         @ 22, 14 CLEAR TO 22,68  
      ENDIF                       
   ELSE
      @ 22,14 SAY REPLICATE(" ",(pct/2)+1) && don't draw the bar
   ENDIF
ENDIF

RETURN(ifield)

*: EOF: PROGPH.PRG
