*:*********************************************************************
*:
*:        Program: BV_CNTR.PRG
*:
*:         Author: Barry Vinson
*:  Last modified: 04/23/89     19:13
*:
*:      Documented 04/23/89 at 19:14                SNAP!  version 3.12f
*:*********************************************************************
* Calling syntax for a seperate .prg file 
* DO BV_Cntr WITH 14,"MESSAGE","H"  will center and highlight message 
* on line 14
* DO BV_Cntr WITH 14,"MESSAGE","" will center message on line 14 with
* no highlight
*
* Calling syntax for BV_Cntr used as a FUNCTION
* BV_Cntr(14,"MESSAGE","H") centered and highlighted
* BV_Cntr(14,"MESSAGE","")  no highlight
* FUNCTION BV_Cntr && Use this line if you want to use this file
*                     as a FUNCTION
PARAMETERS Line,message,highlight

* line = the screen row for the message
* message = the message to be presented
* highlight = includes letter H if highlighting is desired

* Insure that the letters in the feature parameter are all
* upper case

highlight = UPPER(highlight)

* Clear the message line
@ Line,0

* Check for highlight
IF "H"  $ highlight
   @ Line,39 - LEN(message)/2 GET message
   CLEAR GETS
ELSE && does not want highlight
   @ Line,39 - LEN(message)/2 SAY message
ENDIF wants highlight

RETURN && ('') Use this as a return value if you use
*         this file as a FUNCTION 
* EOF: BV_CNTR.PRG
