;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; File:    PROGNAME.ASM
;; Author:  Patrick T. Hurley
;; Date:    03-09-91 04:06am
;; Version: 1.0
;;
;; Notes:   A little goodie which will grab the name
;;          and path from which a clipper program was run.
;;
;; Input:   None
;;
;; Output:  a string containing the fname and path
;;          or a NIL if an error occured
;;

                INCLUDE CLIPPER.MAC

PUBLIC          PROGNAME

EXTRN           __ret:far
EXTRN           __retc:far
EXTRN           __xalloc:far
EXTRN           __xfree:far

DGROUP          GROUP   ASMDATA

ASMDATA         SEGMENT PUBLIC  'DATA'
        ; No Data Needed, but I need to find this segment
ASMDATA         ENDS


ASMCODE         SEGMENT 'CODE'
                ASSUME cs:ASMCODE, ds:nothing

CLIPPROC        PROGNAME

                ; Check DOS version >= 3.0

                DO_DOS  30h                     ; Get DOS version
                cmp     al, 3                   ; DOS version 3.0 or later?
                jb      @@OLD_DOS               ;  < 3.0 return a NULL

                ; find PSP

                DO_DOS  51h                     ; Undocumented (but reliable for now)
                mov     es,bx                   ; ES -> PSP

                ; Search for the end of environment strings

                mov     dx,word ptr es:[2Ch]    ; DX -> seg of envrmnt block
                mov     es,dx                   ; ES -> seg of envrmnt block
                xor     di,di                   ; ES:DI -> 1st char in env blck
                xor     al,al                   ; AL -> NULL
                mov     cx,-1
chk_4_2null:    repne   scasb                   ; search for a NULL
                cmp     byte ptr es:[di],0      ; is it a double NULL?
                jne     chk_4_2null             ;  No?, then keep looking
                add     di,3                    ; ES:DI -> prog name

                ; Is this name valid (is it within the memory block?)

                dec     bx
                mov     ds,bx                   ; DS -> MCB for specified block
                mov     ax,ds:03h               ; AX -> size of block in segs

                mov     cl,4
                shl     ax,cl                   ; AX -> env block size in bytes
                sub     ax,di                   ; beyond end of environment block?
                jc      @@BAD_NAME              ;  Yes, then abort right now
                xchg    ax,cx                   ; CX -> remainder of bytes in block
                mov     bx,di                   ; BX -> offset to beginning of prog name
                xor     al,al                   ; AL -> NULL
                repne   scasb                   ; does prog name end in env block?
                jne     @@BAD_NAME              ;  No, then we have garbage...

                ; Prepare to move program name into temporary buffer

                xchg    bx,di                   ; DI -> offs to prog name start, BX= end
                sub     bx,di                   ; get string length
                mov     cx,bx                   ; CX -> prog name string length
                push    ES
                push    CX                      ; save segment and length (DI is safe)

                ; Get some temporary memory from clipper

                inc     cx                      ; CX still holds the buff length
                SET_DS
                XALLOC  cx

                ; Check to see that DX:AX != NULL

                or      dx, dx
                jnz     @@GOOD_BUFF
                or      ax, ax
                jz      @@NO_MEMORY

                ; set up for the copy

@@GOOD_BUFF:    mov     es, dx
                mov     si, ax
                xchg    di, si
                pop     cx
                pop     ds

                ; save start of memory for later use (x2)
                push    dx
                push    ax
                push    dx
                push    ax

                rep     movsb                   ; Copy the buffer to ES:DI from DS:SI

                SET_DS
                call    __retc
                add     sp, 4                   ; I do not trust clipper to keep safe

                ; DS should be safe from last call
                call    __xfree                 ; give clipper back its memory
                add     sp, 4

                jmp     @@EXIT

                ; Something went wrong return a NIL
@@OLD_DOS:
@@BAD_NAME:
@@NO_MEMORY:
                SET_DS
                call    __ret

@@EXIT:

CLIPEND         PROGNAME

ASMCODE         ENDS                            ; End of code segment
                END


