SET DELETED ON
USE (m.FileName) ALIAS Project IN 1
SELECT Project
INDEX ON SUBSTR(name,1,100) TO Prodoc

USE (m.FileName) INDEX Prodoc AGAIN ;
	ALIAS Screens IN 2

m.Indent = 7

=WriteSection( "Z", "APPLICATIONS:" )

=WriteSection( "D", "DATABASES:" )

=WriteSection( "F", "FORMATS:" )
   	
=WriteSection( "x", "FILES:" )

=WriteSection( "I", "INDEXES:" )

=WriteSection( "B", "LABELS:" )

=WriteSection( "L", "LIBRARIES:" )
	   	
=WriteSection( "M", "MENUS:" )

=WriteSection( "P", "PROGRAMS:" )
	
=WriteSection( "Q", "QUERIES:" )

=WriteSection( "R", "REPORTS:" )

DO WriteSet

IF m.LineNumber <> 1
	=SS_NewPage()
ENDIF

USE IN Project
USE IN Screens

************************ End of Main Body *******************

FUNCTION WriteSection
*********************
PARAMETERS TypeString, TextString

SET FILTER TO Type = m.TypeString
GO TOP
IF NOT EOF()
	m.DrawLength = LEN( m.TextString ) + LEN( m.FileName ) + 1
	\
	\<<REPL( "*", m.DrawLength )>>
	\<<m.FileName + " " + m.TextString>>
	\<<REPL( "*", m.DrawLength )>>

	IF m.Postscript

		IF m.LineNumber > m.PageLength - 4
			=SS_NewPage()
		ELSE
			IF m.LineNumber <> 1 
				=SS_Say( " " )
			ENDIF
		ENDIF
		
		=SS_FontBold()
					
		=SS_Say( m.TextString )
	
		=SS_FontNorm()
	
	ENDIF

	SET ORDER TO Prodoc				
	SCAN 
   		DO WriteFile
	ENDSCAN
ENDIF


FUNCTION WriteFile
******************
m.Text = IIF( MainProg,"(Main) ", SPACE( m.Indent ) ) + ;
		 PADR( TRIM( Name ), 15 ) + ;
		 IIF( Exclude, "(Exclude) ", " " ) + ;
		 IIF( Arranged, "(Arranged)", "" ) 

\<<m.Text>>
IF m.Postscript
	=SS_Say( m.Text )
	
	IF m.LineNumber > m.PageLength
		=SS_NewPage()
	ENDIF		
ENDIF


FUNCTION WriteSet
********************
SET FILTER TO Type = "S"

GO TOP
IF EOF()
	RETURN
ENDIF

m.Text = M.FileName + " " + "SCREEN SETS:"
\
\<<REPL( "*", LEN( m.Text ) )>>
\<<m.Text>>
\<<REPL( "*", LEN( m.Text ) )>>

IF m.Postscript 

	IF m.LineNumber > m.PageLength - 8
		=SS_NewPage()
	ELSE
		=SS_Say( " " )
	ENDIF

	=SS_FontBold()

	=SS_Say( m.Text )
	
	=SS_FontNorm()
	
ENDIF

m.FirstSet = .T.
DO WHILE NOT EOF()

	IF m.FirstSet
		m.FirstSet = .F.
	ELSE
	
		\
		IF m.Postscript
			IF m.LineNumber > m.PageLength - 7
				=SS_NewPage()
			ELSE
				=SS_Say( " " )
			ENDIF
		ENDIF
	ENDIF
	
	DO WriteFile
	
	DO WriteSetProp

	DO WriteScreen
	
	SKIP
	
ENDDO


FUNCTION WriteSetProp
*********************
m.Indent = m.Indent + 3
m.Text1 = SPACE( m.Indent ) + Check( OpenFiles, "Open Files     " ) + ;
		Check( CloseFiles, "Close Files " ) 
m.Text2 = SPACE( m.Indent ) + 	Check( DefWinds, "Define Windows " ) + ;
		Check( RelWinds, "Release Windows" ) 

m.Text3 = SPACE( m.Indent ) + "READ " + Check( ReadCycle, "Cycle " ) + ;
		Check( MultReads, "Multiple " ) + ;
		Check( NoLock, "NOLOCK " ) + ;
		Check( Modal, "MODAL" ) 

m.Text4 = IIF( EMPTY( AssocWinds ), "", ;
			SPACE( m.Indent ) + "READ WITH " +WindList() )
m.Indent = m.Indent - 3

\<<m.Text1>>
\<<m.Text2>>
\<<m.Text3>>
IF NOT EMPTY( m.Text4 )
	\<<m.Text4>>
ENDIF

IF m.Postscript
	=SS_Say( m.Text1 )
	=SS_Say( m.Text2 )
	=SS_Say( m.Text3 )	
	IF NOT EMPTY( m.Text4 )
		=SS_Say( m.Text4 )
	ENDIF

ENDIF

FUNCTION WindList
*****************
PRIVATE ALL

m.MemoCount = MEMLINES( AssocWinds )

m.List = MLINE( AssocWinds, 1 )

IF M.MemoCount > 1 

	FOR i = 2 TO M.MemoCount

		m.Line = TRIM( MLINE( AssocWinds, i ) )
		IF NOT EMPTY( m.Line )
			m.List = m.List + ", " + m.Line
		ENDIF
	NEXT
ENDIF

RETURN m.List


FUNCTION WriteScreen
********************
SELECT Screens

SET FILTER TO Screens.Type = "s"
LOCATE FOR Project.SetId = Screens.SetId

DO WHILE NOT EOF()
	DO WriteFile
	CONTINUE
ENDDO	 

SELECT Project

FUNCTION Check
********************
PARAMETERS Logical, String

RETURN "[" + IIF( Logical, "X", " " ) + "] " + m.String