SELECT SELECT( 1 )
USE ( m.FileName ) ALIAS Screen 

IF EMPTY( DBF() )
	WAIT "Unable to open " + m.FileName WINDOW
	\
	\******  UNABLE TO OPEN <<m.FileName>> ******
	\
	RETURN
ENDIF

SET MEMOWIDTH TO 80
LOCATE FOR ObjType = 1
DO WriteWindow
	
=WriteClause( "Comment", m.FileName + " Comment", 1 )
=WriteClause( "SetupCode", m.FileName + " Setup", SetupType )
=WriteClause( "When", m.FileName + " When", WhenType )
=WriteClause( "Activate", m.FileName + " Activate", ActivType )
=WriteClause( "Show", m.FileName + " Show", ShowType )
=WriteClause( "Deactivate", m.FileName + " Deactivate", DeactType )
=WriteClause( "Valid", m.FileName + " Valid", ValidType )
=WriteClause( "Proccode", m.FileName + " Cleanup", ProcType )


=AFIELDS( NewStruc )
m.NewRow = ALEN( NewStruc, 1 ) + 1
DIMENSION NewStruc[ m.NewRow, 4 ]
NewStruc[ m.NewRow, 1 ] = "CharName"
NewStruc[ m.NewRow, 2 ] = "C"
NewStruc[ m.NewRow, 3 ] = 100
NewStruc[ m.NewRow, 4 ] = 0
SELECT Screen

USE

CREATE TABLE Prodoc FROM ARRAY NewStruc

APPEND FROM (m.FileName ) FOR NOT EMPTY( Name )
REPLACE ALL CharName WITH Name


INDEX ON CharName TO Prodoc

GO TOP
SCAN FOR ObjType >= 11
	DO WriteObject 
ENDSCAN

USE 

IF m.PostScript AND m.LineNumber > 1
	=SS_NewPage()
ENDIF

****************************************************
PROCEDURE WriteWindow
****************************************************

DECLARE WindowProp[ 4 ]

IF Center

	WindowProp[ 1 ] = "Centered - Height: " + Lstr( Height ) ;
		+ " Width: " + Lstr( Width ) 
ELSE

	WindowProp[ 1 ] = "FROM " + Lstr( VPOS ) + "," ;
		+ Lstr( Hpos ) + " TO " + Lstr( Vpos + Height - 1 ) ;
		+ "," + Lstr( Hpos + Width - 1 ) 
ENDIF

IF NOT EMPTY( Name )

	WindowProp[ 1 ] = WindowProp[ 1 ] + " Window Name: " ;
		+ UPPER( Name  )
		
ENDIF
	
m.PropCount = 1

IF NOT EMPTY( Tag )
	m.PropCount = m.PropCount + 1
	
	WindowProp[ m.PropCount ] = "TITLE " + Tag 
ENDIF

IF NOT EMPTY( Tag2 )
	m.PropCount = m.PropCount + 1
	
	WindowProp[ m.PropCount ] = "FOOTER " + Tag2 
ENDIF

IF Close OR Float OR Minimize OR Shadow OR Border <> 1

	m.PropCount = m.PropCount + 1
	
	WindowProp[ m.PropCount ] = IIF( Close, "CLOSE ", "" ) ;
		+ IIF( Float, "FLOAT ", "" ) ;
		+ IIF( Minimize, "MINIMIZE ", "" ) ;
		+ IIF( Shadow, "SHADOW ", "" )
	
	DO CASE
		CASE Border = 0
			m.BString = "NONE"
		CASE Border = 1
			m.BString = ""
		
		CASE Border = 2
			m.BString = "DOUBLE"
		CASE Border = 3
			m.BString =  "PANEL"
		CASE Border = 4
			m.BString =  "SYSTEM"
	ENDCASE		

	WindowProp[ m.PropCount ] = WindowProp[ m.PropCount ] + BString

ENDIF

\<<m.FileName>> Window definition
\<<REPL( "*", 40 )>>

IF m.Postscript
	=SS_FontBold()
		
	=SS_Say( m.FileName + " Window Definition" )
	
	=SS_FontNorm()
		
ENDIF

FOR i = 1 TO m.PropCount
	\<<WindowProp[ i ]>>
	
	IF m.Postscript
		=SS_Say( windowprop[ i ] )
	ENDIF
	
NEXT

**********************************************************	
FUNCTION WriteClause
**********************************************************

PARAMETERS Memo, Title, ProcType 	

IF EMPTY( &Memo )
	RETURN
ENDIF

\
\<<REPL( "*", 40 )>>
\*** <<m.Title>> <<IIF( m.ProcType = 0, "(Expression)", "")>> 	
\<<REPL( "*", 40 )>>

IF m.Postscript
	IF m.LineNumber > m.PageLength - 6
		=SS_NewPage()
	ELSE
		=SS_Say( " " )
		
	ENDIF

	=SS_FontBold()

	m.ClauseTitle = m.Title + IIF( m.ProcType = 0, " (Expression) ", "") 	

	=SS_Say( m.ClauseTitle )	

	=SS_FontNorm()
ENDIF

_mline = 0
m.Counter = 1
m.MLineTotal = MEMLINES( &Memo )
DO WHILE m.Counter <= m.MLineTotal 

	Text = MLINE( &Memo, 1, _MLINE )
	\<<Text>>	
	m.Counter = m.Counter + 1

	IF m.Postscript 
	
		=SS_SAY( m.Text )
		
		IF m.LineNumber > m.PageLength 
		
			=SS_NewPage()

		ENDIF
	
	ENDIF
	
ENDDO

*****************************************************		
FUNCTION WriteObject

IF ObjectString() = "Say Field"
	RETURN
ENDIF


DECLARE ObjectProp[ 4 ]
=Afill( @ObjectProp, " " )
m.PropCount = 0

m.ObjTitle = "@ " + Lstr( Vpos ) + "," +  Lstr( Hpos ) ;
	+ " " + UPPER( Name ) + " (" + ObjectString( ) + ")" ;
	+ IIF( Disabled, "  DISABLED", "" )
	
\
\<<REPL( "*", 60 )>>
\<<m.ObjTitle>> 
\<<REPL( "*", 60 )>>

IF !EMPTY( Picture )
	m.PropCount = m.PropCount + 1
	ObjectProp[ m.PropCount ] = "PICTURE " 

	IF LEN( TRIM( Picture ) ) <= m.LineLength - LEN( ObjectProp[ 1 ] )
		ObjectProp[ m.PropCount ] = ObjectProp[ m.PropCount ] + TRIM( Picture )
	ELSE
		m.BreakPoint = m.Linelength - LEN( ObjectProp[ m.PropCount ] )
		ObjectProp[ m.PropCount ] = ObjectProp[ m.PropCount ] + ;
			SUBSTR( Picture, 1, m.BreakPoint )
		m.PropCount = m.PropCount + 1
		ObjectProp[ m.PropCount ] = SUBSTR( Picture, m.BreakPoint + 1 )

	ENDIF
			 
ENDIF

m.Part1 = "SIZE " + Lstr( Height ) + "," + Lstr( Width ) + " "

DO CASE
	CASE ObjectString() = "Checkbox"
	
	m.Part2 = "DEFAULT " + Lstr( Initialnum ) + ;
			" Spacing: " + LSTR( Spacing )

	CASE ObjectString() = "Get Field" OR ObjectString() = "Edit Region"

		IF EMPTY( InitialVal )
			DO CASE
				CASE FillChar = "D"
					m.Default = "{  /  /  }"
				CASE FillChar = "C" OR FillChar = "M"
					m.Default = '" "'
				CASE FillChar = "L"
					m.Default = ".F."
				CASE FillChar = "N"
					m.Default = "0"
				CASE FillChar = "F"
					m.Default = "0.00"
			ENDCASE
		ELSE
			m.Default = InitialVal
		ENDIF

		m.Part2 = "DEFAULT " + m.Default
		
		IF ObjectString() = "Edit Region"
		
			m.Part2 = m.Part2 + "  Length: " + Lstr( InitialNum ) + ;
				"  Scroll: " + IIF( Scrollbar, ".T.", ".F." ) + ;
				"  Tab: " + IIF( Tab, ".T.", ".F." )
		ENDIF
			
	CASE ObjectString() = "Invisible Button"
		m.Part2 = "DEFAULT 0" + " Spacing: " + LSTR( Spacing )

	
	CASE ObjectString() = "List Box"
	
		DO CASE
			
			* From Array
			CASE Style = 0
			m.Part2 = "FROM " + Expr + " DEFAULT 1" 
			
			* From Popup	
			CASE Style = 1
			m.Part2 = "POPUP " + IIF( EMPTY( Expr ), "", Expr + " " ) ;
			+ 'DEFAULT " "'

			CASE Style = 2
			m.Part2 = "PROMPT STRUCTURE " + 'DEFAULT " "'
				
			CASE Style = 3
			m.Part2 = "PROMPT FIELD " + ALLTRIM(Expr) + ' DEFAULT " "'
		
			CASE Style = 4
			m.Part2 = "PROMPT FILES " + ;
				IIF( EMPTY( Expr ), "", "ALL LIKE " + Expr + " ") + ;				
				'DEFAULT " "'

		ENDCASE

		
	CASE ObjectString() = "Popup"
		IF ObjCode = 1
			* Prompt list		
			m.Part2 = "DEFAULT " + ;
				IIF( EMPTY( Initialval ), '" "', Initialval ) 	
							
		ELSE
			* From array
			m.Part2 = "FROM " + Expr + " DEFAULT 1" 
			
		ENDIF
					
	CASE ObjectString() = "Push Button"
			m.Part2 = "DEFAULT " + Lstr( Initialnum ) + ;
				" Spacing: " + LSTR( Spacing )

	
	CASE ObjectString() = "Radio Button"
			m.Part2 = "DEFAULT " + Lstr( Initialnum ) + ;
				"  Spacing: " + LSTR( Spacing )
	
ENDCASE

m.PropCount = m.PropCount + 1
ObjectProp[ m.PropCount ] = m.Part1 + m.Part2

IF m.Postscript
	IF m.LineNumber + m.PropCount  > m.PageLength 
			
		=SS_NewPage()

	ELSE
		=SS_Say( " " )
		
	ENDIF
	
	=SS_FontBold()
	=SS_Say( m.ObjTitle )		
	=SS_FontNorm()
	
ENDIF
FOR i = 1 TO m.PropCount
	\<<ObjectProp[ i ]>>
	
	IF m.Postscript
		
		=SS_Say( ObjectProp[ i ] )
	ENDIF
NEXT

m.ObjName = LOWER( Name )
=WriteClause( "Comment", m.ObjName + " COMMENT", 1 )
=WriteClause( "When", m.ObjName + " WHEN", WhenType )
=WriteClause( "Message", m.ObjName + " MESSAGE", MessType )
=WriteClause( "RangeLo", m.ObjName + " RANGE LOW", LoType )
=WriteClause( "RangeHi", m.ObjName + " RANGE HIGH", HiType )
=WriteClause( "Valid", m.ObjName + " VALID", ValidType )
=WriteClause( "Error", m.ObjName + " ERROR", ErrorType )


****************************************************
FUNCTION ObjectString

DO CASE
	CASE ObjType = 11
	RETURN "List Box"
	
	CASE ObjType = 12
	RETURN "Push Button"
	
	CASE ObjType = 13
	RETURN "Radio Button"
	
	
	CASE ObjType = 14
	RETURN "Checkbox"
	
	
	CASE ObjType = 15
		
		DO CASE
			CASE ObjCode = 0
				RETURN "Say Field"
			CASE ObjCode = 1
				RETURN "Get Field"
			CASE ObjCode = 2
				RETURN "Edit Region"
		ENDCASE
	
	CASE ObjType = 16
	RETURN "Popup"
	
	
	CASE ObjType = 20
	RETURN "Invisible Button"
	
	OTHERWISE 
	RETURN ""
ENDCASE