***********************************************************************
* PROC.EXE                                                            *
*                                                                     *
* This program analyzes Clipper programs.                             *
*                                                                     *
* It outlines the location of procedures and functions in your source *
* code.  The list of procedures can be sorted alphabetically and may  *
* be output to a file or a printer.                                   *
*                                                                     *
* If you output to a file the extension defaults to .PRN              *
*                                                                     *
* The program automatically locates external procedure files.         *
*                                                                     *
* All .PRG files must reside in the default directory.                *
*                                                                     *
*                                                                     *
* If you find this program useful please send $15 to                  *
*                                                                     *
*      LOREN DATA LABORATORIES                                        *
*      6733 SEPULVEDA BOULEVARD, SUITE 240                            *
*      LOS ANGELES, CA  90045                                         *
***********************************************************************
parameters mainfile
set confirm on
clear
? "***********************************************************************"
? "* PROC.EXE                                                            *"
? "*                                                                     *"
? "* If you find this program useful please send $15 to                  *"
? "*                                                                     *"
? "*      LOREN DATA LABORATORIES                                        *"
? "*      6733 SEPULVEDA BOULEVARD, SUITE 240                            *"
? "*      LOS ANGELES, CA  90045                                         *"
? "***********************************************************************"
if pcount() = 0
  ?
  ? "SYNTAX:  PROC <filename>[.prg]"
  ?
  quit
endif
declare procfiles[255], linearray[255]
msort = .t.
@ 11,0 say "Sort output?" get msort picture "Y"
read
mshow = .t.
@ 12,0 say "Show text?" get mshow picture "Y"
read
mpf = " "
@ 13,0 say "Printer or File output (P/F)?" get mpf picture "!" valid mpf$"PF "
read
if empty(mpf)
  quit
elseif mpf = "F"
  mfilename = space(12)
  @ 15,10 say "Enter file name:" get mfilename
  read
  if empty(mfilename)
    quit
  endif
  set printer to &mfilename
endif
procblank = 1
mainfile = upper(mainfile)
mainfile = mainfile+if("."$mainfile,"",".PRG")
handle = fopen(mainfile,0)
if handle = -1
  set print on
  ? mainfile+" *** does not exist ***"
  ?
  set print off
  eject
  quit
endif
lineblank = 1
ln = 1
set cursor off
do while .t.
  mline = line(handle)
  if mline = "EEOOFF"
    exit
  endif
  mproc = linetest(mline)
  if !empty(mproc)
    linearray[lineblank] = mproc
    lineblank = lineblank + 1
  endif
  ln = ln + 1
enddo
if msort
  asort(linearray,1,lineblank-1)
endif
printarray(mainfile)
fclose(handle)
lineblank = 1
other = 1
do while .t.
  if other = procblank
    exit
  endif
  procfile = procfiles[other]
  procfile = procfile+if("."$procfile,"",".PRG")
  handle = fopen(procfile,0)
  if handle = -1
    set print on
    ? procfile+" *** does not exist ***"
    ?
    set print off
    other = other + 1
    loop
  endif
  do while .t.
    mline = line(handle)
    if mline = "EEOOFF"
      exit
    endif
    mproc = linetest(mline)
    if !empty(mproc)
      linearray[lineblank] = mproc
      lineblank = lineblank + 1
    endif
    ln = ln + 1
  enddo
  if msort
    asort(linearray,1,lineblank-1)
  endif
  printarray(procfile)
  lineblank = 1
  fclose(handle)
  other = other + 1
enddo
set console on
set print on
?
? "*** end ***"
set print off
if mpf = "P"
  eject
endif
set cursor on
quit

function line
  parameters fhandle
  private fline,fchar
  fline = ""
  do while .t.
    fchar = freadstr(fhandle,1)
    if "" = fchar .or. fchar = chr(13)
      exit
    endif
    if fchar$chr(9)+chr(10)
      fchar = " "
    endif
    fline = fline + fchar
  enddo
  if "" = fchar .and. empty(fline)
    return "EEOOFF"
  endif
  return fline


function linetest
  parameters testline
  if mshow
    ? trim(testline)
  else
    @ 24,0 say "Line: "+str(ln,5)
  endif
  testline = upper(ltrim(testline))
  if testline = "SET PROCEDURE TO"
    procfiles[procblank] = trim(substr(testline,18,12))
    procblank = procblank + 1
    return ""
  elseif testline = "DO WHILE" .or. testline = "DO CASE"
    return ""
  elseif testline = "DO "
    tmp = trim(subst(ltrim(testline),4))
    tmp = tmp+if(right(tmp,4)#".PRG",".PRG","")
    if file(tmp)
      procfiles[procblank] = tmp
      procblank = procblank + 1
    endif
    return trim(testline)
  elseif testline = "PROCEDURE "
    return trim(testline)
  elseif testline = "FUNCTION "
    return trim(testline)
  else
    return ""
  endif

function printarray
  parameter filename
  if !mshow
    set console off
  endif
  set print on
  ? filename
  ?
  for line = 1 to lineblank - 1
    ? "  "+if(!msort .and. linearray[line] = "DO","  ","")+linearray[line]
  next line
  ?
  set print off
  set console on
  return .t.
