; PCMOS.ASM    12/29/89     Updated 1/6/90, 4/20/90
;
; Assembler functions for Clipper and PC-MOS v4.0
;
; Written by: Don Caton
;             DC MicroSystems
;             3017 N. Oakland Forest Dr. #304
;             Ft. Lauderdale, FL 33309
;             305-485-0221
;             CIS 71067,1350
;
; No copyrights, guarantees, etc.  Use & distribute freely.
;
;
;        is_pcmos()         returns .T. if PC-MOS v4.0 is the operating system
;
;        mos_dis([<expN>])  enables keyboard loop detection, optionally
;                             sets new counter value, returns previous
;                             value or -1 if o/s is not PC-MOS
;                             <expN> must be between 1 and 255 inclusive
;
;        mos_nodis()        disables keyboard loop detection, returns current
;                              counter value or -1 if o/s is not PC-MOS
;
;        is_mosdis()        returns 0 is keyboard loop detection disabled,
;                              counter value if loop detection enabled,
;                              -1 if o/s is not PC-MOS
;
;        mos_sleep()        suspends task until key is pressed, returns nothing
;                              & may be called as a procedure: "DO mos_sleep"
;
;
; bug fix 04/09/90   is_pcmos() returning .T. on 1st call under MS-DOS
;
; modifications to mos_sleep() to call interrupt vectors by call
; instead of using interrupts
;
; modified proc is_mos to initialize vector address variables

PUBLIC          is_pcmos
PUBLIC          mos_dis
PUBLIC          mos_nodis
PUBLIC          is_mosdis
PUBLIC          mos_sleep
EXTRN           __parinfo:FAR
EXTRN           __parni:FAR
EXTRN           __retni:FAR
EXTRN           __retl:FAR
EXTRN           __ret:FAR

no              EQU     0
yes             EQU     1
dontknow        EQU     2

DGROUP          GROUP   DATASG
DATASG          SEGMENT PUBLIC 'DATA'
ismos_flag      DB      dontknow
tcb_segment     DW      ?       ;segment of task control block at offset 0
ext_vector      DD      0       ;ptr to MOS extended services handler
i16_vector      DD      0       ;ptr to int16 function handler
DATASG          ENDS

_PROG           SEGMENT 'CODE'
                ASSUME  cs:_PROG, ds:DGROUP

is_mos          PROC    NEAR            ;sets ZR flag if os is not PC-MOS 4.0
                cmp     ismos_flag,dontknow
                jne     return
                mov     ax,3000h        ;get dos version
                mov     bx,ax
                mov     cx,ax
                mov     dx,ax
                int     21h
                cmp     ax,4
                jne     not_mos         ;not 4.0
                push    ax
                mov     ax,3099h        ;test for DOS or MOS
                int     21h
                pop     bx
                cmp     bx,ax           ;if bx=ax, not MOS
                je      not_mos
                mov     ismos_flag,yes
                mov     ah,4            ;get TCB address
                mov     bx,0ffffh       ;current task
                int     0d4h            ;MOS extended service
                mov     tcb_segment,es  ;TCB block starts at es:0
                mov     ah,34h
                int     21h
                les     bx,es:[bx-18h]
                mov     word ptr [ext_vector],bx        ;pointer to MOS
                mov     word ptr [ext_vector+2],es      ;extended services
                mov     ax,3516h
                int     21h
                mov     word ptr [i16_vector],bx        ;pointer to int 16h
                mov     word ptr [i16_vector+2],es      ;function handler
                jmp     SHORT return
not_mos:        mov     ismos_flag,no
return:         cmp     ismos_flag,no
                ret
is_mos          ENDP

is_pcmos        PROC    FAR
                push    bp
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di
                call    is_mos
                jz      not_mos0
                mov     ax,1
                jmp     SHORT all_done0
not_mos0:       xor     ax,ax           ;return .F. to Clipper if not PC-MOS
all_done0:      push    ax
                call    __retl
                add     sp,2            
                pop     di
                pop     si
                pop     es
                pop     ds
                pop     bp
                ret
is_pcmos        ENDP

mos_dis         PROC    FAR
                push    bp
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di
                call    is_mos
                jz      not_mos1
                xor     ah,ah
                mov     es,tcb_segment
                mov     al,byte ptr es:[101h]
                push    ax              ;push return value for __retni
                mov     ax,1
                push    ax
                call    __parinfo
                add     sp,2
                cmp     ax,2            ;if ax=2 parameter is numeric
                jne     no_change       ;no param or incorrect type
                mov     ax,1
                push    ax
                call    __parni
                add     sp,2
                cmp     ax,0            ;if parameter < 1
                jl      no_change
                cmp     ax,256d         ;or > 255
                jge     no_change       ;don't write new value
                mov     es,tcb_segment
                mov     byte ptr es:[101h],al   ;set new counter value
no_change:      mov     es,tcb_segment
                mov     byte ptr es:[30h],1     ;enable keyboard looping detect
                jmp     SHORT all_done
not_mos1:       mov     ax,0ffffh       ;return -1 to Clipper if not PC-MOS
                push    ax
all_done:       call    __retni         ;return value already pushed
                add     sp,2            
                pop     di
                pop     si
                pop     es
                pop     ds
                pop     bp
                ret
mos_dis         ENDP

mos_nodis       PROC    FAR
                push    bp
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di
                call    is_mos
                jz      not_mos2
                mov     es,tcb_segment
                mov     byte ptr es:[30h],0     ;disable keyboard looping detect
                xor     dh,dh
                mov     dl,byte ptr es:[101h]   ;current counter setting
                jmp     SHORT all_done2
not_mos2:       mov     dx,0ffffh       ;return -1 to Clipper if not PC-MOS
all_done2:      push    dx              ;return current counter setting
                call    __retni
                add     sp,2            
                pop     di
                pop     si
                pop     es
                pop     ds
                pop     bp
                ret
mos_nodis       ENDP

is_mosdis       PROC    FAR
                push    bp
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di
                call    is_mos
                jz      not_mos3
                mov     es,tcb_segment
                xor     dh,dh
                mov     dl,byte ptr es:[30h]    ;keyboard loop detect flag
                cmp     dx,0                    ;if off, return 0
                je      all_done3
                mov     dl,byte ptr es:[101h]   ;else return counter setting
                jmp     SHORT all_done3
not_mos3:       mov     dx,0ffffh       ;return -1 to Clipper if not PC-MOS
all_done3:      push    dx
                call    __retni
                add     sp,2            
                pop     di
                pop     si
                pop     es
                pop     ds
                pop     bp
                ret
is_mosdis       ENDP

mos_sleep       PROC    FAR
                push    bp
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di
                call    is_mos
                jz      not_mos4
go_to_sleep:    mov     ax,0701h        ;suspend task until keypress
                pushf
                cli
                call    [ext_vector]    ;call MOS extended services handler
                                        ;
                                        ; *****************************
                                        ; task is now suspended and it's
                                        ; CPU time is relinquished until
                                        ; a keystroke is detected by MOS
                                        ; *****************************
                                        ;
                mov     ah,1            ;BIOS keyboard status function
                pushf
                cli
                call    [i16_vector]    ;call int 16h handler
                                        ;if ZR flag is set, keypress was
                jz      go_to_sleep     ;a shift, ctrl or other misc keystroke
not_mos4:       call    __ret
                pop     di
                pop     si
                pop     es
                pop     ds
                pop     bp
                ret
mos_sleep       ENDP

_PROG           ENDS
                END


