PREST()     && use these two lines if the file is compiled as it is
RETU        && and not placed in a function library.

* ============================================================================
* ============================================================================
* Syntax:   PREST()  Version 2.1 (July 1992)
* Usage:    Used to Restore backup sets made using P_BACK()
*
*           Can be used with Clipper S87 or 5.0
*
*           This file includes the following functions:
*
*           P_REST()   - Restore files
*           PADR()     - Pad a string to the right. (take out for Clipper 5.0)
*
* Copyright: (c) 1992 by Per Kjellqvist
*                        Le Caddie 4
*                        CH - 1936 VERBIER
*                        Switzerland            CompuServe 71540,2311
* ============================================================================
* use Px_list to restore, go through file by file
* Px_list -> "des_book.dbfdesguest.dbf"  ...
* new function: give drive letter, then check the whole backup set, let
*               users tag files.
FUNC PREST
PRIV lmem,lbyte_tot,lbyte_cop,lfile_no,lin,lread,ldrive,lbackno,ldisk_no,;
     ltemp,linc,lbuffer,lout,lpos,lwrite,lname,lkey,lerror,lsize,lpath,;
     lscreen,lcount,lc1,lc2

SETCANCEL(.F.)        && Alt-C cannot be used to terminate program
READEXIT(.F.)         && disables exiting READ with arrows
SET SCOR OFF          && does not show <ins> and date error
SET ESCA ON           && Escape from a read
SET EXAC OFF          && match with = doesn't need all characters
SET CONF ON           && doesn't terminate read when it is full
SET BELL OFF          && no sound at read
SET DELE ON           && doesn't show deleted records
SET CURS OFF

lmem    = "per_back.mem"                             && file with backup info

lc1     = "B/BG"                                     && background colour
lc2     = "GR+/BG"                                   && highlight colour
ltemp   = "hrestore.000"                             && temporary file
lpath   = "C:\"+CURDIR()+IF(EMPTY(CURDIR()),"","\")  && current path
ldrive  = "A"                                        && default drive
lscreen = SAVESCREEN(5,2,13,69)

DO WHIL .T.
   SETCOLOR(lc1)
   @ 5,2 CLEA TO 13,69
   @ 5,2  TO 13,69 DOUB
   @ 6,5  TO 8,9
   @ 9,7  TO 11,7
   @ 11,7 TO 11,10
   @ 7,10  SAY ":"
   @ 7,7   SAY "o"
   @ 8,7   SAY ""
   @ 11,7  SAY ""
   @ 11,10 SAY ""
   @ 7,16  SAY "Disk:"
   @ 9,16  SAY "File:"

   SETCOLOR(lc2)
   @ 5,28 SAY " RESTORE BACKUP "
   SETCOLOR(lc1)

   lpath  = LEFT(lpath+SPAC(55),55)

   @  7,12 GET ldrive PICT "@!" VALID ldrive $ "AB"
   @ 11,12 GET lpath  PICT "@K! A:\"+REPL("X",52)
   SET CURS ON
   READ
   SET CURS OFF

   IF LASTKEY() = 27
      EXIT
   ENDI

   lpath = UPPE(TRIM(lpath))
   lpath = IF(RIGHT(lpath,1)="\",lpath,lpath+"\")

   @ 11,12 SAY SPAC(55)
   @ 11,12 SAY lpath

   ldisk_no  = 1
   linc      = 4096
   lname     = ""
   lbyte_tot = 0
   lbyte_cop = 0

   DO WHIL ldisk_no <> 0
      SETCOLOR(lc2)
      @ 7,22 SAY "# "+LTRIM(STR(ldisk_no))
      @ 7,48 SAY "[]-Ok  [ESC]-Quit"
      SETCOLOR(lc1)
      lkey = INKEY(0)
      @ 7,22 SAY "# "+LTRIM(STR(ldisk_no))
      @ 7,48 SAY SPAC(20)

      IF lkey = 27
         EXIT
      ENDI
      IF FILE(ldrive+":"+lmem)
         REST FROM &ldrive.:&lmem ADDI   && --> PX_* variables
         * ---- FIRST DISK ------------------------------------------------
         IF ldisk_no = 1
            lbyte_tot = PX_byte     && bytes to copy
            lbackno   = PX_number
         ENDI
         * ----------------------------------------------------------------
         IF PX_disk = ldisk_no .AND. PX_number = lbackno
            * ==========================================================
            lpos   = 0     && nothing has been copied yet
            lcount = ADIR(ldrive+":*.*")
            PRIV ARname[lcount],ARsize[lcount],ARdate[lcount]
            ADIR(ldrive+":*.*",ARname,ARsize,ARdate)

            FOR lfile_no = 1 TO LEN(ARname)
                IF ARname[lfile_no] $ PX_list
                   lkey  = IF(FILE(lpath+ltemp),0,27)
                   lsize = ARsize[lfile_no]
                   IF lname = ARname[lfile_no]       && APPEND TO FILE
                      lout = FOPEN(lpath+ltemp,2)    && open target
                      FSEEK(lout,0,2)                && move to end of file
                   ELSE                              && MAKE NEW FILE
                      IF lpos > 0
                         ERASE  &lpath.&lname
                         RENAME &lpath.&ltemp TO &lpath.&lname
                      ENDI
                      * -- Start a new file ----------------------------------
                      lpos  = 0
                      lname = ARname[lfile_no]
                      lout  = FCREATE(lpath+ltemp)   && Create temporary file
                      SETCOLOR(lc2)
                      @ 9,22 SAY PADR(lname,12)+" "+DTOC(ARdate[lfile_no])
                      @ 9,48 SAY "[]-Ok  [ESC]-Quit"
                      SETCOLOR(lc1)
                      lkey = INKEY(0)
                      @ 9,22 SAY PADR(lname,12)+" "+DTOC(ARdate[lfile_no])
                      @ 9,48 SAY SPAC(20)
                   ENDI
                   lerror = FERROR()
                   IF lerror = 0 .AND. lkey <> 27
                      lin    = FOPEN(ldrive+":"+lname)      && Open the source file
                      lerror = FERROR()
                      lpos   = 0
                      DO WHIL lerror = 0
                         lbuffer   = SPAC(linc)
                         lread     = FREAD(lin,@lbuffer,linc)
                         lwrite    = FWRITE(lout,lbuffer,lread)
                         lerror    = FERROR()
                         IF lerror = 0
                            lpos      = lpos      + lwrite
                            lbyte_cop = lbyte_cop + lwrite
                            lkey      = NEXTKEY()          && read  buffer
                            KEYBOARD CHR(0)                && clear buffer
                            INKEY()                        && clear buffer
                            @ 9,48 SAY TRAN(ROUND(lpos/MAX(lsize,1)*100,0),"@Z 999")+" %"
                            IF lread = 0 .OR. lkey = 27        && File has been successfully copied, or esc was pressed
                               EXIT
                            ENDI
                         ENDI
                      ENDD
                      FCLOSE(lin)
                   ENDI
                   FCLOSE(lout)
                   IF lerror <> 0 .OR. lsize <> lpos .OR. lkey = 27          && ERROR
                      ERASE &lpath.&ltemp
                      lbyte_cop = lbyte_cop + (lsize-lpos)
                   ENDI
                   IF lbyte_cop = lbyte_tot                && DONE
                      IF lpos > 0
                         ERASE  &lpath.&lname
                         RENAME &lpath.&ltemp TO &lpath.&lname
                      ENDI
                      ldisk_no = 0
                      EXIT
                   ENDI
                ENDI
            NEXT
            IF ldisk_no <> 0
               ldisk_no = ldisk_no + 1            && increment disk number
            ENDI
            * ==========================================================
         ENDI
      ENDI
   ENDD
   ERASE &lpath.&ltemp                                                     && just in case
ENDD
SET CURS ON
RESTSCREEN(5,2,13,69,lscreen)
RETU .T.

* ============================================================================
* ============================================================================
* Syntax:   PADR(exp,expN,<expC>)
* Argument: exp    = character, numeric or date value to pad
*           expN   = lenght of character string to return
*           <expC> = character to pad, if not specified spaces are used
* Return:   String
* Usage:    pad a character string on the right with a fill character
* Example:  ? "["+PADR("per",10)+"]"
*           gives   [per       ]
*           ? PADR("per",10,".")
*           gives    per.......
* ============================================================================
  FUNC PADR
  PARA lexp, lno, lpad
  RETU LEFT(ALLTRIM(TRANS(lexp,""))+REPL(IF(PCOUNT()=3,lpad," "),lno),lno)


