* PROGRAM ----: PACKMEMO.PRG 
* AUTHOR -----: Kevin E. Saffer - in area code 203 or 904 if you have questions)
* COPYRIGHT --: NONE, THIS PROGRAM IS HEARBY RELEASED INTO THE PUBLIC DOMAIN
* CREATED ----: 4/25/1988 at 14:57
* NOTES ------: Contains the MPACK function

* This program implements a memo packing function using the DOS file handling
* functions in the Summer 87 release of Clipper.  The memo file structure is
* laid out in blocks of 512 bytes each.  A start block of 512 bytes is at the 
* top of each DBT file (thats why the DBT file of a freshly created database    
* has a file size of 513).  This first block contains only one critical item-
* the next available block number in the first four bytes of the block.

* The actual memo text (block 1) starts at byte 513 in the DBT file.  The memo
* text then continues across contiguous blocks until an ASCII 26 (Ctrl-Z) is
* encountered, signaling the end of the memo record.

* Clipper accesses these memo blocks by taking the starting block number from 
* the DBF file and multiplying it by 512.  This offset is the location in the DBT file 
* where the memo text begins.  Clipper then reads subsequent blocks until the
* entire memo is read.  This need for contiguous blocks is why DBT files grow
* so large (memos which have been lengthened must be completely re-written to
* the end of the file to keep the text blocks contiguous).  I hope one day    
* someone at Nantucket will create a way of keeping linked lists of memo file
* blocks, so the memo files would not get so big.  Enough soapbox, lets get
* on with the program.

* MPACK operates as follows:  

* The program is passed a database filename to be memopacked.  The existence
* of both the DBF and DBT files is verified.  The database field information
* is then read into arrays to calculate the number of memo fields present and
* the offset within each record where the starting memo block number lies.

* The available disk space and the size of the DBT file are compared to ensure
* that there is sufficient space for the copy.  The ASM file SIZEOF is included
* in this library for this operation.

* Field information arrays are then created and loaded with AFIELDS() to 
* scan for a field type of M (Memo).  If one is found, the program creates
* an array of memo pointer offsets.  These offsets are used to reach the 10 
* byte long memo block pointers in each DBF record for updating.

* The original DBT file is renamed to TBK, and a new DBT file is created.
* The first 512 byte block is read from the original, and written to the
* new DBT file.

* The database records are then processed by seeking to each memo block pointer
* in each record.  If there is no memo for this field, the 10 bytes will be 
* all blanks and will VAL() to zero.  Otherwise, we use this number (multiplied
* by 512) to seek to the starting memo block in the old DBT file.  The entire
* memo is then read and written to the new DBT file until we hit a Ctrl-Z.
* This process continues until all of the memo fields in the file are copied.

* The last thing MPACK must do is updated the first four bytes in the new
* DBT file with the next available block number.  All files are then closed,
* and the TBK file is deleted.

* SYNTAX:
*
* Result = MPACK(<dbfname>)
*
* Where <dbfname> is either a quoted character string or memory variable 
* containing the name of the database file to be packed.  You may include
* or omit the extension ".DBF".

* RETURNS:
*
* 0 = sucessful pack
* 1 = no passed filename
* 2 = DBF file does not exist 
* 3 = DBT file does not exist 
* 4 = Insufficient disk space for pack
* 5 = Error opening DBF
* 6 = Error opening TBK
* 7 = Error creating new DBT
* 8 = Error reading DBF header
* 9 = Error reading 1st memo block
* 10 = Error writing 1st memo block
* 11 = Critical error occurred while processing, DBF and DBT file WILL HAVE TO
*      BE RESTORED FROM BACKUP!
 
* EXAMPLE:
*
* ItWasGood = MPACK("CUSTOMER")
* IF ItWasGood <> 0 .AND. ItWasGood <> 11
*   CLEAR
*   ? "UNABLE TO PACK DBT FILE - ORIGINAL FILES RESTORED."
*   ? "BETTER CALL <yournamegoeshere> TO DETERMINE CAUSE."
*   RETURN
* ENDIF
* IF ItWasGood = 11
*   ? "OHSHIT - SOMETHING IS TERRIBLY WRONG WITH THE DBF or DBT FILES!"
*   ? "         DATA WAS LOST DURING PACK - CALL <yournamegoeshere> NOW!"
*   ? "         THE DBF and DBT FILES MUST BE RESTORED TO CONTINUE."
*   CANCEL
* ENDIF

* I stongly recommend that you take a full backup of the DBF and DBT files
* before memopacking.  It will save you considerable grief if someone pulls
* the plug on the computer at the wrong time.

* MPACK assumes that the DBF and DBT files are in good condition and makes 
* no checks to attempt any repair.  If your information is critial you MUST
* backup the files before packing.  DONT TRUST ANY DBMS WHERE LIVES ARE 
* CONCERNED!

* END OF TIRADE, ON WITH THE CODE!

* the following code simply gives this program file PACKMEMO the ability of
* being compiled and run.  You would remove the following lines to create a
* obj file for linking with your application.

PARAMETERS CommandLine
IF PCOUNT() < 1
  CANCEL
ENDIF
PackResult = MPACK(CommandLine)
DO CASE
CASE PackResult = 0
  ? "File was packed without error."
CASE PackResult = 1
  ? "No passed filename."
CASE PackResult = 2
  ? "DBF file does not exist."
CASE PackResult = 3
  ? "DBT file does not exist."
CASE PackResult = 4
  ? "Insufficient disk space for pack."
CASE PackResult = 5
  ? "Error opening DBF."
CASE PackResult = 6
  ? "Error opening TBK."
CASE PackResult = 7
  ? "Error creating new DBT."
CASE PackResult = 8
  ? "Error reading DBF header."
CASE PackResult = 9
  ? "Error reading 1st memo block."
CASE PackResult = 10
  ? "Error writing 1st memo block."
CASE PackResult = 11
  ? "CRITICAL ERROR OCCURRED, YOU WILL HAVE TO RESTORE DATA."
ENDCASE
CANCEL


* start of the function MPACK (don't delete these lines!)

FUNCTION MPACK
  * put the grab on the passed filename (assumed to be a valid DBF file)
  PARAMETERS DbfName
  IF PCOUNT() < 1
    RETURN 1
  ENDIF
  * declare every variable private so they wont interfere with your code
  PRIVATE OPEN_RO,OPEN_WO,OPEN_WR,SEEK_TOP,SEEK_CUR,DbtName,TbkName
  PRIVATE Fname,Ftype,Flen,Fdec,IsMemo,OffSet,FldCntr,MemoCntr,CurrCntr
  PRIVATE LastMemoCntr,DbfHandle,TbkHandle,DbtHandle,Buffer,Result
  PRIVATE RecCount,HdrSize,RecSize,NewBlock,CurrRec,DbfPos,MemoChar
  PRIVATE OldBlock,BlockBuffer,RetVar

  * initilaze some file handling mode aliases to make the code readable
  OPEN_RO = 0         && open file read only
  OPEN_WO = 1         && open file write only
  OPEN_RW = 2         && open file read write
  SEEK_TOP = 0        && fseek relative to top of file
  SEEK_CUR = 1        && fseek relative to current position

  * create the DBF, DBT and TBK file name memory variables
  IF AT(".",DbfName) <> 0
    DbtName = SUBSTR(DbfName,1,AT(".",DbfName)-1) + ".DBT"
    TbkName = SUBSTR(DbfName,1,AT(".",DbfName)-1) + ".TBK"
  ELSE
    DbtName = TRIM(DbfName) + ".DBT"
    TbkName = TRIM(DbfName) + ".TBK"
    DbfName = TRIM(DbfName) + ".DBF"
  ENDIF
  
  * check for the DBF file's existence
  IF .NOT. FILE("&DbfName")
    RETURN 2
  ENDIF

  * check for the DBT file's existence
  IF .NOT. FILE("&DbtName")
    RETURN 3
  ENDIF

  * check the disk space available to create the new DBT file
  * SIZEOF is included in this library file, link it in.     
  IF DISKSPACE() < SIZEOF(DbtName)+1024
    RETURN 4
  ENDIF
  
  * open the DBF with USE and build arrays of field info
  USE &DbfName
  DECLARE Fname[FCOUNT()],Ftype[FCOUNT()],Flen[FCOUNT()],Fdec[FCOUNT()]
  AFIELDS(Fname,Ftype,Flen,Fdec)
  * check for a memo field type
  IsMemo = ASCAN(Ftype,"M")
  IF IsMemo = 0
    RETURN 3
  ENDIF

  * we need to calculate the offsets into each record where each 10 byte memo
  * file block pointer resides, and save then in the array OFFSET for later 
  DECLARE OffSet[FCOUNT()]
  FldCntr = 1
  MemoCntr = 1
  CurrOffset = 1
  DO WHILE FldCntr <= FCOUNT()
    IF FType[FldCntr] = "M"
      OffSet[MemoCntr] = CurrOffset
      MemoCntr = MemoCntr + 1
    ENDIF
    CurrOffset = CurrOffset + Flen[FldCntr]
    FldCntr = FldCntr + 1
  ENDDO
  LastMemoCntr = MemoCntr
  CLOSE DATABASES
   
  * open the database file in low level mode
  DbfHandle = FOPEN("&DbfName",OPEN_RW)
  IF FERROR() <> 0
    RETURN 5
  ENDIF

  IF FILE("&TbkName")
    DELETE FILE &TbkName
  ENDIF
  * rename the DBT file to TBK
  RENAME &DbtName TO &TbkName

  * open the original memo file
  TbkHandle = FOPEN("&TbkName",OPEN_RW)
  IF FERROR() <> 0
    FCLOSE(DbfHandle)
    RENAME &TbkName TO &DbtName
    RETURN 6
  ENDIF

  * create a new file for the packed memo data
  DbtHandle = FCREATE("&DbtName",0)   && the 0 is for normal creation
  IF FERROR() <> 0
    FCLOSE(DbfHandle)
    FCLOSE(TbkHandle)
    IF FILE("&DbtName")
      DELETE FILE &DbtName
    ENDIF
    RENAME &TbkName TO &DbtName
    RETURN 7
  ENDIF

  * read the header of the DBF file to store the header and record size
  Buffer = SPACE(32)
  Result = FSEEK(DbfHandle,0,SEEK_TOP)    && go to top of file
  Result = FREAD(DbfHandle,@Buffer,32)    && read 32 bytes
  IF Result <> 32
    FCLOSE(DbfHandle)
    FCLOSE(DbtHandle)
    FCLOSE(TbkHandle)
    IF FILE("&DbtName")
      DELETE FILE &DbtName
    ENDIF
    RENAME &TbkName TO &DbtName
    RETURN 8
  ENDIF
  RecCount = BIN2L(SUBSTR(Buffer,5,4))
  HdrSize  = BIN2W(SUBSTR(Buffer,9,2))
  RecSize  = BIN2W(SUBSTR(Buffer,11,2))

  * read, then write the first 512 block of the memo file
  Buffer = SPACE(512)
  Result = FSEEK(TbkHandle,0,SEEK_TOP)
  Result = FREAD(TbkHandle,@Buffer,512)
  IF Result <> 512
    FCLOSE(DbfHandle)
    FCLOSE(DbtHandle)
    FCLOSE(TbkHandle)
    IF FILE("&DbtName")
      DELETE FILE &DbtName
    ENDIF
    RENAME &TbkName TO &DbtName
    RETURN 9
  ENDIF
  Result = FWRITE(DbtHandle,@Buffer,512)
  IF Result <> 512
    FCLOSE(DbfHandle)
    FCLOSE(DbtHandle)
    FCLOSE(TbkHandle)
    IF FILE("&DbtName")
      DELETE FILE &DbtName
    ENDIF
    RENAME &TbkName TO &DbtName
    RETURN 10
  ENDIF

  * alright, we now process each memo field in each record
  * note that this stage we begin making writes to the DBF file, so renaming
  * the old TBK file back just will not work.  If an error occurs here, you
  * must restore the data from your backup.  (YOU DID TAKE ONE, RIGHT?)

  RetVar = 0                                      && Assume all ok
  NewBlock = 1                                    && new block counter in the memo file
  CurrRec = 1                                     && you guessed it
  DO WHILE CurrRec <= RecCount                    && repeat for each record
    MemoCntr = 1
    DO WHILE MemoCntr < LastMemoCntr              && repeat for each memo field
      * calculate the new position to seek to
      DbfPos = HdrSize + ((CurrRec - 1) * RecSize) + OffSet[MemoCntr]
      Result = FSEEK(DbfHandle,DbfPos,0)
      IF Result < 0
        Retvar = 11
      ENDIF
      MemoChar = SPACE(10)                        && holds the memo pointer
      Result = FREAD(DbfHandle,@MemoChar,10)      && load buffer from dbf file
      IF Result <> 10
        Retvar = 11
      ENDIF
      OldBlock = VAL(MemoChar)                    && and val it for a check
      IF OldBlock <> 0
        * we have found a pointer to a memo!
        Result = FSEEK(DbfHandle,-10,1)           && back up 10 positions
        IF Result < 0
          Retvar = 11
        ENDIF
        MemoChar = STR(NewBlock,10,0)             && create a new memo pointer
        Result = FWRITE(DbfHandle,@MemoChar,10)   && write it to the DBF
        IF Result <> 10
          Retvar = 11
        ENDIF
        MemoPos = OldBlock * 512                  && calc position in OLD DBT
        Result = FSEEK(TbkHandle,MemoPos,0)       && and seek to it
        IF Result < 0
          Retvar = 11
        ENDIF
        DO WHILE .T.                              && process each memo block
          Buffer = SPACE(512)
          Result = FREAD(TbkHandle,@Buffer,512)   && read this block, and
          IF Result <> 512
            Retvar = 11
          ENDIF
          Result = FWRITE(DbtHandle,@Buffer,512)  && write it to the new file
          IF Result <> 512
            Retvar = 11
          ENDIF
          NewBlock = NewBlock + 1
          IF AT(CHR(26),Buffer) <> 0              && Ctrl-Z found?
            EXIT                                  && bug out
          ENDIF
        ENDDO
      ENDIF
      * increment the memo offset pointer to do the next memo field
      MemoCntr = MemoCntr + 1
    ENDDO
    * increment the record pointer
    CurrRec = CurrRec + 1
  ENDDO
  * done processing, update the DBT header with the next available block number
  Result = FSEEK(DbtHandle,0,0)
  IF Result < 0
    Retvar = 11
  ENDIF
  BlockBuffer = L2BIN(NewBlock)
  Result = FWRITE(DbtHandle,@BlockBuffer,4)
  IF Result <> 4
    Retvar = 11
  ENDIF
  * close em up, it's Miller time!
  FCLOSE(DbfHandle)
  FCLOSE(DbtHandle)
  FCLOSE(TbkHandle)
  IF FILE("&TbkName")
    DELETE FILE &TbkName
  ENDIF
RETURN 0

* EOF - PACKMEMO.PRG
