clear all 
clear 
SET CONFIRM ON
*** display title box
LINE1='LIST NTX FILE INFORMATION'
LINE2='TODAY IS '+NAMEDATE()
CENTERBOX(2,LINE1,LINE2)

*** get name of output file
OUTFILE=SPAC(12)
@5,10 SAY 'ENTER OUTPUT FILE NAME' GET OUTFILE
READ

*** check if file already exists
IF FILE('&OUTFILE')
   LINE1='THIS FILE: '+OUTFILE+' ALREADY EXISTS'
   LINE2='PRESS "Y" TO USE ANYWAY, ANY OTHER KEY TO EXIT'
   CENTERBOX(7,LINE1,LINE2)
   RESP=CHR(INKEY(0))
   IF RESP='Y'
     @6,0 CLEAR
   ELSE
      CLEAR SCREEN
      RETURN
   ENDIF
ENDIF   
SET COLOR TO W+*/N
@7,35 SAY 'WORKING'
SET COLOR TO

*** get all .ntx filenames into database file
run dir *.ntx>NTXS.TXT
select 1
if file("NTXS.DBF")
   use NTXS
   zap 
else 
   create prg_stru
   use prg_stru
   append blank 
   replace field_name with "NAME",field_type with "C",field_len with 8
   close databases 
   create NTXS from prg_stru
   erase prg_stru.dbf
   use NTXS
endif 
append from NTXS.TXT SDF
delete for NAME=" "
pack 
go top 

*** open output file & insert headings
OUTHANDLE=FCREATE('&OUTFILE')
TMPSTR='NTX NAME'+' '+'INDEX EXPRESSION'+SPAC(44)+'DBF NAME'+CHR(13)+CHR(10)
FWRITE(OUTHANDLE,TMPSTR)
TMPSTR=REPLICATE('-',79)+CHR(13)+CHR(10)
FWRITE(OUTHANDLE,TMPSTR)
TMPSTR=''
LNCOUNT=2
do while .not. eof()
   *** open index file
   fname=trim(name)+'.NTX'
   inHANDLE = fopen("&fname")
   if ferror() <> 0
      ? "File open error on "+fname
      wait 
      fclose(INHANDLE)
      FCLOSE(OUTHANDLE)
      CLOSE DATABASES
      CLEAR SCREEN
      return 
   endif 

   *** first get the index expression 
   FSEEK(INHANDLE,22)
   INDEXP = FREADSTR(INHANDLE,128)
   INDEXP = TRIM(INDEXP)

   *** next get the database inserted by NTXCAT or FNTXCAT
   FSEEK(INHANDLE,1008)
   DBF_NAME=FREADSTR(INHANDLE,8)
   DBF_NAME=TRIM(DBF_NAME)
   OBUFFER=NAME+' '+PAD(INDEXP,60)+' '+DBF_NAME+CHR(13)+CHR(10)
   IF LNCOUNT>=60
      LNCOUNT=2
      TMPSTR=CHR(12)+CHR(13)+CHR(10)
      FWRITE(OUTHANDLE,TMPSTR)
      TMPSTR='NTX NAME'+' '+'INDEX EXPRESSION'+SPAC(44)+'DBF NAME'+CHR(13)+CHR(10)
      FWRITE(OUTHANDLE,TMPSTR)
      TMPSTR=REPLICATE('-',79)+CHR(13)+CHR(10)
      FWRITE(OUTHANDLE,TMPSTR)
      TMPSTR=''      
   ENDIF

   *** output to text file
   FWRITE(OUTHANDLE,OBUFFER)
   LNCOUNT=LNCOUNT+1
   FCLOSE(INHANDLE)
   SKIP
ENDDO   
FCLOSE(OUTHANDLE)
CLEAR ALL
CLEAR SCREEN
RETURN