*************************************************************************
* Program..: NSend.prg
* Author...: Paul H. Mannes
* Date.....: July 13,1988
* Notice...: dConsultant Systems
* Interface to Novell SEND command through Clipper program
* Notes....: NSend.prg was written to automate the process of sending 
*            messages from one station on the Novell network to another.
*            The utility program USERLIST is used to re-direct the actual
*            list of current users to a text file.  That file is then 
*            analyzed for the names of the users.  The list is then displayed
*            and used as a menu of options from which to pick a name.
* Customize: The following code is set up for a network with two servers.
*            One is called DP and the other WP.  The <isdp> and <iswp> variables
*            are used to test whether a particular user is on one server or
*            other. The server name as a parameter after the USERLIST command
*            will return a one line error message if that server is not 
*            ATTACHED.
*            It should be easy enough to modify the code below to fit your
*            installation.  The critical area is that which reads in the .txt
*            file with fread() and extracts the users names.
* Program is placed into the PUBLIC DOMAIN by Paul H. Mannes
* Technical Stuff *******************************************************
* compiled with - CLIPPER (87): nsend -l
* linked with TLINK (1.0)     : 
*          tlink nsend windows,,,clipper extend tr
*  Object file Windows.obj is from Joseph Booth (01/08/88)
*  Library file TR is from Tom Rettig for Summer 87
************************************************************************* 
para graphic    && used to add a calling parameter for Compaq type screens.
*               call as >NSEND m   
* variables used
*
iserror    = .f.
store .f. to isdp,iswp

*
* get userlist from DP and WP
* dp.txt is from the DP server

! userlist dp/ > dp.txt       && change 'dp' to name of your server

* open files and set handles
fh_dp = fopen("dp.txt",0)
if ferror() <> 0
   iserror = .t.
endi

* wp.txt is from the WP server   
* all code here related to the WP server can be deleted for single server
* networks

! userlist wp/ > wp.txt       && change 'wp' to name of your server

* open files and set handles
fh_wp = fopen("wp.txt",0)

if ferror() <> 0
   iserror = .t.
endi
* load txt files into buffers
dp_buff = freadstr(fh_dp,1000)
if len(dp_buff) > 50
   isdp = .t.
endi

wp_buff = freadstr(fh_wp,1000)
if len(wp_buff) > 50
   iswp = .t.
endi

if !iserror
   set score off
   set wrap on
   set cursor off
   if iscolor() .and. pcount() = 0
      normal  = "w/n,+gr/n"
      reverse = "n/gr,n/g"
      bright  = "+w/n+,+gr/n"
   else
      normal  = "w/n,+w/n"
      reverse = "n/w,w/n"
      bright  = "+w/n,n/w"
   endi
   setcolor(reverse)  
   clear
   @ 0,1 to 3,78 doub
   @ 1,3 say "Clipper/Novell Station-to-Station Messaging"
   @ 1,68 say "NSend 1.0"
   * remove next asterisk and enter name of Company using the network
   * @ 2,3 say "Name of Company"
   *
   * initialize some windows
   w_init(4)                  && link in WINDOWS.OBJ from Joseph Booth
   *
   * set up message to let user know something is happening
   *
   wn1_buff = savescreen(10,25,13,56)
   cr_color = setcolor("+w*/n")
   @ 11,26 clear to 13,56
   wn1 = w_make(10,25,12,55,3,.t.,bright)
   @ 11,30 SAY "Getting Users . . ."
   setcolor(cr_color)


   dplines = 0
   wplines = 0

   * get number of lines in dp.txt
   if isdp
      for i = 1 to len(dp_buff)
          if asc(subs(dp_buff,i,1)) = 13
             dplines = dplines + 1
          endi        
      next
      dplines = dplines - 4
      declare dpl[dplines]
   endi

   * get number of lines in wp.txt
   * can be deleted for single server systems
   if iswp
      for i = 1 to len(wp_buff)
          if asc(subs(wp_buff,i,1)) = 13
             wplines = wplines + 1
          endi
      next
      wplines = wplines - 4
      declare wpl[wplines]
   endi

   declare nov_users[dplines + wplines + 1]   && array to hold names of users
   nofusers = 1
   * get names for dp.txt
   if isdp
      nofusers = 1
      i = 1
      start = 1
      d_lines = 1
      do while i <= len(dp_buff)           && loop through buffer of file
         if asc(subs(dp_buff,i,1)) = 13    && Car_ret and Line feed  Hex 0D 0A
            *
            * names actually start after fourth accurance of 0D 0A
            *
            if d_lines > 4

               dpl[d_lines - 4] = subs(dp_buff,start,i - start)
               nxt = 1
               *
               * loop through line looking for start of Name
               *
               do while asc(subs(dpl[d_lines -4],nxt,1)) <= 64
                  nxt = nxt + 1
               endd
               * 
               uname = subs(dpl[d_lines -4],nxt,14)
               * load name into user array with name of Server following
               * final (DP) is used in SEND command if multiple servers
               nov_users[nofusers] = uname + space(14 - len(uname)) + "(DP)"
               nofusers = nofusers + 1
            endi
            if d_lines - 4 > dplines
               exit
            endi
            d_lines = d_lines + 1
            start = i + 2
         endi
         i = i + 1
   
      endd
      fclose(fh_dp)   && close down the txt file by handle
   endi
   * repeat for next server
   * get names for wp.txt
   if iswp
      i = 1
      start = 1
      w_lines = 1
      do while i <= len(wp_buff)
         if asc(subs(wp_buff,i,1)) = 13
            if w_lines > 4
               wpl[w_lines - 4] = subs(wp_buff,start,i - start)
               uname = ""
               nxt = 1
               do while asc(subs(wpl[w_lines -4],nxt,1)) <= 64
                  nxt = nxt + 1
               endd
               uname = uname + subs(wpl[w_lines -4],nxt,14)
               nov_users[nofusers] = uname + space(14 - len(uname)) + "(WP)"
               nofusers = nofusers + 1
            endi
            if w_lines -4 > wplines
               exit
            endi
            w_lines = w_lines + 1
            start = i + 2
         endi
         i = i + 1
   
      endd
      fclose(fh_wp)
   endi
   nov_users[nofusers] = "EVERYBODY     ( *)"   && add so anyone can communicate
   *                                               with all other users on system
   *
   * get number of names loaded into user array
   *
   howmany = len(nov_users)

   tone(192,2)
   tone(310,4)
   @ 2,68 say "Users: "+ltrim(str(howmany))   && place number on screen
   w_release(wn1)
   *
   * set up window for user list box
   *
   restscreen(10,25,13,56,wn1_buff)
   botrow = if(howmany > 16,16,5+howmany)
   u_buff = savescreen(4,3,botrow + 1, 26)
   wn2 = w_make(4,3,botrow,24,4,.f.,reverse)   && not displayed yet
   wn3 = w_make(16,1,22,78,3,.f.,bright)       && not displayed yet
   c_color = setcolor(normal)
   msg = space(60)
   *
   do while .t.

      setcolor(normal)
      @ 6,5 clear to botrow + 1,26
      setcolor(c_color)
      w_display(wn2)
      cr_color = setcolor(bright)
      @ botrow,4 say "[ ,,Ret,Esc ]"
      setcolor(cr_color)
      *
      x = w_pick(wn2,howmany,nov_users)        
      *
      if lastkey() = 27
         exit
      endi
      *
      whoto = trim(subs(nov_users[x],1,14))   && user name for display
      server = subs(nov_users[x],16,2)        && server for command

      w_close(wn2)
      restscreen(4,3,botrow + 1,26,u_buff)
      w_display(wn3)
      setcolor(bright)
      set cursor on

      * set up screen for entry of command

      @ 17,2 say "Instructions: Enter your message and press return."
      @ 19,2 say "Send to: " + whoto
      @ 19,40 say "Server: " + server
      @ 20,2 say "Message: [" get msg pict "@K"     && @K allows the same
      *                                              message to be used over
      *                                              and over or changed quickly
      @ 20,74 say "]"
      read
      set cursor off
      if empty(msg) .or. lastkey() = 27
         exit
      endi
      msgtosend = trim(msg)
      tone(212,3)
      tone(275,1)
      tone(175,4)
      *
      * Novell messaging command
      *
      ! send "&msgtosend" to &server/&whoto > null
      *
      @ 23,25 say "Message has been sent to "+whoto
      wn1_buff = savescreen(10,20,13,59)
      @ 11,21 clear to 13,59
      wn1 = w_make(10,20,12,58,2,.t.,reverse)
      setcolor(reverse)
      *
      @ 11,22 SAY "Send another user a message? (y/n)"
      *
      yn = ynloop()                                   && UDF is below
      *
      @ 23,0
      w_release(wn1)
      restscreen(10,20,13,59,wn1_buff)
      w_close(wn3)
      if yn = "Y"
         tone(192,2)
         tone(310,4)
         loop
      endi
      exit
   endd         
else
   clear
   ? "No access to Server . . ."
   return
endi
setcolor(normal)
set cursor on
clear
return
*  Thats all there is.

func ynloop
   i = 0
   do while !upper(chr(i))$"YN"
      i = inke()
   endd
   return(uppe(chr(i)))
* eof
