//͸
//  Program .....: Nccvwtxt                              
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

//Ŀ
// Class NccViewTXT 
//


#include "class(y).ch"
#include "inkey.ch"
#include "fileio.ch"

#define CRLF            Chr(13)+Chr(10)


    create class  dViewTXT from NccViewit            //


    export:

       instvar  Handle                               // File handle
       instvar  FilePos             readonly         //
       instvar  FileLen             readonly         //
       instvar  MaxLineLen                           // Maximum Line Length
       instvar  Width                                // Width of display
       instvar  LeftPosition                         // Leftmost position in txt
       instvar  TabDisplacement                      // Left/Right Movement offset
       instvar  Line                readonly         // Current Line

       method   Activate                             //
       method   StandardKeys                         //
       method   Left            =  dvfLeft           //
       method   Right           =  dvfRight          //
       method   PanEnd                               //
       method   PanHome                              //

       method   dvFirst                              // Go Top
       method   dvLast                               // Go Bottom
       method   dvSkipper                            // Skip

       method   dvNextLn                             //
       method   dvPrevLn                             //

       method   dvReadLn                             //
       method   dvFileSet

    endclass


    constructor new( top, left, bottom, right, nHandle ), ;
                new( top, left, bottom, right )

    local whereAmi        :=  fseek( nHandle, 0, FS_RELATIVE )

       ::Handle           :=  nHandle
       ::FileLen          :=  fseek( nHandle, 0, FS_END )
                              fseek( nHandle, whereAmI, FS_SET )
       ::Line             :=  ""
       ::MaxLineLen       :=  512
       ::FilePos          :=  whereAmi

       ::Width            :=  right-left+1
       ::Datablock        :=  { |l| if(! l , space(::width), subs(subs(::Line, ::LeftPosition )+;
                                         space( ::Width ),1, ::Width )) }
       ::Gobottomblock    :=  { || ::dvLast()  }
       ::Gotopblock       :=  { || ::dvFirst() }
       ::Skipblock        :=  { |n| ::dvSkipper(n) }
       ::Whileblock       :=  { || fseek( nHandle, 0, FS_RELATIVE ) >= 0 .and.   ;
                                   fseek( nHandle, 0, FS_RELATIVE ) <= ::FileLen .and. ;
                                   ! ::AtBottom .and. ! ::AtTop ;
                              }
       ::LeftPosition     :=  1
       ::TabDisplacement  :=  5
       ::UseStyle         := .t.


Return


    //Ŀ
    // Activate 
    //
    method procedure Activate


    ::dvReadLn()
    ::super:Activate()

Return


    //Ŀ
    // Standard Keys 
    //
    method Function StandardKeys( nKey )

    local lProcessed := .t.

    DO CASE
      Case nKey == K_LEFT;       ::Left()
      Case nKey == K_RIGHT;      ::Right()
      Case nKey == K_CTRL_HOME;  ::PanHome()
      Case nKey == K_CTRL_END;   ::PanEnd()
      Otherwise;                 lProcessed := ::super:StandardKeys( nKey )
    END

Return( lProcessed )


    //Ŀ
    // Move Left 
    //
    method procedure dvfLeft

    IF ::LeftPosition # 1
      ::LeftPosition := max( ;
                             1, ;
                             ::LeftPosition - ::TabDisplacement ;
                           )
      ::RefreshAll()

    ELSE
     ::RefreshCurrent()

    END

Return


    //Ŀ
    // Move Right 
    //
    method procedure dvfRight

    IF ::LeftPosition < ::MaxLineLen - ::Width
      ::LeftPosition := min( ;
                             ::LeftPosition + ::TabDisplacement, ;
                             ::MaxLineLen - ::Width ;
                           )
      ::RefreshAll()

    ELSE
     ::RefreshCurrent()

    END

Return


    //Ŀ
    // Pan End 
    //
    method procedure PanEnd

    IF ::LeftPosition < ::MaxLineLen - ::Width
      ::LeftPosition := ::MaxLineLen - ::Width
      ::RefreshAll()

    ELSE
     ::RefreshCurrent()

    END

Return


    //Ŀ
    // Pan Home 
    //
    method procedure PanHome

    if ::LeftPosition # 1
      ::LeftPosition := 1
      ::RefreshAll()

    ELSE
     ::RefreshCurrent()

    Endif

Return


    //Ŀ
    // Go Top 
    //
    method procedure dvFirst


    ::FilePos := fseek( ::Handle, 0, FS_SET )
    ::dvReadLn()

Return


    //Ŀ
    // Go Bottom 
    //
    method procedure dvLast

    ::FilePos := fseek( ::Handle, 0, FS_END)
    ::dvPrevLn()

    ::FilePos := ::FileLen

Return


    //Ŀ
    // Skipper 
    //
    method Function dvSkipper(n)

    local nSkipped := 0, nDirection := if(n>0,1,-1), ;
          savefilepos := ::FilePos

    if n == 0
      Return( 0 )
    endif

    While nSkipped # n
      if n>0
        if ::dvNextLn()
          if ! ::while()
            ::dvFileSet( savefilepos )
            exit
          endif
        else
          ::dvFileSet( savefilepos )
          exit
        endif
        savefilepos := ::FilePos
      else
        if ::dvPrevLn()
          if ! ::while()
           ::dvFileSet( savefilepos )
            exit
          endif
        else
          ::dvFileSet( savefilepos )
          exit
        endif
        savefilepos := ::FilePos
      endif
      nSkipped += nDirection
    enddo

Return( nSkipped )



    //Ŀ
    // Read Next Line 
    //
    method Function dvNextLn

    local nSavePos := FSEEK( ::Handle, 0, FS_RELATIVE ), ;
          lMoved, nNewPos

    nNewPos := fseek( ::Handle, len(::Line)+2, FS_RELATIVE )  // skip over current
                                                             // line and CR/LF
    
    if ::dvReadLn()                                 // try and read a line
      lmoved := .t.                                 // from here
                                                    // we can move
      ::FilePos := fseek( ::Handle, nNewPos, FS_SET)

    else
      
      lmoved := .f.                                 //  cant move,
                                                    // restore prev file pos
      ::FilePos := fseek( ::Handle, nSavePos, FS_SET )

    endif

    ::AtTop    := .f.
    ::AtBottom := ! lMoved

Return( lmoved )


    //Ŀ
    // Read Previous Line 
    //
    method Function dvPrevLn

    local nOrigPos := FSEEK( ::Handle, 0, FS_RELATIVE ), ;
          nMaxRead, nNewPos, lMoved, cBuff, nWherecrlf, nPrev

  
    if nOrigPos == 0                         // if at start of file,
      lMoved := .f.                          //  we cant move backwards

    else
      lMoved := .t.
      fseek( ::Handle, -2, FS_RELATIVE)      // skip over preceeding CR/LF

      nMaxRead :=  min( ::MaxLineLen, FSEEK( ::Handle, 0, FS_RELATIVE ) )
      cBuff    :=  space(nMaxRead)
      nnewpos  :=  fseek( ::Handle, -nMaxread, FS_RELATIVE)
      fread( ::Handle, @cBuff, nMaxread)
      nWherecrlf := rat(CRLF, cBuff)
      if nWherecrlf == 0                     // didnt find line must be at bof
        nPrev  :=  nNewPos
        ::Line :=  cBuff

      else                                   //  found prev line
        nPrev  :=  nNewPos + nWherecrlf + 1
        ::Line :=  subs(cBuff,nWherecrlf+2)

      endif

      ::FilePos := fseek( ::Handle, nPrev, FS_SET)        // position at start of prev line

    endif

    ::AtTop := ! lMoved
    ::AtBottom := .f.

Return( lmoved )


    //Ŀ
    // Read Line 
    //
    method Function dvReadLn( tBuf )

    local nEol, nRead, nSavePos

    tbuf := if( tbuf == nil, '', tbuf )

    tBuf     := space( ::MaxLineLen )
    nSavePos := FSEEK( ::Handle, 0, FS_RELATIVE )

    nRead := FREAD( ::Handle, @tBuf, ::MaxLineLen )
    if ( nEol := at( CRLF, subs( tBuf, 1, nRead )) ) == 0
                                                   // line overflow of eof
                                                   // Line has the line we need
    else
      tBuf := subs( tBuf, 1, nEol-1 )              // copy up to eol
      ::Line := tBuf
    endif
    ::FilePos := fseek( ::Handle, nSavePos, FS_SET )

Return( nRead # 0 )


    //Ŀ
    // Set File Position 
    //
    method Function dvFileSet( xOffset )


    ::FilePos := fseek( ::Handle, xOffset, FS_SET )
    ::dvReadLn()

Return( ::FilePos )

