//͸
//  Program .....: Nccmouse                              
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//                                                       
//  Compile......: Clipper NccMouse /n/w/a/m             
//                                                       
//  Needs........: Mousesys.prg and Mouse.asm            
//                 Class(y), dGetChar.c, GetAttr.c       
//                 and SetAttr.c.                        
//                 For all C and ASM code an OBJ         
//                 and source is provided                
//                                                       
//  Purpose......: To provide mouse support              
//                                                       
//  Example......: See G_Main.prg and G_Menu.prg         
//                                                       
//;

//Ŀ
// Mouse Class 
//

#include "Class(y).ch"
#include "inkey.ch"

#define MASK    ''

//Ŀ
//         LEFT_BUTTON    1      
//         RIGHT_BUTTON   2      
//         BOTH_BUTTONS   3      
//


    create class NccMouse

       instvar  mAttr
       instvar  mChar
       method   mCursor


    export:

       instvar  isMouse      noassign
       instvar  Column       noassign
       instvar  Row          noassign
       instvar  Button       noassign
       instvar  Visible      noassign
       instvar  Ascii        noassign
       instvar  Delay

       method   Activate
       method   MouseRead
       method   Show
       method   Hide
       method   GoTo
       method   ButtonHold
       method   ClearButtons
       method   Update

   endclass



   constructor new()

      ::mAttr          :=  0
      ::mChar          :=  ''
      ::isMouse        :=  (m_Func0() == -1)
      ::Column         :=  0
      ::Row            :=  0
      ::Button         :=  0
      ::Visible        :=  .f.
      ::Delay          :=  .1
      ::Ascii          :=  0


Return


    //Ŀ
    // Activate Mouse 
    //
    method Function Activate( lShow )

    lShow := if( lShow == NIL, .t., lShow )
    if lShow
      ::Update()
      ::Show()
    else
      ::isMouse := .f.
    endif

Return( NIL )


    //Ŀ
    // Mouse Read 
    //
    method procedure MouseRead


    ::Show()

    while .t.

      ::Update()

      if ::ascii # 0
        exit
      endif

      if ::Button # 0
        pause( ::Delay )
        exit
      endif


    enddo

    ::Hide()

Return


    //Ŀ
    // Refresh Mouse 
    //
    method procedure Update

    local row := ::Row ,col := ::Column

    if ::isMouse
       ::Row     := int(m_Func3Y() / 8)
       ::Column  := int(m_Func3X() / 8)
       ::Button  := m_Func3B()
       if ::Button # 0
         keyboard ''
         ::ascii := 0
       endif

       if ::Visible .and. ( row # ::Row .or. col # ::Column )

         PutChar( row,col,::mChar)
         SetAttr( row,col,row,col, ::mAttr )
         ::mAttr := GetAttr(::Row,::Column)
         ::mChar := dGetChar(::Row,::Column)
         if ::mChar $ MASK
           PutChar(::Row,::Column, '')
         endif
         SetAttr( ;
                 ::Row, ::Column, ::Row, ::Column, ;
                  Reverse(::mAttr);
                )
       endif

    endif

    if ::button == 0
      ::ascii := Ncc_k_wait()
    endif

Return


    //Ŀ
    // GoTo 
    //
    method Function Goto( nRow, nCol )


    local isVisible := ::Visible

    if isVisible
      ::Hide()
    endif

    if ::isMouse
      m_Func4((( nRow % 50) * 8), (( nCol % 80) * 8))
      ::Row    := nRow
      ::Column := nCol
    endif

    if isVisible
      ::Show()
    endif

Return( NIL )


    //Ŀ
    // Show 
    //
    method procedure Show

    ::mCursor(.t.)

Return 


    //Ŀ
    // Hide 
    //
    method procedure Hide

    ::mCursor(.f.)

Return


    //Ŀ
    // Mouse cursor 
    //
    method function mCursor( bShow )

    local bCursor

    if ::isMouse
       bCursor := ::Visible

       if bShow
         if ! bCursor
           ::Visible := .t.
           ::mAttr := GetAttr( ::Row, ::Column )
           ::mChar := dGetChar( ::Row, ::Column )
           if ::mChar $ MASK
             PutChar(::Row,::Column, '')
           endif
           SetAttr( ;
                   ::Row, ::Column, ::Row, ::Column, ;
                    Reverse(::mAttr);
                  )
         endif
       else
         if bCursor
           ::Visible := .f.
           PutChar( ::Row, ::Column, ::mChar )
           SetAttr( ::Row, ::Column, ::Row, ::Column, ::mAttr)
         endif
       endif
    endif

Return( NIL )


    //Ŀ
    // Test if Mouse Button is being pressed 
    //
    method function ButtonHold( nButton )

Return (m_Func3B() == nButton)


    //Ŀ
    // Clear Buttons 
    //
    method procedure ClearButtons

    ::Button := 0
    ::Ascii := 0

Return

//
// 
//


static function pause( nTime )

    local nSecs

    if nTime > 0
       nSecs := seconds()
       while StopWatch(nSecs, seconds()) <= nTime
       enddo
    endif

Return( NIL )


static function StopWatch(nStart, nStop)

    if nStart > nStop
       nStop := nStop + 86400
    endif

return (nStop - nStart)


static function Reverse( nColor )

    local nRet := int((( nColor % 16 ) * 16) + ( nColor / 16 ))

    if SetBlink()
      if nRet > 127
        nRet -= 128
      endif
    endif

    if nRet == 0 .or. nRet == 128 .or. nRet == 119
      nRet := 112
    endif

    if nColor == nRet
      nRet -= 7
    endif

Return( nRet )


static function putchar( r,c,char )

    local row := row(), ;
          col := col()

    @r,c say char
    setpos(row,col)

Return(NIL)
