//͸
//  Program .....: Nccvwarr                              
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//  Purpose......: To browse an array. OOP code          
//                                                       
//  Needs  ......: NccView prg object code and Class(y)  
//                                                       
//  Compile......: Clipper nccvwarr /n/w/a/m             
//                                                       
//                                                       
//;

//Ŀ
// Class dViewARRAY 
//


#include "class(y).ch"
#include "inkey.ch"


    create class  dViewARRAY from NccViewit          //

    export:

       instvar  dView_Array                          //
       instvar  CurrentItem                          //

       method   dvArraySkip                          //

    endclass


    constructor new( top, left, bottom, right, aArray ), ;
                new( top, left, bottom, right )


    ::dView_Array       :=  aArray
    ::CurrentItem       :=  1
    ::WhileBlock        :=  { || .t. }
    ::DataBlock         :=  { || ::dView_Array[ ::CurrentItem ]  }
    ::SkipBlock         :=  { |n| ::dvArraySkip(n) }
    ::GoTopBlock        :=  { || ::CurrentItem := 1 }
    ::GoBottomBlock     :=  { || ::CurrentItem := len( ::dView_Array ) }


Return


    //Ŀ
    // Array Skip 
    //
    method Function dvArraySkip( n )

    local x := ::CurrentItem

    if x + n < 1
      ::CurrentItem := 1
      Return( -x+1 )

    elseif x + n > len( ::dView_Array )
      ::CurrentItem := len( ::dView_Array )
      Return( len( ::dView_Array ) - x )

    endif

    ::CurrentItem += n

Return( n )
