//͸
//  Program .....: Explode                               
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;


#include "c:\clipper5\include\extend.h"
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <dos.h>
#define VSYNC   while ((inp(0x3da) & 01) == 0); \
                while((inp(0x3da) & 01) != 0);

#define FALSE        0
#define TRUE         1

/****************************************************
*        Draws exploding windows.                   *
*                                                   *
* EXPLODE(ULR,ULC,LRR,LRC,DELAY,W_TYPE)             *
*                                                   *
* ULR...: Upper left row.                           *
* ULC...: Upper left column.                        *
* LRR...: Lower right row.                          *
* LRC...: Lower right column.                       *
* DELAY.: Explosion delay                           *
* W_TYPE: Window type                               *
*                                                   *
*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
*             - - -  Window type  - - -             *
*  numeric                                          *
*          1=Single Borders                         *
*          2=Double Borders                         *
*          3=Single Top & Bottom With Double sides  *
*          4=Double Top & Bottom With Single sides  *
*          5=Solid Borders                          *
* Character                                         *
*          Frame Defined in Character Variable      *
*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
*                                                   *
* NB.. Before Calling, Set color within clipper to  *
*      the color you wish for the screen and place  *
*      a character within the boundaries of the     *
*      exploding screen.                            *
*                                                   *
*  ie. Routine will take the attribute at the       *
*     current Cursor position.                      *
****************************************************/

CLIPPER explode()

{
  long address;
  int rows, ulc, ulr, lrr, lrc, row1, col1, row2, col2, box_type, xfill, first, delay_l, col, row, tc;
  char *start, *stop, ts[9];
  register char *middle;
  register int count;
  union REGS regs;

  row1=_parni(1);
  col1=_parni(2);
  row2=_parni(3);
  col2=_parni(4);
  delay_l = _parni(5);

  if ISCHAR(6)
  {
    box_type = 6;
    strcpy(ts, _parc(6,0));
  }
  else
      box_type=_parni(6);



  /* Set up the beginning column positions. */

  if ((col2-col1) > 3)
  {
     ulc=col1+((col2-col1)/2)-1;
     lrc=col1+((col2-col1)/2)+1;
  }
  else
  {
     ulc=col1;
     lrc=col2;
  }


  /* Set up the beginning row positions. */

  if ((row2-row1) > 3)
  {
     ulr=((row2-row1)/2)-1+row1;
     lrr=((row2-row1)/2)+1+row1;
  }
  else
  {
    ulr=row1;
    lrr=row2;
  }
  first=1;


  /* Determine whether mono or color adapter. */

  int86(0x11,&regs,&regs);
  if ((regs.h.al & 0x30) == 0x30)
     address=0xb0000000l;
  else
     address=0xb8000000l;


  /* Get Cursor Position */

  regs.h.ah = 3;
  regs.h.bh = 0;
  int86(0x10, &regs, &regs);
  col=regs.h.dl;
  row=regs.h.dh;

  scrn_pos(row,--col);

  /* Read Character Attribute at Position */

  regs.h.ah =8;
  regs.h.bh = 0;
  int86(0x10, &regs, &regs);


  /* Attribute of Exploding Window */

  xfill = regs.h.ah;


  /* BEGIN */

  while (ulr != 30)
  {
        if (address == 0xb8000000l)
        {
           VSYNC
        }
        /* These for loops are used to clear the screen. */
        if (first == 1)
        {
           start=(char *)(address+(ulr*160)+(ulc*2));
           stop=(char *)(address+(ulr*160)+(lrc*2));
           for (rows=0; rows < lrr - ulr + 1; rows++)
           {
               for (middle=(char *)(start); middle <= stop+1;)
               {
                   *(middle)++=32;
                   *(middle)++=xfill;
               }
               start=(char *)(start+160);
               stop=(char *)(stop+160);
           }
        }
        else
        {
           start=(char *)(address+(ulr*160)+(ulc*2));
           stop=(char *)(address+(ulr*160)+(lrc*2));
           for (middle=(char *)(start); middle <= stop+1;)
           {
                   *(middle)++=32;
                   *(middle)++=xfill;
           }
           start=(char *)(address+((ulr+1)*160)+(ulc*2));
           stop=(char *)(address+((ulr+1)*160)+(lrc*2));
           for (middle=(char *)(start); middle <= stop+1;)
           {
                   *(middle)++=32;
                   *(middle)++=xfill;
           }
           for (rows=0; rows < lrr - ulr - 1; rows++)
           {
               start=(char *)(start+160);
               stop=(char *)(stop+160);
               middle=(char *)(start);
               for (count=1; count < 6; count++)
               {
                   *(middle)++=32;
                   *(middle)++=xfill;
               }
               middle=(char *)(stop-8);
               for (count=1; count < 6; count++)
               {
                   *(middle)++=32;
                   *(middle)++=xfill;
               }
           }
           start=(char *)(address+((lrr-2)*160)+(ulc*2));
           stop=(char *)(address+((lrr-2)*160)+(lrc*2));
           for (middle=(char *)(start); middle <= stop+1;)
           {
                   *(middle)++=32;
                   *(middle)++=xfill;
           }
           start=(char *)(address+((lrr-1)*160)+(ulc*2));
           stop=(char *)(address+((lrr-1)*160)+(lrc*2));
           for (middle=(char *)(start); middle <= stop+1;)
           {
                   *(middle)++=32;
                   *(middle)++=xfill;
           }
           start=(char *)(address+(lrr*160)+(ulc*2));
           stop=(char *)(address+(lrr*160)+(lrc*2));
           for (middle=(char *)(start); middle <= stop+1;)
           {
                   *(middle)++=32;
                   *(middle)++=xfill;
           }
        }
        first++;


        /***********************
        * Start building frame *
        ************************/

        /* Top Left corner */

        start=(char *)(address+(ulr*160)+(ulc*2));
        stop=(char *)(address+(ulr*160)+(lrc*2));

        switch (box_type)
        {
          case 1 :
           *(start)=218;
           break;

          case 2 :
           *(start)=201;
           break;

          case 3 :
           *(start)=214;
           break;

          case 4 :
           *(start)=213;
           break;

          case 5 :
           *(start)=219;
           break;

          case 6 :
           *(start)=ts[0];
           break;

        }

       /* Top */

        for (middle=(char *)(start+2); middle < stop; middle++)
        {
            if ((box_type == 1) || (box_type == 3))
               *(middle)++=196;
            else
              if ((box_type == 2) || (box_type == 4))
               *(middle)++=205;
              else
                if (box_type == 5)
                 *(middle)++=223;
                else
                  if (box_type == 6)
                   *(middle)++=ts[1];
        }

        /* Top Right Corner */

        switch (box_type)
        {
          case 1 :
           *(stop)=191;
           break;

          case 2 :
           *(stop)=187;
           break;

          case 3 :
           *(stop)=183;
           break;

          case 4 :
           *(stop)=184;
           break;

          case 5 :
           *(stop)=219;
           break;

          case 6 :
           *(stop)=ts[2];
           break;

        }

        /* Sides */

        for (rows=1; rows < lrr - ulr; rows++)
        {
            start=(char *)(start+160);
            stop=(char *)(stop+160);
            if ((box_type == 1) || (box_type == 4))
            {
               *(start)=179;
               *(stop)=179;
            }
            else
              if ((box_type == 3) || (box_type == 2))
              {
                    *(start)=186;
                    *(stop)=186;
              }
              else
                if (box_type == 5)
                {
                  *(start)=219;
                  *(stop)=219;
                }
                if (box_type == 6)
                {
                  *(start)=ts[7];
                  *(stop)= ts[3];
                }
        }

        start=(char *)(address+(lrr*160)+(ulc*2));
        stop=(char *)(address+(lrr*160)+(lrc*2));


        /* Bottom Right Corner */

        switch (box_type)
        {
          case 1 :
           *(stop)=217;
           break;

          case 2 :
           *(stop)=188;
           break;

          case 3 :
           *(stop)=189;
           break;

          case 4 :
           *(stop)=190;
           break;

          case 5 :
           *(stop)=219;
           break;

          case 6 :
           *(stop)=ts[4];
           break;

        }

        /* Bottom Line */

        for (middle=(char *)(start+2); middle < stop; middle++)
        {
            if ((box_type == 1) || (box_type == 3))
               *(middle)++=196;
            else
              if ((box_type == 2) || (box_type == 4))
                *(middle)++=205;
              else
                if (box_type == 5)
                  *(middle)++=220;
                else
                  if (box_type == 6)
                    *middle++=ts[5];

        }


        /* Bottom Left Corner */

        switch (box_type)
        {
          case 1 :
           *(start)=192;
           break;

          case 2 :
           *(start)=200;
           break;

          case 3 :
           *(start)=211;
           break;

          case 4 :
           *(start)=212;
           break;

          case 5 :
           *(start)=219;
           break;

          case 6 :
           *(start)=ts[6];
           break;

        }


        /****************
        * Frame Defined *
        ****************/


        if ((ulr == row1) && (lrr == row2) && (ulc == col1) && (lrc == col2))
           break;
        if (ulr != row1)
        {
           --ulr;
           ++lrr;
        }
        if (ulc != col1)
        {
           ulc=ulc-3;
           lrc=lrc+3;
        }
        if ((ulr == row1) || (lrr == row2))
        {
           ulr=row1;
           lrr=row2;
        }
        if ((ulc <= col1) || (lrc >= col2))
        {
           ulc=col1;
           lrc=col2;
        }

        /* Delay Loop */

        tc = t_counts();
        while (t_counts() - tc < delay_l)
        ;
  }
  _ret();
}


/* Tick Count from Clock */

int t_counts()
{
 union REGS rout;
 int tc;

 rout.h.ah = 0;
 int86(0x1a, &rout, &rout);
 tc = ((long) rout.x.cx) << 16;
 tc += rout.x.dx;

 return tc;
}

/*******************************************/
scrn_pos(x,y)
int x, y;
{
    union REGS regs;

    regs.h.ah = 2;
    regs.h.bh = 0;
    regs.h.dl = y;
    regs.h.dh = x;
    int86(0x10, &regs, &regs);
}
