* Program: ClosNctr.prg
* Author:  Gerry S. Braganza
* Version: Clipper Summer '87
* Note(s): Close_Encounters program to demonstrate a technique to
*          produce pseudo-random numbers.
*
* Copyright (c) 1988 Nantucket Corp.

* Declare array to hold color table.
DECLARE arr_color[10]

arr_color[1]="N"                  && Black.
arr_color[2]="B"                  && Blue.
arr_color[3]="G"                  && Green.
arr_color[4]="BG"                 && Cyan.
arr_color[5]="R"                  && Red.
arr_color[6]="RB"                 && Magenta.
arr_color[7]="GR"                 && Brown.
arr_color[8]="W"                  && White.
arr_color[9]="N+"                 && Gray.
arr_color[10]="GR+"               && Yellow.

PUBLIC rsd, bsd, mmax

* Initialize ever-changing seed.
rsd =.123456789 + SECONDS()/1000 + DAY(DATE())/10

* Initialize - prime numbers are generally good seeds.
bsd = 31415821

mmax = 1000000.0                       
tmp=space(0)                      && Initialize character or
                                  ** string holder.
CLEAR

DO WHILE .T.
   FOR I=1 TO 10000
      tmp = RandomChar(1)         && Call RandomChar passing 1 as
                                  && size of string.
       x = INT((rsd * 11) % 11)   && Random integer between
                                  ** 0 and 10 for color.

       rsd=Rndm()                 && Issue another Rndm call.
       a = INT((rsd * 24) % 24)   && Random integer between
                                  ** 0 and 23 for row position.

       rsd=Rndm()                 && And another call!
       b = INT((rsd * 80) % 80)   && Random integer between
                                  ** 0 and 79 for column position.

       IF x <= 0                  && Check whether x = 0, if true
          x = x + 1               && then increment for color array
       ENDIF                      && position.

       y = arr_color[x]           && Assign color variable.

       IF y = "N"                 ** If color is black,
          SETCOLOR("W")           && set to white.
       ELSE
          SETCOLOR("&y.")         && Set to appropriate color.
       ENDIF

       rsd=Rndm()                 && Just one more time!
       TONE(((rSD * 1000) % 1000),(((Rndm()) * 6) % 6)) && Sounds.
       @ a, b SAY tmp             && Display character.

   NEXT
   ?
   ?
   ? 'Any key to continue, Q to quit . . . '
   ?
   SET CONSOLE OFF
   WAIT TO quit
   SET CONSOLE ON
   IF quit$'Qq'
      EXIT                        && Let's go home.
   ENDIF
ENDDO
@ 23,0
QUIT


* Rndm()
* Generates a random value between 0 and 1
*
FUNCTION Rndm

* Divide the result of the equation by mmax to get a random
* number between 0 and 1.
rsd = ((rsd*bsd + 1) % Mmax) / Mmax

RETURN(rsd)                       && Return random number.


* RandomChar()
*
FUNCTION RandomChar
PARAMETERS size                   && Size of char. or string.
PRIVATE i, temptext
temptext = space(0)               ** Char//string place holder.

FOR i = 1 to size
   rsd = Rndm(rsd)                && Call thee.
   * Upper case letters A - Z.
   * If you like lower case letters, change 65 to 97.
   temptext = temptext + chr(26*rsd+65) 
NEXT
RETURN(temptext)
