*:**********************************************************
*:
*:        Program: NAME_FIX.PRG
*:
*:         System: Name_Fix
*:         Author: Mike Harner
*:                 407-725-0747 (voice)
*:      Copyright (c), Public Domain
*:  Last modified: 08/14/89      5:32
*:
*:           Uses: &TARGET        
*:               : TEMP.DBF       
*:               : NEW_DATA.DBF   
*:
*:      Documented 08/15/89 at 06:49                
*:**********************************************************
************************************************************
**
**	Program to convert a NAME field
**	from one which contains First, Last and Middle names
**	to 3 new fields ;
**		LNAME -- Last Name
**		FNAME -- First Name
**		MNAME -- Middle Name/Initial
**
** Assuming that the NAME field contains the following :
**		LastName FirstName MiddleName
**		all are separated (as shown) with 1 space
**
**		Your Name field is named NAME and
**		no existing fields are named LNAME,FNAME,MNAME
************************************************************
SET TALK OFF
SET SAFETY OFF

CLEAR
target = 'C:\DBASE\YourFile.DBF                  '
@ 10,5 SAY 'Enter YOUR Database Name as: ' GET target
READ

IF FILE('TEMP.DBF')
   ERASE temp.DBF
ENDIF file('TEMP.DBF')

IF FILE('NEWDATA.DBF')
   ERASE new_data.DBF
ENDIF file('NEWDATA.DBF')

USE &target
COPY STRUCTURE EXTENDED TO temp
USE

SELECT 2
USE temp

APPEND BLANK
REPLACE field_name WITH 'LNAME'
REPLACE field_type WITH 'C'
REPLACE field_len WITH 20			&& you may need to shorten this
REPLACE field_dec WITH 0

APPEND BLANK
REPLACE field_name WITH 'FNAME'
REPLACE field_type WITH 'C'
REPLACE field_len WITH 20			&& you may need to shorten this
REPLACE field_dec WITH 0

APPEND BLANK
REPLACE field_name WITH 'MNAME'
REPLACE field_type WITH 'C'
REPLACE field_len WITH 20			&& you may need to shorten this
REPLACE field_dec WITH 0

USE
SELECT 1
CREATE new_data FROM temp

APPEND FROM &target

REPLACE ALL lname WITH SUBST(name, 1, AT(' ', name)-1)
REPLAC ALL fname WITH SUBST(name, AT(' ',name)+1, LEN(name))
REPLAC ALL mname WITH RIGHT(fname,LEN(fname)-AT(' ', fname))
REPLACE ALL fname WITH SUBST(fname, 1, AT(' ', fname))

LIST OFF NAME, LNAME, FNAME, MNAME

ERASE temp.DBF

CANCEL
*: EOF: NAME_FIX.PRG
