/* READMEM.C                                                          */
/* by Michael Smith - October, 1989                                   */
/*                                                                    */
/* Stand Alone Program to open and display the contents of a Memory   */
/* File.  (Dates are not displayed properly).                         */
/*                                                                    */
/* Compile using the Alternate Library and the Large Model.           */
/*                                                                    */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <malloc.h>
#include <io.h>

typedef   unsigned char byte ;

#define VAR_CHAR    0xC3
#define VAR_DATE    0xC4
#define VAR_LOG     0xCC
#define VAR_NUM     0xCE
#define BUF_SIZE    401

double _CDECL pow(double, double);

void main(int argc, char * argv[])
{

     int      File, Power, Minus, finish_flag, linecnt ;
     unsigned int V_Len, Read_Len ;
     byte     *_Work, V_Name[11], V_Type[2], Filename[80] ;
     byte     *Buffer ;
     double   Mantissa, Value ;

/*   printf("Available Before=%u\n",_memavl()) ; */
     if ((_Work = (byte *)malloc(80)) == NULL) return ;
     if ((Buffer = (byte *)malloc((long)BUF_SIZE)) == NULL) return ;
/*   printf("Available Now=%u\n",_memavl()) ;     */

     File = open(argv[1], O_RDONLY | O_BINARY) ;
     if (File == -1)
     {
          strcpy(Filename,argv[1]) ;
          strcat(Filename,".MEM") ;
          File = open(Filename, O_RDONLY | O_BINARY) ;
          if (File == -1)
          {
               if (argc < 2)
               {
                    File = open("MEMORY.MEM",O_RDONLY | O_BINARY) ;
                    if (File == -1)
                    {
                         puts("\nError: READMEM <Filename>  (Default is MEMORY.MEM)") ;
                         return ;
                    }
               } else {
                    printf("\nError opening file %s.\n",argv[1]) ;
                    return ;
               }
          }
     }

     linecnt = 1;

     while (1)
     {
          read(File, V_Name,11) ;
      /*  printf("Name...") ; */
          if (eof(File)) break ;

          read(File, V_Type,1) ;
          read(File, _Work,4) ;
          read(File, _Work,2) ;
          V_Len = _Work[0] ;
          V_Len = V_Len + _Work[1] * 256 ;
          read(File, _Work,14) ;
     /*   printf("Type & Len...") ; */

          if (V_Type[0] != VAR_NUM && V_Type[0] != VAR_DATE &&
          V_Type[0] != VAR_CHAR && V_Type[0] != VAR_LOG)
          {
               puts("\nInvalid Memory File.") ;
               break ;
          }

          if (V_Type[0] == VAR_DATE || V_Type[0] == VAR_NUM) V_Len = 8 ;
     /*   printf("(%u)",V_Len) ;      */

          if (V_Len < BUF_SIZE)
          {
       /*      printf("Allocate %u...",V_Len) ; */
               finish_flag = 0 ;
               Read_Len = V_Len ;
          } else
          {
           /*  printf("Allocate 401...") ; */
               finish_flag = 1;
               Read_Len = 400 ;
          }
          if (Buffer)
          {
          /*   printf("Reading...") ; */
               read(File,Buffer,Read_Len) ;
          /*   printf("Ok..") ; */
               if (V_Type[0] == VAR_NUM || V_Type[0] == VAR_DATE)
               {
               /*   printf("Convert...") ; */
                    Value = (Buffer[7] % 128) * 16 ;
                    Power = Value + (Buffer[6]/16) - 1023 ;
                    if ((Buffer[7]/16) >= 8) Minus = 1 ; else Minus = 0 ;

                    Mantissa = (float)(Buffer[6] % 16) /16 ;

                    Value = Buffer[4] ;
                    Value = Value + Buffer[5] * 256 ;
                    Mantissa = Mantissa + Value/(65536 * 16) ;

                    Value = Buffer[2] ;
                    Value = Value + Buffer[3] * 256 ;
                    Mantissa = Mantissa + Value/(pow(65536,2) * 16) ;

                    Value = Buffer[0] ;
                    Value = Value + Buffer[1] * 256 ;
                    Mantissa = Mantissa + Value/(pow(65536,3) * 16) ;

                    Value = (1 + Mantissa) * pow(2.0, Power) ;

                    if (Minus) Value = -1 * Value ;
               }

               Buffer[V_Len] = 0 ;

          /*   printf("Printing...\n") ; */
               if (linecnt > 22)
               {
                    printf("                    ....Press any key for Next Page....\n") ;
                    linecnt = 0 ;
                    getch() ;
               }
               switch (V_Type[0])
               {
                    case (VAR_LOG) :
                         if (Buffer[0] == 1) Buffer[0] = 84 ;
                         if (Buffer[0] == 0) Buffer[0] = 70 ;
                         printf("%s = .%1s.\n",V_Name, Buffer) ;
                         linecnt++ ;
                         break ;
                    case (VAR_NUM) :
                         printf("%s = %f\n",V_Name, Value) ;
                         linecnt++ ;
                         break ;
                    case (VAR_DATE) :
                         printf("%s = (Date) %g\n",V_Name, Value) ;
                         linecnt++ ;
                         break ;
                    default :   /* case (VAR_CHAR) : */
                         if (V_Len <= 401) printf("%s = '%s'\n",V_Name, Buffer) ;
                         else
                         {
                              Buffer[400] = 0 ;
                              printf("%s = (first 400) '%s'...\n",V_Name, Buffer) ;
                              linecnt = linecnt + 5 ;
                         }
                         linecnt++ ;
                         break ;
               }

             /* If did not read in entire string before, move up pointer */
               if (finish_flag && Buffer)  lseek(File,tell(File)+(V_Len - 400),0) ;

          } /* If allocated Memory for Buffer */
          else
          {
               printf("%s = (Couldn't Allocate Memory to Read in %u bytes.\n",V_Len) ;
               lseek(File,tell(File)+V_Len,0) ;
          }
     } /* End While */
     close(File) ;
     free(Buffer) ;
     free(_Work) ;
/*   printf("Gave Back Buffers...\n") ;
     printf("Available After=%u\n",_memavl()) ; */
}
