; ISEXPAND.ASM
;
; For Clipper '87.  ISEXPAND()
; Returns The amount of Expanded Memory Installed
;
; Written By Michael Smith, November 07, 1989.

EXTRN    __RETNI:FAR

DGROUP   GROUP     DATASEG
DATASEG  SEGMENT   '_DATA'

EMM_ID   DB        'EMMXXXX0'

DATASEG            ENDS

_TEXT    SEGMENT BYTE    'CODE'         ; CODE IS THE REQUIRED CLASS
         ASSUME  CS:_TEXT,DS:DGROUP

         PUBLIC   ISExpand

ISExpand PROC      FAR

         PUSH      BP
         MOV       BP,SP
         PUSH      DS
         PUSH      ES
         PUSH      SI
         PUSH      DI

         MOV       AX,03567h            ; Call DOS Interrupt
         INT       021h
         MOV       DI,0Ah
         LEA       SI,EMM_ID            ; Load the address of the EMM Device
         MOV       BX,0                 ; clear the offset counter

ISTHERE: MOV       AL, BYTE PTR DS:[SI+BX]     ; Looking at EMM_ID
         MOV       CL, BYTE PTR ES:[DI+BX]     ; Looking at Return addr
         CMP       AL,CL                ; are the bytes equal
         JNE       NOEXTND              ; No, get out
         INC       BL                   ; increment the counter/offset
         CMP       BL,8                 ; have we done 8 bytes yet?
         JL        ISTHERE

         MOV       AH,042h       ; Call the interrupt to find out
         INT       067h          ; how much Expanded is installed
         MOV       AX,BX         ; move the return value to the AX
         JMP       DONE

NOEXTND:
         MOV       AX,0   ; Clear the AX for return of 0.
DONE:
         PUSH      AX            ; Amount of Expanded Memory
         CALL      __RETNI       ; Call Clippers Return Integer function
         ADD       SP,2          ; Reset Stack.

         POP       DI
         POP       SI
         POP       ES
         POP       DS
         POP       BP
         RETF

ISExpand ENDP

_TEXT    ENDS
END
