;**********************************************************************
; Adapted from NODE.ASM from PC Magazine Vol 7, #16; Sept 27, 1988
; by Michael Smith - September, 1989
;**********************************************************************
;
; Node (c) 1987 by Jeffrey Diehl,  Released to the Public Domain.
;
; Get the 12-digit Hex address of the Novell workstation then convert
; it to an ASCII string to return to Clipper.
;
;**********************************************************************

PUBLIC             NETNODE

EXTRN              __RETC:FAR

DGROUP   GROUP     DATASEG
DATASEG  SEGMENT   '_DATA' ; _DATA IS THE REQUIRED CLASS

NODEADDR DW        16 DUP  (0)     ;       CODE FOR SUMMER 87
         DB        0
CX4      DW        ?
BX4      DW        ?
AX4      DW        ?

GETSTN   EQU       0DCh       ; Get Station Call to Novell
GETNWAD  EQU       0EEh       ; Get Node Address Call to Novell
DOS      EQU       21h        ; DOS Interrupt

DATASEG            ENDS

CODESEG            SEGMENT BYTE    'CODE'  ; CODE IS THE REQUIRED CLASS
                   ASSUME  CS:CODESEG,DS:DGROUP   ;  CODE FOR SUMMER 87

NETNODE  PROC      FAR

; Clipper Initialization Procedure.
         PUSH      BP
         MOV       BP,SP
         PUSH      DS
         PUSH      DX
         PUSH      CX
         PUSH      SI

; Clear the Block where the Address with go
         MOV       AX,0
         MOV       CL,20
         LEA       SI,NODEADDR
CLEAR:   MOV       BYTE PTR DS:[SI],AL
         INC       SI
         DEC       CL
         CMP       CL,0
         JNE       CLEAR

; See if Netware Shell is Active
         MOV       AH, GETSTN
         INT       DOS        ; Call to Shell for Status
         CMP       AL,0       ; Return is in AL
         JA        GET_ADDR   ;
         JMP       DONE

GET_ADDR:
         MOV       AH,GETNWAD ; Call to Shell for Node Address
         INT       DOS
         MOV       AX4, AX    ; Store the address before
         MOV       BX4, BX    ; playing with it.
         MOV       CX4, CX

; First insure the address returned is OK.  If last 2 characters are
; 0, then check if last 8 are 0, just to be certain.
         CMP       AX,0
         JA        NET_OK
         MOV       AX,BX
         CMP       AX,0
         JA        NET_OK
         JMP       DONE

NET_OK:
; Convert the Address to ASCII and Store it.
         LEA       SI,NODEADDR      ; Load SI with offset address.
         MOV       AX,CX4           ; Convert each word and store it.
         CALL      HEX2STR
         MOV       AX,BX4
         CALL      HEX2STR
         MOV       AX,AX4
         CALL      HEX2STR

; Now return string to Clipper.
DONE:    LEA       SI,NODEADDR    ; DS:SI = Address of Buffer
         PUSH    DS               ; Push Segment
         PUSH    SI               ; Push Offset
         CALL    __RETC           ; Call Clippers Return String Routine.
         ADD     SP,4             ; Reset Stack.
         POP     SI               ; Restore values of registers
         POP     CX
         POP     DX
         POP     DS
         POP     BP
         RETF                    ; Catch Ya on the Flip Side.

; Convert Hex to ASCII.
HEX2STR  PROC      NEAR       ; AX contains word to convert.
         MOV       BX,AX      ; DS:SI is address of buffer.
         MOV       CL,04
         MOV       CH,04

LOOPIT:  ROL       BX,CL      ; Rotate Left 4 bits
         MOV       AL,BL
         AND       AL,0Fh     ; mask upper 4 bits
         ADD       AL,90h
         DAA                  ; decimal adjust for adding
         ADC       AL,40h
         DAA
         MOV       BYTE PTR DS:[SI],AL   ; Store ASCII code in Buffer.
         INC       SI                    ; Increment Offset of Buffer
         DEC       CH                    ; Decrement Counter.
         CMP       CH,0
         JNZ       LOOPIT                ; Loop if not done with word.
         RET
HEX2STR  ENDP

NETNODE  ENDP
CODESEG  ENDS
         END

; End GETNODE.ASM
