; ARGV.ASM - ARGV([int])
; For Clipper.
;
; Return execution parameters specified by the [int] parm.
;
; ARGV()  Returns back the Number of Parameters (less the path)
; ARGV(0) Returns back the Path & File Name.
; ARGV(1) Returns back the first command line parm (NULL if none).
;
; Written By Michael Smith, November 2, 1989.

EXTRN    ___argv:WORD     ; Pointer to Address of Parm Strings.
EXTRN    ___argc:WORD     ; Count of Parms (including path\file.exe)
EXTRN    __RETC:FAR
EXTRN    __RETNI:FAR
EXTRN    __PARINFO:FAR
EXTRN    __PARNI:FAR

_TEXT    SEGMENT BYTE PUBLIC 'CODE'
         ASSUME  CS:_TEXT

         PUBLIC   ARGV

ARGV     PROC      FAR
         PUSH      BP            ; Save Enviroment
         MOV       BP,SP
         PUSH      DS
         PUSH      CX
         PUSH      BX
         PUSH      SI

         MOV       AX,1          ; See if parameter 1 is numeric
         PUSH      AX
         CALL      __PARINFO
         ADD       SP,2
         CMP       AX,2
         MOV       CX,0
         JNE       RETCNT        ; if not then return the parm count
         MOV       AX,1          ; Get the Number
         PUSH      AX
         CALL      __PARNI
         ADD       SP,2
         MOV       CX,AX         ; Store # into CX.

GO:      MOV       AX,[___argv]
         MOV       BX,[___argv+2]       ; BX:AX - Address of Address
         MOV       DS,BX
         MOV       SI,AX
         MOV       AX,DS:[SI]           ; BX:AX - Address of String
         MOV       BX,DS:[SI+2]
         MOV       DS,BX
         MOV       SI,AX
         MOV       BX,CX         ; Save CX into BX
         CMP       CX,0          ; If looking for Parm0, return
         JE        RETURNIT

LOOPIT:  CMP       BYTE PTR DS:[SI+1],0 ; Look for End of String.
         JE        DECCX
         INC       SI            ; Increment the Offset.
         JMP       LOOPIT
DECCX:   DEC       CX            ; Decrease the parm counter
         INC       SI            ; Increment so pointing @ 0 byte
         CMP       CX,0          ; If looking for Parm0, return
         JNE       LOOPIT
         CMP       BX,___argc    ; Compare Parm# to # of parms
         JGE       RETURNIT      ; If >=, then point to 0 and return
         INC       SI            ; Increment so pointing @ next string

RETURNIT:
         PUSH      DS            ; Push Segment
         PUSH      SI            ; Push Offset
         CALL      __RETC        ; Call Clippers Return String Routine.
         ADD       SP,4          ; Reset Stack.
         JMP       GETOUT

RETCNT:  MOV       AX,___argc    ; Return the Parm count -1
         DEC       AX
         PUSH      AX
         CALL      __RETNI
         ADD       SP,2

GETOUT:  POP       SI            ; Restore values of registers
         POP       BX
         POP       CX
         POP       DS
         POP       BP
         RETF                    ; I'm Out of Here!!
ARGV     ENDP

_TEXT    ENDS
END
